/*
 * Decompiled with CFR 0.152.
 */
package jp.coppermine.voyager.xlsmaker;

import java.io.IOException;
import java.io.OutputStream;
import jp.coppermine.voyager.beans.BeanWrapper;
import jp.coppermine.voyager.beans.filter.FilteredBeanWrapper;
import jp.coppermine.voyager.beans.filter.impl.ConvertFilter;
import jp.coppermine.voyager.beans.filter.impl.FormatFilter;
import jp.coppermine.voyager.xlsmaker.XlsMakerException;
import jp.coppermine.voyager.xlsmaker.annotations.Offset;
import jp.coppermine.voyager.xlsmaker.annotations.Sheet;
import jp.coppermine.voyager.xlsmaker.coord.ColumnProvider;
import jp.coppermine.voyager.xlsmaker.coord.ColumnUnit;
import jp.coppermine.voyager.xlsmaker.coord.RowProvider;
import jp.coppermine.voyager.xlsmaker.coord.RowUnit;
import jp.coppermine.voyager.xlsmaker.filter.CellFilter;
import jp.coppermine.voyager.xlsmaker.filter.GridFilter;
import jp.coppermine.voyager.xlsmaker.filter.RangeFilter;
import jp.coppermine.voyager.xlsmaker.filter.RangesFilter;
import jp.coppermine.voyager.xlsmaker.filter.StyleFilter;
import jp.coppermine.voyager.xlsmaker.model.XSheet;
import jp.coppermine.voyager.xlsmaker.model.XWorkbook;
import jp.coppermine.voyager.xlsmaker.model.XWorkbookFinder;

public class XlsMaker {
    private XWorkbook xWorkbook;

    public XlsMaker(XWorkbookFinder finder) {
        this.xWorkbook = XWorkbook.open(finder);
    }

    public void bind(Object obj, RowProvider rowOffsetProvider, ColumnProvider columnOffsetProvider) {
        FilteredBeanWrapper bean = new FilteredBeanWrapper(BeanWrapper.getAdvancedWrapper(obj));
        Sheet sheet = bean.getTypeAnnotation(Sheet.class);
        if (sheet == null) {
            return;
        }
        XSheet xSheet = this.xWorkbook.getSheet(sheet.index());
        RowUnit rowOffset = RowUnit.from(rowOffsetProvider);
        ColumnUnit columnOffset = ColumnUnit.from(columnOffsetProvider);
        Offset offset = bean.getTypeAnnotation(Offset.class);
        if (offset != null) {
            rowOffset = rowOffset.shift(offset.rows());
            columnOffset = columnOffset.shift(offset.columns());
        }
        bean.addCreateFilters(new GridFilter(xSheet, rowOffset, columnOffset), new RangesFilter(xSheet, rowOffset, columnOffset));
        bean.wrap(obj);
        bean.addOutputFilters(new FormatFilter(), new ConvertFilter(), new RangeFilter(xSheet, rowOffset, columnOffset), new CellFilter(xSheet, rowOffset, columnOffset), new StyleFilter(xSheet, rowOffset, columnOffset));
        for (String name : bean.getPropertyNames()) {
            bean.getProperty(name);
        }
    }

    public void write(OutputStream os) {
        this.write(os, false);
    }

    public void write(OutputStream os, boolean autoClose) {
        try {
            try {
                this.xWorkbook.write(os);
            }
            catch (IOException e) {
                throw new XlsMakerException(e);
            }
        }
        finally {
            if (autoClose && os != null) {
                try {
                    os.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

