/*
 * Decompiled with CFR 0.152.
 */
package jp.coppermine.voyager.beans.filter.impl;

import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import jp.coppermine.voyager.beans.collection.WritableProperty;
import jp.coppermine.voyager.beans.filter.InputFilter;
import jp.coppermine.voyager.beans.filter.annotations.Nullable;
import jp.coppermine.voyager.beans.filter.annotations.Parse;
import jp.coppermine.voyager.reflect.Reflector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParseFilter
implements InputFilter {
    @Override
    public Class<? extends Annotation> getAnnotation() {
        return Parse.class;
    }

    @Override
    public Object setValue(WritableProperty property, Object value) {
        Object parser;
        if (property.isWriteAnnotationPresent(Nullable.class) && value == null) {
            return value;
        }
        if (value instanceof Collection || value.getClass().isArray()) {
            throw new IllegalArgumentException("Cannot parse field that consists a collection or an array");
        }
        Parse annotation = property.getWriteAnnotation(Parse.class);
        Reflector reflector = Reflector.getReflector(annotation.parser());
        Object parsedValue = reflector.invoke("parse", parser = reflector.newInstance(new Object[]{annotation.pattern()}), new Object[]{value.toString()});
        if (parsedValue instanceof Number) {
            Number number = (Number)parsedValue;
            if (property.getType() == Byte.TYPE || property.getType() == Byte.class) {
                return number.byteValue();
            }
            if (property.getType() == Short.TYPE || property.getType() == Short.class) {
                return number.shortValue();
            }
            if (property.getType() == Integer.TYPE || property.getType() == Integer.class) {
                return number.intValue();
            }
            if (property.getType() == Long.TYPE || property.getType() == Long.class) {
                return number.longValue();
            }
            if (property.getType() == Float.TYPE || property.getType() == Float.class) {
                return Float.valueOf(number.floatValue());
            }
            if (property.getType() == Double.TYPE || property.getType() == Double.class) {
                return number.doubleValue();
            }
            if (property.getType() == BigInteger.class) {
                return new BigInteger(number.toString());
            }
            if (property.getType() == BigDecimal.class) {
                return new BigDecimal(number.toString());
            }
            if (property.getType() == AtomicInteger.class) {
                return new AtomicInteger(number.intValue());
            }
            if (property.getType() == AtomicLong.class) {
                return new AtomicLong(number.longValue());
            }
        }
        return value;
    }
}

