/*
 * Decompiled with CFR 0.152.
 */
package jp.coppermine.voyager.beans.collection.impl;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import jp.coppermine.voyager.beans.collection.Property;
import jp.coppermine.voyager.beans.collection.impl.AdvancedPropertyCollection;
import jp.coppermine.voyager.beans.collection.impl.BasicPropertyCollection;
import jp.coppermine.voyager.beans.collection.impl.PropertyMembers;
import jp.coppermine.voyager.reflect.Reflector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PropertyCollection {
    private final Reflector reflector;
    private final Map<String, Property> propertyMap;

    protected PropertyCollection(Class<?> clazz) {
        this.reflector = Reflector.getReflector(clazz);
        this.propertyMap = Collections.unmodifiableMap(this.findProperties());
    }

    public static final PropertyCollection getBasic(Class<?> clazz) {
        return new BasicPropertyCollection(clazz);
    }

    public static final PropertyCollection getAdvanced(Class<?> clazz) {
        return new AdvancedPropertyCollection(clazz);
    }

    public Property getProperty(String name) {
        return this.propertyMap.get(name);
    }

    public Set<String> getProperyNames() {
        return new HashSet<String>(this.propertyMap.keySet());
    }

    protected abstract Property createProperty(Reflector var1, Method var2, Method var3, Field var4);

    protected Map<String, Property> findProperties() {
        HashMap<String, Method> getters = new HashMap<String, Method>();
        HashMap<String, Method> setters = new HashMap<String, Method>();
        Method[] methodArray = this.reflector.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (PropertyMembers.isValid(method) && PropertyMembers.isGetter(method)) {
                getters.put(PropertyMembers.getName(method), method);
            }
            if (PropertyMembers.isValid(method) && PropertyMembers.isSetter(method)) {
                setters.put(PropertyMembers.getName(method), method);
            }
            ++n2;
        }
        HashMap<String, Field> fields = new HashMap<String, Field>();
        Field[] fieldArray = this.reflector.getFields();
        int n3 = fieldArray.length;
        n = 0;
        while (n < n3) {
            Field field = fieldArray[n];
            if (PropertyMembers.isValid(field)) {
                fields.put(PropertyMembers.getName(field), field);
            }
            ++n;
        }
        HashSet names = new HashSet();
        names.addAll(getters.keySet());
        names.addAll(setters.keySet());
        names.addAll(fields.keySet());
        HashMap<String, Property> map = new HashMap<String, Property>();
        for (String name : names) {
            Method getter = (Method)getters.get(name);
            Method setter = (Method)setters.get(name);
            Field field = (Field)fields.get(name);
            HashSet types = new HashSet();
            if (getter != null) {
                types.add(PropertyMembers.getType(getter));
            }
            if (setter != null) {
                types.add(PropertyMembers.getType(setter));
            }
            if (field != null) {
                types.add(PropertyMembers.getType(field));
            }
            if (types.size() != 1) continue;
            map.put(name, this.createProperty(this.reflector, getter, setter, field));
        }
        return map;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.propertyMap == null ? 0 : this.propertyMap.hashCode());
        result = 31 * result + (this.reflector == null ? 0 : this.reflector.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PropertyCollection other = (PropertyCollection)obj;
        if (this.propertyMap == null ? other.propertyMap != null : !this.propertyMap.equals(other.propertyMap)) {
            return false;
        }
        return !(this.reflector == null ? other.reflector != null : !this.reflector.equals((Object)other.reflector));
    }
}

