/*
 * Decompiled with CFR 0.152.
 */
package jp.coppermine.voyager.beans.collection.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.coppermine.voyager.beans.PropertyAccessException;
import jp.coppermine.voyager.beans.PropertyNotFoundException;
import jp.coppermine.voyager.beans.collection.Property;
import jp.coppermine.voyager.reflect.Reflector;
import jp.coppermine.voyager.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BasicProperty
implements Property {
    public static final Pattern ACCESSOR_NAME_PATTERN = Pattern.compile("^(?!getClass\\b)(get|is|set)([A-Z]\\w*)$");
    private Method getter;
    private Method setter;
    private Field field;
    private String name;
    private Class<?> type;
    private final Reflector reflector;

    BasicProperty(Reflector reflector, Method getter, Method setter, Field field) {
        this.reflector = reflector;
        String getterName = null;
        if (getter != null && !Modifier.isStatic(getter.getModifiers()) && getter.getReturnType() != Void.TYPE && getter.getParameterTypes().length == 0) {
            this.getter = getter;
            Matcher matcher = ACCESSOR_NAME_PATTERN.matcher(getter.getName());
            getterName = Strings.toInitialLowerCase((CharSequence)matcher.replaceFirst("$2"));
        }
        String setterName = null;
        if (setter != null && !Modifier.isStatic(setter.getModifiers()) && setter.getReturnType() == Void.TYPE && setter.getParameterTypes().length == 1) {
            this.setter = setter;
            Matcher matcher = ACCESSOR_NAME_PATTERN.matcher(setter.getName());
            setterName = Strings.toInitialLowerCase((CharSequence)matcher.replaceFirst("$2"));
        }
        String fieldName = null;
        if (field != null && !Modifier.isFinal(field.getModifiers()) && !Modifier.isStatic(field.getModifiers())) {
            this.field = field;
            fieldName = field.getName();
        }
        if (!Strings.equalsAll((CharSequence[])new CharSequence[]{getterName, setterName, fieldName})) {
            throw new IllegalArgumentException();
        }
        if (getterName != null) {
            this.name = getterName;
        } else if (setterName != null) {
            this.name = setterName;
        } else if (fieldName != null) {
            this.name = fieldName;
        } else {
            throw new IllegalArgumentException("property name is not found");
        }
        ArrayList types = new ArrayList();
        if (getter != null) {
            types.add(getter.getReturnType());
        }
        if (setter != null) {
            types.add(setter.getParameterTypes()[0]);
        }
        if (field != null) {
            types.add(field.getType());
        }
        if (types.size() == 0) {
            throw new IllegalArgumentException();
        }
        if (types.size() == 1) {
            this.type = (Class)types.get(0);
        } else {
            Class base = (Class)types.get(0);
            int index = 0;
            while (index < types.size()) {
                if (base != types.get(index)) {
                    throw new IllegalArgumentException("property types are different");
                }
                ++index;
            }
            this.type = (Class)types.get(0);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Class<?> getType() {
        return this.type;
    }

    @Override
    public boolean isReadable() {
        return this.getter != null;
    }

    @Override
    public boolean isWritable() {
        return this.setter != null;
    }

    @Override
    public Object getValue(Object obj) {
        if (!this.isReadable()) {
            throw new PropertyAccessException(this);
        }
        if (this.getter != null) {
            return this.reflector.invoke(this.getter, obj, new Object[0]);
        }
        if (this.field != null) {
            return this.reflector.getFieldValue(this.field, obj);
        }
        throw new PropertyNotFoundException(this.name);
    }

    @Override
    public void setValue(Object obj, Object value) {
        if (!this.isWritable()) {
            throw new PropertyAccessException(this);
        }
        if (this.setter != null) {
            this.reflector.invoke(this.setter, obj, new Object[]{value});
        } else if (this.field != null) {
            this.reflector.setFieldValue(this.field, obj, value);
        } else {
            throw new PropertyNotFoundException(this.name);
        }
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        boolean isSetterAnnotationPresent = this.setter == null ? false : this.setter.isAnnotationPresent(annotationClass);
        boolean isGetterAnnotationPresent = this.getter == null ? false : this.getter.isAnnotationPresent(annotationClass);
        boolean isFieldAnnotationPresent = this.field == null ? false : this.field.isAnnotationPresent(annotationClass);
        return isSetterAnnotationPresent | isGetterAnnotationPresent | isFieldAnnotationPresent;
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        T fieldAnnotation;
        T setterAnnotation = this.setter == null ? null : (T)this.setter.getAnnotation(annotationClass);
        T getterAnnotation = this.getter == null ? null : (T)this.getter.getAnnotation(annotationClass);
        T t = fieldAnnotation = this.field == null ? null : (T)this.field.getAnnotation(annotationClass);
        if (setterAnnotation != null) {
            return setterAnnotation;
        }
        if (getterAnnotation != null) {
            return getterAnnotation;
        }
        if (fieldAnnotation != null) {
            return fieldAnnotation;
        }
        return null;
    }

    @Override
    public Annotation[] getAnnotations() {
        Annotation[] setterAnnotations = this.setter.getAnnotations();
        Annotation[] getterAnnotations = this.setter.getAnnotations();
        Annotation[] fieldAnnotations = this.field.getAnnotations();
        if (setterAnnotations != null) {
            return setterAnnotations;
        }
        if (getterAnnotations != null) {
            return getterAnnotations;
        }
        if (fieldAnnotations != null) {
            return fieldAnnotations;
        }
        return new Annotation[0];
    }

    @Override
    public boolean isReadAnnotationPresent(Class<? extends Annotation> annotationClass) {
        boolean isGetterAnnotationPresent = this.getter == null ? false : this.getter.isAnnotationPresent(annotationClass);
        boolean isFieldAnnotationPresent = this.field == null ? false : this.field.isAnnotationPresent(annotationClass);
        return isGetterAnnotationPresent | isFieldAnnotationPresent;
    }

    @Override
    public <T extends Annotation> T getReadAnnotation(Class<T> annotationClass) {
        T fieldAnnotation;
        T getterAnnotation = this.getter == null ? null : (T)this.getter.getAnnotation(annotationClass);
        T t = fieldAnnotation = this.field == null ? null : (T)this.field.getAnnotation(annotationClass);
        if (getterAnnotation != null) {
            return getterAnnotation;
        }
        if (fieldAnnotation != null) {
            return fieldAnnotation;
        }
        return null;
    }

    @Override
    public Annotation[] getReadAnnotations() {
        Annotation[] getterAnnotations = this.setter.getAnnotations();
        Annotation[] fieldAnnotations = this.field.getAnnotations();
        if (getterAnnotations != null) {
            return getterAnnotations;
        }
        if (fieldAnnotations != null) {
            return fieldAnnotations;
        }
        return new Annotation[0];
    }

    @Override
    public boolean isWriteAnnotationPresent(Class<? extends Annotation> annotationClass) {
        boolean isSetterAnnotationPresent = this.setter == null ? false : this.setter.isAnnotationPresent(annotationClass);
        boolean isFieldAnnotationPresent = this.field == null ? false : this.field.isAnnotationPresent(annotationClass);
        return isSetterAnnotationPresent | isFieldAnnotationPresent;
    }

    @Override
    public <T extends Annotation> T getWriteAnnotation(Class<T> annotationClass) {
        T fieldAnnotation;
        T setterAnnotation = this.setter == null ? null : (T)this.setter.getAnnotation(annotationClass);
        T t = fieldAnnotation = this.field == null ? null : (T)this.field.getAnnotation(annotationClass);
        if (setterAnnotation != null) {
            return setterAnnotation;
        }
        if (fieldAnnotation != null) {
            return fieldAnnotation;
        }
        return null;
    }

    @Override
    public Annotation[] getWriteAnnotations() {
        Annotation[] setterAnnotations = this.setter.getAnnotations();
        Annotation[] fieldAnnotations = this.field.getAnnotations();
        if (setterAnnotations != null) {
            return setterAnnotations;
        }
        if (fieldAnnotations != null) {
            return fieldAnnotations;
        }
        return new Annotation[0];
    }

    public String toString() {
        StringBuilder message = new StringBuilder("Property ");
        message.append(this.getName()).append(" ");
        if (this.isReadable() && !this.isWritable()) {
            message.append("is read only");
        } else if (!this.isReadable() && this.isWritable()) {
            message.append("is write only");
        } else if (!this.isReadable() && !this.isWritable()) {
            message.append("requires the special permission");
        } else {
            message.append("is not accessible because of unknown reason");
        }
        return message.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.field == null ? 0 : this.field.hashCode());
        result = 31 * result + (this.getter == null ? 0 : this.getter.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.reflector == null ? 0 : this.reflector.hashCode());
        result = 31 * result + (this.setter == null ? 0 : this.setter.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BasicProperty other = (BasicProperty)obj;
        if (this.field == null ? other.field != null : !this.field.equals(other.field)) {
            return false;
        }
        if (this.getter == null ? other.getter != null : !this.getter.equals(other.getter)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.reflector == null ? other.reflector != null : !this.reflector.equals((Object)other.reflector)) {
            return false;
        }
        if (this.setter == null ? other.setter != null : !this.setter.equals(other.setter)) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }
}

