/***************************************************************************/
/*! \file   wvoxtrack.h
    \brief  饹WVoxTrackΥإåե롣
    \author Tomoaki Murakami
    \date   2004ǯ  5  4  16:58:12 JST
*/
/***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _WVOXTRACK_H_
#define _WVOXTRACK_H_

#include <qhbox.h>
#include <qvbox.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qpopupmenu.h>
#include <qpushbutton.h>
#include <qdom.h>
#include <knuminput.h>
#include "wfilechooser.h"
#include "ctrackinf.h"

/*-------------------------------------------------------------------------*/
/*! \class  WVoxTrack
    \brief  ȥååȡ
    ȥåɽEcasoundΥ롣
    ե̾λꡢ쥳ǥ󥰥ȥåȤƻꡢ
    ߥ塼ȥȥåȤƻꤹʤɤԤȤǤ롣
    ƥåȤʣWVoxTrack硢ƥʥ
    ̻ҤȤȯԤ롣
    ̻Ҥˤϥȥå̾ΤѤ뤿ᡢWVoxTrack֤ǰդ
    ʸȤʤʤФʤʤ
*/
/*-------------------------------------------------------------------------*/
class WVoxTrack : public QHBox
{
  Q_OBJECT

public:
  //! \brief 󥹥ȥ饯
  //! \param strName ȥå̾Ρ
  //! \param strDeviceIn ϥǥХ
  //! \param strDeviceOut ϥǥХ
  //! \param WidgetParent ƥåȤؤΥݥ󥿡
  //! \param cName åȤ̾Ρ
  WVoxTrack(const QString& strName,
            const QString& strDeviceIn,
            const QString& strDeviceOut,
            QWidget*       WidgetParent=0,
            const char*    cName=0);
  //! \brief 󥹥ȥ饯
  //! \param TrackInf ȥå
  //! \param WidgetParent ƥåȤؤΥݥ󥿡
  //! \param cName å̾Ρ
  WVoxTrack(const CTrackInf& TrackInf, 
            QWidget*         WidgetParent=0,
            const char*      cName=0);
  //! \brief 󥹥ȥ饯
  //! \param nodTrack DOMΡɡ
  //! \param WidgetParent ƥåȡ
  //! \param cName åȤ̾Ρ
  WVoxTrack(const QDomNode& nodTrack,
            QWidget*        WidgetParent=0, 
            const char*     cName=0);
  //! \brief ǥȥ饯
  ~WVoxTrack();

  //! \brief ȥå̾Τ롣
  QString   name() const;
  //! \brief ץ쥤ХåǥХ̾롣
  QString   playbackDevice() const;
  //! \brief 쥳ǥ󥰥ǥХ̾롣
  QString   recordingDevice() const;
  //! \brief ꤵƤΥ٥롣
  //! 0100ϰϡ
  int       level() const;
  //! \brief ꤵƤΥѥ롣
  //! 0100ϰϡ
  int       pan() const;  
  //! \brief ϸΥե̾Τ롣
  QString   fileName() const;
  //! \brief ϰ֤֤
  QTime     startPosition() const;
  //! \brief եåȤ֤
  QTime     offset() const;
  //! \brief ֤֤
  QTime     length() const;
  //! \brief ߥ塼ȤꤵƤ뤫ɤ롣
  bool      isMuted() const;
  //! \brief 쥳ǥ󥰥ȥåȤꤵƤ뤫ɤ롣
  bool      isSetRec() const;
  //! \brief ե̾ꤵƤ뤫ɤ֤
  bool      isBindedToFile() const;
  //! \brief ȥåξ礷Ƽ롣
  CTrackInf stateInTrackInf() const;
  //! \brief  󥹥󥹤ξ֤DOM֤
  //! \param  pDoc DOMɥȡ
  //! \return DOMΡɡ
  QDomNode  stateInDOM(QDomDocument* pDoc) const;

  //! \brief ȥå̾Τꤹ롣
  //! \param strName ȥå̾Ρ
  void      setName(const QString& strName);
  //! \brief ٥ꤹ롣
  //! \param nLevel ٥롣400ޤǤϰϡ
  void      setLevel(int nLevel);
  //! \brief ѥꤹ롣
  //! \param nPan ѥ0100ޤǤϰϡ
  void      setPan(int nPan);
  //! \brief ե̾Τꤹ롣
  //! \param strFileName ե̾Ρ
  void      setFileName(const QString& strFileName);
  //! \brief ֤ꤹ롣
  //! \param TimeStartPositionArg ()
  void      setStartPosition(const QTime& TimeStartPositionArg);
  //! \brief եåȤꤹ롣
  //! \param TimeOffsetArg եå()
  void      setOffset(const QTime& TimeOffsetArg);
  //! \brief ֤ꤹ롣
  //! \param TimeLengthArg ()
  void      setLength(const QTime& TimeLengthArg);
  //! \brief ߥ塼Ȥꤹ롣
  //! \param bMute ߥ塼Ȥξ硢true
  void      setMute(bool bMute);
  //! \brief 쥳ǥ󥰥ȥåɤꤹ롣
  //! \param bRecPort 쥳ǥ󥰥ȥåξ硢true
  void      setRec(bool bRecPort);
  //! \brief ȥåξ֤CTrackInfꤹ롣
  //! \param TrackInfSet ꤵȥå
  void      setStateByTrackInf(const CTrackInf& TrackInfSet);
  //! \brief  ȥåξ֤DOMꤹ롣
  //! \param  nodTrack DOMΡɡ
  void      setStateByDom(const QDomNode& nodTrack);

  //! ߥ塼ȥȥܥ
  static unsigned int Mute;
  //! Ͽȥܥ
  static unsigned int Record;
  //! ե塼
  static unsigned int File;
  //! ݥåץåץ˥塼
  static unsigned int Remove;
  //! ǥХѹݥåץåץ˥塼
  static unsigned int Device;
  //! ϰѹݥåץåץ˥塼
  static unsigned int StartPosition;
  //! Υեåѹݥåץåץ˥塼
  static unsigned int Offset;
  //! ѹݥåץåץ˥塼
  static unsigned int Length;

protected:
  //! \brief ޥץ쥹줿Υ٥ȥϥɥ顣
  //! \param MouseEvent ޥ٥Ⱦ
  void      mousePressEvent(QMouseEvent* MouseEvent);

private:
  //! ץ쥤ХåǥХ
  QString strInputDevice;
  //! 쥳ǥ󥰥ǥХ
  QString strOutputDevice;
  //! ϰ֡
  QTime TimeStartPosition;
  //! եåȡ
  QTime TimeOffset;
  //! ֡
  QTime TimeLength;

  //! ¦Υ١åȡ
  QVBox         *VBoxController;
  //! VBoxController̾Υ٥ȥ٥륹饤Υ١åȡ
  QHBox         *HBoxStandard;
  //! VBoxControllerΥե塼ȥܥ󷲤Υ١åȡ
  QHBox         *HBoxButtonBase;
  //! ȥå̾Ρ
  QLabel        *LabelName;
  //! ٥ȥѥꥦåȡ
  QVBox         *VBoxValue;
  //! ٥ѥ饤ҥȡ
  QLabel        *LabelLevel;
  //! ٥ѥ饤
  KIntNumInput  *IntNumInputLevel;
  //! ѥѥ饤ҥȡ
  QLabel        *LabelPan;
  //! ѥѥ饤
  KIntNumInput  *IntNumInputPan;
  //! ϸΥեꤹ뤿Υåȡ
  WFileChooser  *FileChooserTrack;
  //! ڡ
  QWidget       *WidgetSpacer;
  //! ߥ塼ȤON/OFFꤹܥ
  QPushButton   *PushButtonMute;
  //! 쥳ǥ󥰤ON/OFFꤹܥ
  QPushButton   *PushButtonRec;
  //! ݥåץåץ˥塼
  QPopupMenu    *PopupMenu;
  //! ˥塼ID()
  int            nMenuIDRemove;
  //! ˥塼ID(̾ѹ)
  int            nMenuIDRename;
  //! ˥塼ID(ץ쥤ХåǥХ)
  int            nMenuIDPlaybackDevice;
  //! ˥塼ID(쥳ǥ󥰥ǥХ)
  int            nMenuIDRecordingDevice;
  //! ˥塼ID(ϰ)
  int            nMenuIDStartPosition;
  //! ˥塼ID(եå)
  int            nMenuIDOffset;
  //! ˥塼ID()
  int            nMenuIDLength;

  //! åȤꡣ
  //! 󥹥ȥ饯Τ߸ƤӽФġ
  void setupWidgets();
  //! ݥåץåץ˥塼ꡣ
  //! 󥹥ȥ饯Τ߸ƤӽФġ
  void setupPopupMenu();

public slots:
  //! \brief ꤵ줿åȤ̵ͭꤹ륹åȡ
  //! \param unWidgets åȤӥåȤǻꡣ
  //! \param bEnabled  ꤵ줿åȤͭˤ硢trueꡣ
  void slotSetEnabledWidgets(unsigned int unWidgets, bool bEnabled);

private slots:
  //! \brief ץ쥤ХåǥХѹ׵Υåȡ
  void slotChangePlaybackDevice();
  //! \brief 쥳ǥ󥰥ǥХѹ׵Υåȡ
  void slotChangeRecordingDevice();
  //! \brief ꤵ줿Υåȡ
  //! åܥåǺγǧԤ
  void slotRemove();
  //! \brief ̾ѹ׵Υåȡ
  //! ̾ɽ롣
  void slotRename();
  //! \brief ϰ׵ṹΥåȡ
  void slotChangeStartPosition();
  //! \brief եåѹ׵Υåȡ
  void slotChangeOffset();
  //! \brief ѹ׵Υåȡ
  void slotChangeLength();

signals:
  //! \brief ץ쥤ХåǥХѹΥ٥ȡ
  void playbackDeviceChanged(const QString&);
  //! \brief 쥳ǥ󥰥ǥХѹΥ٥ȡ
  void recordingDeviceChanged(const QString&);
  //! \brief Υ٥ȡ
  void removed();
  //! \brief ե̾ѹΥ٥ȡ
  void fileNameChanged(const QString&);
  //! \brief ٥ѹΥ٥ȡ
  void levelChanged(int);
  //! \brief ѥѹΥ٥ȡ
  void panChanged(int);
  //! \brief ߥ塼Ⱦ֤ѹ줿Υ٥ȡ
  void muteToggled(bool);
  //! \brief Ͽ֤ѹ줿Υ٥ȡ
  void recToggled(bool);
  //! \brief ϰ֤ѹ줿Υ٥ȡ
  void startPositionChanged(const QTime&);
  //! \brief Ͽ֤ѹ줿Υ٥ȡ
  void offsetChanged(const QTime&);
  //! \brief Ͽ֤ѹ줿Υ٥ȡ
  void lengthChanged(const QTime&);
};

#endif
