/***************************************************************************
                          ctrackinf.cpp  -  description
                             -------------------
    begin                : 2004ǯ  5  4  22:42:12 JST
    copyright            : (C) 2004 by Tomoaki Murakami
    email                : solarisphere@yahoo.co.jp
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "ctrackinf.h"

/////////////////////////////////////////////////////////////////////////////

CTrackInf::CTrackInf()
{
}

/////////////////////////////////////////////////////////////////////////////

CTrackInf::CTrackInf(const QDomNode& nodTrack)
{
  setStateByDom(nodTrack);
}

/////////////////////////////////////////////////////////////////////////////

CTrackInf::~CTrackInf()
{
}

/////////////////////////////////////////////////////////////////////////////

void 
CTrackInf::copy(const CTrackInf& src)
{
  this->strTrackName      = src.strTrackName;
  this->strFileName       = src.strFileName;
  this->strInputDevice    = src.strInputDevice;
  this->strOutputDevice   = src.strOutputDevice;
  this->nLevel            = src.nLevel;
  this->nPan              = src.nPan;
  this->timeStartPosition = src.timeStartPosition;
  this->timeOffset        = src.timeOffset;
  this->timeLength        = src.timeLength;
  this->bMute             = src.bMute;
  this->bRecPort          = src.bRecPort;
  this->vEffects          = src.vEffects;
  this->bBypass           = src.bBypass;
}

/////////////////////////////////////////////////////////////////////////////

CTrackInf::CTrackInf(const CTrackInf& src)
{
  copy(src);
}

/////////////////////////////////////////////////////////////////////////////

CTrackInf&
CTrackInf::operator=(const CTrackInf& src)
{
  copy(src);
  return (*this);
}

/////////////////////////////////////////////////////////////////////////////

void 
CTrackInf::setStateByDom(const QDomNode& nodTrack)
{
  // name
  {
    QDomNamedNodeMap nnmAttributes = nodTrack.attributes();
    if ( nnmAttributes.count() == 0 ) {
      this->strTrackName = "";//!!
    } else {
      QDomNode nodName = nnmAttributes.namedItem("name");
      this->strTrackName = nodName.nodeValue();
    }
  }

  QDomNodeList nolChildren = nodTrack.childNodes();

  // file name
  {
    QDomNode nodFile = nolChildren.item(0);
    if ( nodFile.isNull() ){
      this->strFileName = "";
    } else {
      QDomNamedNodeMap nnmAttributes = nodFile.attributes();
      if ( nnmAttributes.count() == 0 ) {
        this->strFileName = "";
      } else {
        QDomNode nodName = nnmAttributes.namedItem("name");
        this->strFileName = nodName.nodeValue();
      }
    }
  }

  // device
  {
    QDomNode nodDevice = nolChildren.item(1);
    if ( nodDevice.isNull() ){
      strInputDevice = "/dev/dsp";//!!
      strOutputDevice = "/dev/dsp";//!!
    } else {
      QDomNamedNodeMap nnmAttributes = nodDevice.attributes();
      if ( nnmAttributes.count() == 0 ) {
        strInputDevice = "/dev/dsp";//!!
        strOutputDevice = "/dev/dsp";//!!
      } else {
        QDomNode nodIn = nnmAttributes.namedItem("in");
        strInputDevice = nodIn.nodeValue();
        QDomNode nodOut = nnmAttributes.namedItem("out");
        strOutputDevice = nodOut.nodeValue();
      }
    }
  }

  // Level
  {
    QDomNode nodLevel = nolChildren.item(2);
    if ( nodLevel.isNull() ){
      this->nLevel = 100;
    } else {
      QDomNamedNodeMap nnmAttributes = nodLevel.attributes();
      if ( nnmAttributes.count() == 0 ) {
        this->nLevel = 100;
      } else {
        QDomNode nodValue = nnmAttributes.namedItem("value");
        this->nLevel = nodValue.nodeValue().toInt();
      }
    }
  }

  // Pan
  {
    QDomNode nodPan = nolChildren.item(3);
    if ( nodPan.isNull() ){
      this->nPan = 50;
    } else {
      QDomNamedNodeMap nnmAttributes = nodPan.attributes();
      if ( nnmAttributes.count() == 0 ) {
        this->nPan = 50;
      } else {
        QDomNode nodValue = nnmAttributes.namedItem("value");
        this->nPan = nodValue.nodeValue().toInt();
      }
    }
  }

  // mute state
  {
    QDomNode nodMute= nolChildren.item(4);
    if ( nodMute.isNull() ){
      this->bMute = false;
    } else {
      QDomNamedNodeMap nnmAttributes = nodMute.attributes();
      if ( nnmAttributes.count() == 0 ) {
        this->bMute = false;
      } else {
        QDomNode nodValue = nnmAttributes.namedItem("state");
        if ( nodValue.nodeValue() == "true" ) {
          this->bMute = true;
        } else {
          this->bMute = false;
        }
      }
    }
  }

  // recording state
  {
    QDomNode nodRec= nolChildren.item(5);
    if ( nodRec.isNull() ){
      this->bRecPort = false;
    } else {
      QDomNamedNodeMap nnmAttributes = nodRec.attributes();
      if ( nnmAttributes.count() == 0 ) {
        this->bRecPort = false;
      } else {
        QDomNode nodValue = nnmAttributes.namedItem("state");
        if ( nodValue.nodeValue() == "true" ) {
          this->bRecPort = true;
        } else {
          this->bRecPort = false;
        }
      }
    }
  }

  // start position
  {
    QDomNode nodStartPosition = nolChildren.item(6);
    timeStartPosition = QTime();
    if ( nodStartPosition.isNull() ){
      this->timeStartPosition = QTime();
    } else {
      QDomNamedNodeMap nnmAttributes = nodStartPosition.attributes();
      if ( nnmAttributes.count() == 0 ) {
        this->timeStartPosition = QTime();
      } else {
        QDomNode nodValue = nnmAttributes.namedItem("value");
        QTime timeTmp;
        this->timeStartPosition = timeTmp.addMSecs(nodValue.nodeValue().toInt());
      }
    }
  }

  // offset
  {
    QDomNode nodOffset = nolChildren.item(7);
    timeOffset = QTime();
    if ( nodOffset.isNull() ){
      this->timeOffset = QTime();
    } else {
      QDomNamedNodeMap nnmAttributes = nodOffset.attributes();
      if ( nnmAttributes.count() == 0 ) {
        this->timeOffset = QTime();
      } else {
        QDomNode nodValue = nnmAttributes.namedItem("value");
        QTime timeTmp;
        this->timeOffset = timeTmp.addMSecs(nodValue.nodeValue().toInt());
      }
    }
  }

  // length
  {
    QDomNode nodLength = nolChildren.item(8);
    timeLength = QTime();
    if ( nodLength.isNull() ){
      this->timeLength = QTime();
    } else {
      QDomNamedNodeMap nnmAttributes = nodLength.attributes();
      if ( nnmAttributes.count() == 0 ) {
        this->timeLength = QTime();
      } else {
        QDomNode nodValue = nnmAttributes.namedItem("value");
        QTime timeTmp;
        this->timeLength = timeTmp.addMSecs(nodValue.nodeValue().toInt());
      }
    }
  }

  // bypass state
  {
    QDomNode nodBypass= nolChildren.item(9);
    if ( nodBypass.isNull() ){
      this->bBypass = false;
    } else {
      QDomNamedNodeMap nnmAttributes = nodBypass.attributes();
      if ( nnmAttributes.count() == 0 ) {
        this->bBypass = false;
      } else {
        QDomNode nodValue = nnmAttributes.namedItem("state");
        if ( nodValue.nodeValue() == "true" ) {
          this->bBypass = true;
        } else {
          this->bBypass = false;
        }
      }
    }
  }
}

/////////////////////////////////////////////////////////////////////////////

QDomNode
CTrackInf::stateInDOM(QDomDocument* pDoc) const
{
  QDomElement eleTrack = pDoc->createElement("Track");
  eleTrack.setAttribute("name", strTrackName);

  // file name
  {
    QDomElement eleFileName = pDoc->createElement("File");
    eleFileName.setAttribute("name", strFileName);
    eleTrack.appendChild(eleFileName);
  }

  // I/O device
  {
    QDomElement eleDevice = pDoc->createElement("Device");
    eleDevice.setAttribute("in", strInputDevice);
    eleDevice.setAttribute("out", strOutputDevice);
    eleTrack.appendChild(eleDevice);
  }

  // level
  {
    QDomElement eleLevel = pDoc->createElement("Level");
    eleLevel.setAttribute("value", nLevel);
    eleTrack.appendChild(eleLevel);
  }

  // pan
  {
    QDomElement elePan = pDoc->createElement("Pan");
    elePan.setAttribute("value", nPan);
    eleTrack.appendChild(elePan);
  }

  // mute state
  {
    QDomElement eleMute = pDoc->createElement("Mute");
    QString strState;
    if ( bMute ) {
      strState = "true";
    } else {
      strState = "false";
    }
    eleMute.setAttribute("state", strState);
    eleTrack.appendChild(eleMute);
  }

  // recording state
  {
    QDomElement eleRec = pDoc->createElement("Record");
    QString strState;
    if ( bRecPort ) {
      strState = "true";
    } else {
      strState = "false";
    }
    eleRec.setAttribute("state", strState);
    eleTrack.appendChild(eleRec);
  }

  // start position
  {
    QDomElement eleStartPosition = pDoc->createElement("StartPosition");
    QTime timeTmp;
    eleStartPosition.setAttribute("value", timeTmp.msecsTo(timeStartPosition));
    eleTrack.appendChild(eleStartPosition);
  }

  // offset
  {
    QDomElement eleOffset = pDoc->createElement("Offset");
    QTime timeTmp;
    eleOffset.setAttribute("value", timeTmp.msecsTo(timeOffset));
    eleTrack.appendChild(eleOffset);
  }

  // length
  {
    QDomElement eleLength = pDoc->createElement("Length");
    QTime timeTmp;
    eleLength.setAttribute("value", timeTmp.msecsTo(timeLength));
    eleTrack.appendChild(eleLength);
  }

  // bypass state
  {
    QDomElement eleBypass = pDoc->createElement("Bypass");
    QString strState;
    if ( bBypass ) {
      strState = "true";
    } else {
      strState = "false";
    }
    eleBypass.setAttribute("state", strState);
    eleTrack.appendChild(eleBypass);
  }

  return eleTrack;
}

/////////////////////////////////////////////////////////////////////////////
