/***************************************************************************/
/*! \file   cladspapluginlibrary.h
    \brief  饹CLadspaPluginLibraryΥإåե롣
    \author Tomoaki Murakami
    \date   2004ǯ  7 18  22:16:12 JST
*/
/***************************************************************************/

/***************************************************************************
 *   Copyright (C) 2004 by Tomoaki Murakami                                *
 *   solarisphrere@yahoo.co.jp                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef CLADSPAPLUGINLIBRARY_H
#define CLADSPAPLUGINLIBRARY_H

#include <ladspa.h>
#include <qlibrary.h>
#include <qstring.h>
#include <qvaluevector.h>
#include "cladspaeffect.h"

/*-------------------------------------------------------------------------*/
/*! \class  CLadspaPluginLibrary
    \brief  LADSPAץ饰饤֥ꡣ
*/
/*-------------------------------------------------------------------------*/
class CLadspaPluginLibrary
{
public:
  //! \brief 󥹥ȥ饯
  CLadspaPluginLibrary(const QString& strLibFileName);
  //! \brief ԡ󥹥ȥ饯
  CLadspaPluginLibrary(const CLadspaPluginLibrary& src);
  //! \brief ǥȥ饯
  ~CLadspaPluginLibrary();
  //! \brief 黻ҡ
  CLadspaPluginLibrary& operator=(const CLadspaPluginLibrary& src);

  //! \brief ֥ȤLADSPAץ饰饤֥
  //! ˴ϢդƤ뤫
  bool isLadspaPluginLibrary() const;
  //! \brief 饤֥ե̾Τ֤
  QString fileName() const;
  //! \brief եȿ֤
  int effectCount() const;
  //! \brief եȤ֤
  CLadspaEffect effect(int nIndex) const;

private:
  //! 饤֥ե̾Ρ
  QString strFileName;
  //! եȡ
  QValueVector<CLadspaEffect> effects;
};

#endif
