/***************************************************************************
                          worderdialog.cpp  -  description
                             -------------------
    begin                : 2004ǯ  7 10  13:26:12 JST
    copyright            : (C) 2003 by Tomoaki Murakami
    email                : solarisphere@yahoo.co.jp
 ***************************************************************************/

/***************************************************************************
 *   Copyright (C) 2004 by Tomoaki Murakami                                *
 *   solarisphrere@yahoo.co.jp                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <qlayout.h>
#include <qpushbutton.h>
#include <klocale.h>
#include "worderdialog.h"

/////////////////////////////////////////////////////////////////////////////

WOrderDialog::WOrderDialog(QWidget* WidgetParent, const char* cName)
  : KDialogBase(KDialogBase::Plain,
                "Change Order",
                Ok | Cancel,
                Ok,
                WidgetParent,
                cName)
{
  QFrame *FramePage = plainPage();
  FramePage->setMaximumHeight(80);
  FramePage->setMinimumHeight(80);
  FramePage->setMinimumWidth(240);

  QHBoxLayout* HLayout = new QHBoxLayout(FramePage);
  ListBox = new KListBox(FramePage);
  HLayout->addWidget(ListBox);

  QVBoxLayout* VLayout = new QVBoxLayout(FramePage);
  QPushButton* Button;
  Button = new QPushButton(i18n("Up"), FramePage);
  connect(Button, SIGNAL(clicked()), 
          this, SLOT(slotUp()));
  VLayout->addWidget(Button);
  Button = new QPushButton(i18n("Down"), FramePage);
  connect(Button, SIGNAL(clicked()), 
          this, SLOT(slotDown()));
  VLayout->addWidget(Button);
  VLayout->addStretch();
  
  HLayout->addLayout(VLayout);
}

/////////////////////////////////////////////////////////////////////////////

WOrderDialog::~WOrderDialog()
{
}

/////////////////////////////////////////////////////////////////////////////

QStringList
WOrderDialog::list() const
{
  QStringList strl;
  int i;
  int nCount = ListBox->count();
  for ( i = 0; i < nCount; i++ ) {
    strl.push_back(ListBox->text(i));
  }

  return strl;
}

/////////////////////////////////////////////////////////////////////////////

QValueVector<int>
WOrderDialog::order() const
{
  QValueVector<int> vRet;
  int i, j;
  int nCount = ListBox->count();
  for ( i = 0; i < nCount; i++ ) {
    for ( j = 0; j < nCount; j++ ) {
      if ( ListBox->text(i) == strlOrder[j] ) {
        vRet.push_back(j);
        break;
      }
    }
  }

  return vRet;
}

/////////////////////////////////////////////////////////////////////////////

void
WOrderDialog::slotSetList(const QStringList& strl)
{
  ListBox->clear();
  ListBox->insertStringList(strl);

  strlOrder = strl;
}

/////////////////////////////////////////////////////////////////////////////

void 
WOrderDialog::slotUp()
{
  QListBoxItem *ItemSelected = ListBox->selectedItem();
  if ( ItemSelected == NULL ) {  // not selected
    return;
  }
  if ( ListBox->firstItem() == ItemSelected ) {  // top item
    return;
  }

  QString strTmp = ItemSelected->text();
  int     nIndex = ListBox->index(ItemSelected);
  ListBox->changeItem(ListBox->item(nIndex - 1)->text(), nIndex);
  ListBox->changeItem(strTmp, nIndex - 1);
  ListBox->setSelected(nIndex - 1, true);
}

/////////////////////////////////////////////////////////////////////////////

void 
WOrderDialog::slotDown()
{
  QListBoxItem *ItemSelected = ListBox->selectedItem();
  if ( ItemSelected == NULL ) {  // not selected
    return;
  }
  int     nIndex = ListBox->index(ItemSelected);
  if ( (ListBox->count() - 1) == static_cast<uint>(nIndex) ) {  // bottom item
    return;
  }

  QString strTmp = ItemSelected->text();
  ListBox->changeItem(ListBox->item(nIndex + 1)->text(), nIndex);
  ListBox->changeItem(strTmp, nIndex + 1);
  ListBox->setSelected(nIndex + 1, true);
}

/////////////////////////////////////////////////////////////////////////////

#include "worderdialog.moc"
