/***************************************************************************
                          wboolportinput.cpp  -  description
                             -------------------
    begin                : 2004ǯ  7 30  22:48:12 JST
    copyright            : (C) 2004 by Tomoaki Murakami
    email                : solarisphere@yahoo.co.jp
 ***************************************************************************/

/***************************************************************************
 *   Copyright (C) 2004 by Tomoaki Murakami                                *
 *   solarisphrere@yahoo.co.jp                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <qradiobutton.h>
#include <klocale.h>
#include "wboolportinput.h"

/////////////////////////////////////////////////////////////////////////////

WBoolPortInput::WBoolPortInput(
  QWidget*    WidgetParent,
  const char* cName)
  : QHButtonGroup(WidgetParent, cName)
{
  setupWidgets();
}

/////////////////////////////////////////////////////////////////////////////

WBoolPortInput::WBoolPortInput(
  const QString& strTitle,
  QWidget*       WidgetParent,
  const char*    cName)
  : QHButtonGroup(strTitle, WidgetParent, cName)
{
  setupWidgets();
}

/////////////////////////////////////////////////////////////////////////////

void 
WBoolPortInput::setupWidgets()
{
  QRadioButton*  Radio;
  Radio = new QRadioButton(i18n("Off"), this);
  Radio = new QRadioButton(i18n("On"), this);
  setExclusive(true);
  setButton(0);
}

/////////////////////////////////////////////////////////////////////////////

WBoolPortInput::~WBoolPortInput()
{
}

/////////////////////////////////////////////////////////////////////////////

NEffectPort::Type 
WBoolPortInput::portType() const
{
  return NEffectPort::Bool;
}

/////////////////////////////////////////////////////////////////////////////

NEffectPort::UValue
WBoolPortInput::portValue() const
{
  NEffectPort::UValue uvReturn;
  if ( selectedId() == 0 ) {
    uvReturn.bVal = false;
  } else {
    uvReturn.bVal = true;
  }

  return uvReturn;
}

/////////////////////////////////////////////////////////////////////////////

void 
WBoolPortInput::slotSetPortValue(NEffectPort::UValue uvValue)
{
  if ( !uvValue.bVal ) {
    setButton(0);
  } else {
    setButton(1);
  }
}

/////////////////////////////////////////////////////////////////////////////

#include "wboolportinput.moc"
