/***************************************************************************
                          wruler.cpp  -  description
                             -------------------
    begin                : 2004ǯ  6 24  00:18:12 JST
    copyright            : (C) 2003 by Tomoaki Murakami
    email                : solarisphere@yahoo.co.jp
 ***************************************************************************/

/***************************************************************************
 *   Copyright (C) 2004 by Tomoaki Murakami                                *
 *   solarisphrere@yahoo.co.jp                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "wruler.h"
#include <qpainter.h>

/////////////////////////////////////////////////////////////////////////////

WRuler::WRuler(
  int         nUnitPerPixel/*=1*/,
  QWidget*    WidgetParent/*=0*/,
  const char* cName/*=0*/)
  : QWidget(WidgetParent, cName)
{
  setMinimumHeight(12);
  slotSetScale(nUnitPerPixel);
  nPrimaryMark = 100;
  nSecondaryMark = 10;

  position = Upper;
  //  position = Lower;
}

/////////////////////////////////////////////////////////////////////////////

WRuler::~WRuler()
{
}

/////////////////////////////////////////////////////////////////////////////

void 
WRuler::setMarkPosition(MarkPosition mp)
{
  position = mp;
  QPaintEvent* event = new QPaintEvent(rect());
  paintEvent(event);
  delete event;
}

/////////////////////////////////////////////////////////////////////////////

void 
WRuler::paintEvent(QPaintEvent*)
{
  QPainter painter(this);
  QFont    font = painter.font();
  font.setPointSize(9);
  painter.setFont(font);
  painter.setPen(colorGroup().foreground());

  int nWidth = this->width();
  int i;

  if ( position == Upper ) {
    // draw base line
    painter.drawLine(0, 25, nWidth - 1, 25);

    // draw secondary marks
    // i's initial value : 5 : gantt item's origin X is 5
    for ( i = 5; i < nWidth; i += nSecondaryMark ) {
      painter.drawLine(i, 25, i, 22);
    }

    // draw primary marks and number text
    // i's initial value : 5 : gantt item's origin X is 5
    for ( i = 5; i < nWidth; i += nPrimaryMark ) {
      painter.drawLine(i, 25, i, 19);
      painter.drawText(i - 3, 17, QString("%1").arg((float)(i - 5) * (float)nScale));
    }
  } else {
    // draw base line
    painter.drawLine(0, 6, nWidth - 1, 6);

    // draw secondary marks
    // i's initial value : 5 : gantt item's origin X is 5
    for ( i = 5; i < nWidth; i += nSecondaryMark ) {
      painter.drawLine(i, 6, i, 9);
    }

    // draw primary marks and number text
    // i's initial value : 5 : gantt item's origin X is 5
    for ( i = 5; i < nWidth; i += nPrimaryMark ) {
      painter.drawLine(i, 6, i, 12);
      painter.drawText(i - 3, 24, QString("%1").arg((float)(i - 5) * (float)nScale));
    }
  }
}

/////////////////////////////////////////////////////////////////////////////

void
WRuler::slotSetScale(int nUnitPerPixel)
{
  if ( nUnitPerPixel > 0 ) {
    nScale = nUnitPerPixel;
  } else {
    nScale = 1;
  }
}

/////////////////////////////////////////////////////////////////////////////

void 
WRuler::slotSetPrimaryMark(int nPixelLength)
{
  if ( nPixelLength < 0 ) {
    return;
  }
  nPrimaryMark = nPixelLength;
}

/////////////////////////////////////////////////////////////////////////////

void 
WRuler::slotSetSecondaryMark(int nPixelLength)
{
  if ( nPixelLength < 0 ) {
    return;
  }
  nSecondaryMark = nPixelLength;
}

/////////////////////////////////////////////////////////////////////////////

#include "wruler.moc"
