/***************************************************************************
                          weffectporteditor.cpp  -  description
                             -------------------
    begin                : 2004ǯ  7 19  16:15:12 JST
    copyright            : (C) 2004 by Tomoaki Murakami
    email                : solarisphere@yahoo.co.jp
 ***************************************************************************/

/***************************************************************************
 *   Copyright (C) 2004 by Tomoaki Murakami                                *
 *   solarisphrere@yahoo.co.jp                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <qhbuttongroup.h>
#include <qradiobutton.h>
#include <qlayout.h>
#include <qlabel.h>
#include <klocale.h>
#include "wboolportinput.h"
#include "wintportinput.h"
#include "wdoubleportinput.h"
#include "weffectporteditor.h"

/////////////////////////////////////////////////////////////////////////////

WEffectPortEditor::WEffectPortEditor(
  const CLadspaEffect& effectDisplay,
  QWidget*             WidgetParent,
  const char*          cName)
  : QScrollView(WidgetParent, cName), 
    effect(effectDisplay)
{
  BoxBase = new QVBox(this->viewport());
  this->addChild(BoxBase);

  setupWidgets();
}

/////////////////////////////////////////////////////////////////////////////

WEffectPortEditor::~WEffectPortEditor()
{
}

/////////////////////////////////////////////////////////////////////////////

void 
WEffectPortEditor::setupWidgets()
{
  QValueVector<IPortValueEditor*>::iterator it = vInputs.begin();
  while ( it != vInputs.end() ) {
    delete (*it);
    (*it) = NULL;
    it++;
  }
  vInputs.clear();

  int nCount = effect.effectPortCount();
  int i;

  for ( i = 0; i < nCount; i++ ) {
    CEffectPort port = effect.effectPort(i);

    // boolean
    if ( port.type() == NEffectPort::Bool ) {
      WBoolPortInput* BoolInput = 
        new WBoolPortInput(port.name(), BoxBase);
      BoolInput->slotSetPortValue(port.value());
      vInputs.push_back(BoolInput);
    }

    // integer
    else if ( port.type() == NEffectPort::Int ) {
      WIntPortInput* IntInput = new WIntPortInput(BoxBase);
      QString strLabel = port.name();
      strLabel += QString(" [%1  -  %2]").
        arg(port.minimumValue().nVal).arg(port.maximumValue().nVal);
      IntInput->setLabel(strLabel);
      IntInput->setRange(
        port.minimumValue().nVal, 
        port.maximumValue().nVal, 
        port.minimumValue().nVal, 
        true);
      IntInput->slotSetPortValue(port.value());

      vInputs.push_back(IntInput);
    }

    // floating
    else if ( port.type() == NEffectPort::Float ) {
      WDoublePortInput* FloatInput = new WDoublePortInput(BoxBase);
      QString strLabel = port.name();
      strLabel += QString(" [%1  -  %2]").
        arg(port.minimumValue().fVal).arg(port.maximumValue().fVal);
      FloatInput->setLabel(strLabel);
      FloatInput->setRange(
        port.minimumValue().fVal, 
        port.maximumValue().fVal, 
        port.minimumValue().fVal, 
        true);
      FloatInput->slotSetPortValue(port.value());

      vInputs.push_back(FloatInput);
    }
  }

  if ( vInputs.size() == 0 ) {
    return;
  }
}

/////////////////////////////////////////////////////////////////////////////

CLadspaEffect
WEffectPortEditor::effectSetting() const
{
  CLadspaEffect effectReturn = effect;
  int i = 0;
  QValueVector<IPortValueEditor*>::const_iterator it = vInputs.begin();
  while ( it != vInputs.end() ) {
    effectReturn.setEffectPortParam(i, (*it)->portValue());

    it++;
    i++;
  }
  
  return effectReturn;
}

/////////////////////////////////////////////////////////////////////////////

void 
WEffectPortEditor::slotSetEffect(const CLadspaEffect& effectDisplay)
{
  this->effect = effectDisplay;

  setupWidgets();
}

/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////

#include "weffectporteditor.moc"
