/***************************************************************************/
/*! \file   cladspaeffect.h
    \brief  饹CLadspaEffectΥإåե롣
    \author Tomoaki Murakami
    \date   2004ǯ  7 18  15:13:12 JST
*/
/***************************************************************************/

/***************************************************************************
 *   Copyright (C) 2004 by Tomoaki Murakami                                *
 *   solarisphrere@yahoo.co.jp                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef CLADSPAEFFECT_H
#define CLADSPAEFFECT_H

#include <ladspa.h>
#include <qobject.h>
#include <qstring.h>
#include <qvaluevector.h>
#include "ceffectport.h"

/*-------------------------------------------------------------------------*/
/*! \class  CLadspaEffect
    \brief  LADSPAեȡ
*/
/*-------------------------------------------------------------------------*/
class CLadspaEffect
{
public:
  //! \brief 󥹥ȥ饯
  CLadspaEffect();
  //! \brief 󥹥ȥ饯
  CLadspaEffect(const QString& strLibFileName, const LADSPA_Descriptor* Desc);
  //! \brief ԡ󥹥ȥ饯
  CLadspaEffect(const CLadspaEffect& src);
  //! \brief ǥȥ饯
  virtual ~CLadspaEffect();
  //! \brief 黻ҡ
  CLadspaEffect& operator=(const CLadspaEffect& src);
  //! \brief ӱ黻ҡ
  bool           operator==(const CLadspaEffect& src) const;
  //! \brief ӱ黻ҡ
  bool           operator!=(const CLadspaEffect& src) const;

  //! \brief LADSPAǥץȴϢդ롣
  void bind(const QString& strLibFileName, const LADSPA_Descriptor* Desc);

  //! \brief ID֤
  ulong       id() const;
  //! \brief 饤֥ե̾Τ֤
  QString     libFileName() const;
  //! \brief ٥֤
  QString     label() const;
  //! \brief ե̾Τ֤
  QString     name() const;
  //! \brief եȥ᡼֤̾
  QString     maker() const;
  //! \brief Copyright֤
  QString     copyright() const;
  //! \brief եȥݡȿ֤
  int         effectPortCount() const;
  //! \brief եȥݡȤ֤
  //! \param nIndex ܤΥݡȤɬפꡣfrom zero
  CEffectPort effectPort(int nIndex) const;

  //! \brief եȥݡȥѥ᡼ꤹ롣
  //! \param nIndex ܤΥݡȤɬפꡣfrom zero
  //! \param uvParam ѥ᡼͡
  void setEffectPortParam(int nIndex, NEffectPort::UValue uvParam);

private:
  //! ID
  ulong   nID;
  //! 饤֥ե̾Ρ
  QString strFileName;
  //! եȥ٥롣
  QString strLabel;
  //! ե̾Ρ
  QString strName;
  //! եȥ᡼
  QString strMaker;
  //! Copyright
  QString strCopyright;
  //! եȥݡȡ
  QValueVector<CEffectPort> fxInControlPorts;
};

#endif
