/***************************************************************************
                          ceffectport.cpp  -  description
                             -------------------
    begin                : 2004ǯ  7 18  15:57:12 JST
    copyright            : (C) 2004 by Tomoaki Murakami
    email                : solarisphere@yahoo.co.jp
 ***************************************************************************/

/***************************************************************************
 *   Copyright (C) 2004 by Tomoaki Murakami                                *
 *   solarisphrere@yahoo.co.jp                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "ceffectport.h"

/////////////////////////////////////////////////////////////////////////////

CEffectPort::CEffectPort()
  : typePort(NEffectPort::Disabled)
{
  ;
}

/////////////////////////////////////////////////////////////////////////////

CEffectPort::CEffectPort(
  const QString& strPortName,
  const LADSPA_PortRangeHint& hint)
  : strName(strPortName)
{
  // boolean
  if ( LADSPA_IS_HINT_TOGGLED(hint.HintDescriptor) ) {
    typePort = NEffectPort::Bool;
  }
  // integer
  else if ( LADSPA_IS_HINT_INTEGER(hint.HintDescriptor) ) {
    typePort = NEffectPort::Int;
  }
  // else (simple floating, logarithm, sample rate)
  else {
    typePort = NEffectPort::Float;
  }

  float fValue = 1.0f;

  if ( LADSPA_IS_HINT_BOUNDED_BELOW(hint.HintDescriptor) &&
       (fValue < hint.LowerBound) ) {
    fValue = hint.LowerBound;
  }
  
  if ( LADSPA_IS_HINT_BOUNDED_ABOVE(hint.HintDescriptor) &&
       (fValue > hint.UpperBound) ) {
    fValue = hint.UpperBound;
  }

  if ( LADSPA_IS_HINT_DEFAULT_MINIMUM(hint.HintDescriptor) ) {
    fValue = hint.LowerBound;
  }

  if ( LADSPA_IS_HINT_DEFAULT_LOW(hint.HintDescriptor) ) {
    fValue = hint.LowerBound * 0.75f + hint.UpperBound * 0.25f;
  }

  if ( LADSPA_IS_HINT_DEFAULT_MIDDLE(hint.HintDescriptor) ) {
    fValue = hint.LowerBound * 0.5f + hint.UpperBound * 0.5f;
  }

  if ( LADSPA_IS_HINT_DEFAULT_HIGH(hint.HintDescriptor) ) {
    fValue = hint.LowerBound * 0.25f + hint.UpperBound * 0.75f;
  }

  if ( LADSPA_IS_HINT_DEFAULT_MAXIMUM(hint.HintDescriptor) ) {
    fValue = hint.UpperBound;
  }

  if ( LADSPA_IS_HINT_SAMPLE_RATE(hint.HintDescriptor) ) {
    fValue *= 44100;
  }

  if ( LADSPA_IS_HINT_DEFAULT_0(hint.HintDescriptor) ) {
    fValue = 0.0f;
  }

  if ( LADSPA_IS_HINT_DEFAULT_1(hint.HintDescriptor) ) {
    fValue = 1.0f;
  }
  
  if ( LADSPA_IS_HINT_DEFAULT_100(hint.HintDescriptor) ) {
    fValue = 100.0f;
  }

  if ( LADSPA_IS_HINT_DEFAULT_440(hint.HintDescriptor) ) {
    fValue = 440.0f;
  }

  float fMax, fMin;
  if ( LADSPA_IS_HINT_BOUNDED_BELOW(hint.HintDescriptor) ) {
    fMin = hint.LowerBound;
  }
  if ( LADSPA_IS_HINT_BOUNDED_ABOVE(hint.HintDescriptor) ) {
    fMax = hint.UpperBound;
  }
  if ( LADSPA_IS_HINT_SAMPLE_RATE(hint.HintDescriptor) ) {
    fMin *= 44100;
    fMax *= 44100;
  }

  switch ( this->typePort ) {
  case NEffectPort::Bool:
    this->uvMax.bVal   = static_cast<bool>(fMax);
    this->uvMin.bVal   = static_cast<bool>(fMin);
    this->uvValue.bVal = static_cast<bool>(fValue);
    break;
  case NEffectPort::Int:
    this->uvMax.nVal   = static_cast<int>(fMax);
    this->uvMin.nVal   = static_cast<int>(fMin);
    this->uvValue.nVal = static_cast<int>(fValue);
    break;
  case NEffectPort::Float:
    this->uvMax.fVal   = fMax;
    this->uvMin.fVal   = fMin;
    this->uvValue.fVal = static_cast<int>(fValue);
    break;
  default:
    break;
  }
}

/////////////////////////////////////////////////////////////////////////////

CEffectPort::CEffectPort(const CEffectPort& src)
  : typePort(src.typePort), 
    bSampleRate(src.bSampleRate),
    strName(src.strName),
    uvMax(src.uvMax), 
    uvMin(src.uvMin), 
    uvValue(src.uvValue)
{
}

/////////////////////////////////////////////////////////////////////////////

CEffectPort::~CEffectPort()
{
}

/////////////////////////////////////////////////////////////////////////////

CEffectPort&
CEffectPort::operator=(const CEffectPort& src)
{
  this->typePort = src.typePort;
  this->bSampleRate = src.bSampleRate;
  this->strName = src.strName;

  this->uvMax = src.uvMax;
  this->uvMin = src.uvMin;

  setValue(src.uvValue);

  return (*this);
}

/////////////////////////////////////////////////////////////////////////////

bool 
CEffectPort::operator==(const CEffectPort& src) const
{
  if ( this->typePort != src.typePort ) {
    return false;
  }

  if ( this->bSampleRate != src.bSampleRate ) {
    return false;
  }

  if ( this->strName != src.strName ) {
    return false;
  }

  switch ( this->typePort ) {
  case NEffectPort::Bool:
    if ( this->uvMax.bVal != src.uvMax.bVal ) {
      return false;
    }
    if ( this->uvMin.bVal != src.uvMin.bVal ) {
      return false;
    }
    if ( this->uvValue.bVal != src.uvValue.bVal ) {
      return false;
    }
    break;
  case NEffectPort::Int:
    if ( this->uvMax.nVal != src.uvMax.nVal ) {
      return false;
    }
    if ( this->uvMin.nVal != src.uvMin.nVal ) {
      return false;
    }
    if ( this->uvValue.nVal != src.uvValue.nVal ) {
      return false;
    }
    break;
  case NEffectPort::Float:
    if ( this->uvMax.fVal != src.uvMax.fVal ) {
      return false;
    }
    if ( this->uvMin.fVal != src.uvMin.fVal ) {
      return false;
    }
    if ( this->uvValue.fVal != src.uvValue.fVal ) {
      return false;
    }
    break;
  case NEffectPort::Disabled:
    break;
  }

  return true;
}

/////////////////////////////////////////////////////////////////////////////

bool 
CEffectPort::operator!=(const CEffectPort& src) const
{
  return !(this->operator==(src));
}

/////////////////////////////////////////////////////////////////////////////

NEffectPort::Type
CEffectPort::type() const
{
  return typePort;
}

/////////////////////////////////////////////////////////////////////////////

QString 
CEffectPort::name() const
{
  return strName;
}

/////////////////////////////////////////////////////////////////////////////

NEffectPort::UValue 
CEffectPort::maximumValue() const
{
  return uvMax;
}

/////////////////////////////////////////////////////////////////////////////

NEffectPort::UValue 
CEffectPort::minimumValue() const
{
  return uvMin;
}

/////////////////////////////////////////////////////////////////////////////

NEffectPort::UValue
CEffectPort::value() const
{
  return uvValue;
}

/////////////////////////////////////////////////////////////////////////////

void 
CEffectPort::setName(const QString& strPortName)
{
  this->strName = strPortName;
}

/////////////////////////////////////////////////////////////////////////////

void 
CEffectPort::setMaximumValue(NEffectPort::UValue uvMaxValue)
{
  this->uvMax = uvMaxValue;
}

/////////////////////////////////////////////////////////////////////////////

void 
CEffectPort::setMinimumValue(NEffectPort::UValue uvMinValue)
{
  this->uvMin = uvMinValue;
}

/////////////////////////////////////////////////////////////////////////////

void 
CEffectPort::setValue(NEffectPort::UValue uvPortValue)
{
  switch ( this->typePort ) {
  case NEffectPort::Bool:
    this->uvMin.bVal = uvPortValue.bVal;
    break;
  case NEffectPort::Int:
    if ( uvPortValue.nVal < this->uvMin.nVal ) {
      this->uvValue.nVal = this->uvMin.nVal;
    } else if ( uvPortValue.nVal > this->uvMax.nVal ) {
      this->uvValue.nVal = this->uvMax.nVal;
    } else {
      this->uvValue.nVal = uvPortValue.nVal;
    }
    break;
  case NEffectPort::Float:
    if ( uvPortValue.fVal < this->uvMin.fVal ) {
      this->uvValue.fVal = this->uvMin.fVal;
    } else if ( uvPortValue.fVal > this->uvMax.fVal ) {
      this->uvValue.fVal = this->uvMax.fVal;
    } else {
      this->uvValue.fVal = uvPortValue.fVal;
    }
    break;
  default:
    return;
  }
}

/////////////////////////////////////////////////////////////////////////////
