/***************************************************************************
                          cecamanager.cpp  -  description
                             -------------------
    begin                : 2003ǯ  7 16  22:42:12 JST
    copyright            : (C) 2003 by Black Sabbath
    email                : solarisphere@yahoo.co.jp
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <string.h>
#include <unistd.h>
#include <qfile.h>
#include <qregexp.h>
#include "cvoxstormglobal.h"
#include "cecamanager.h"

/////////////////////////////////////////////////////////////////////////////

const QString CEcaManager::EcasoundCmd("ecasound");

/////////////////////////////////////////////////////////////////////////////

CEcaManager::CEcaManager()
{
  ppcArgs = NULL;
}

/////////////////////////////////////////////////////////////////////////////

CEcaManager::~CEcaManager()
{
  if ( ppcArgs != NULL ) {
    clear();
  }
}

/////////////////////////////////////////////////////////////////////////////

void 
CEcaManager::addTrackToChain(const CTrackInf& TrackInfAdd)
{
  vTrackChains.push_back(TrackInfAdd);
}

/////////////////////////////////////////////////////////////////////////////

void
CEcaManager::clear()
{
  vTrackChains.clear();
  this->releaseArgs();
  strlArgs.clear();

}

/////////////////////////////////////////////////////////////////////////////

QString
CEcaManager::compile(bool bRecPause, bool bOutCmdLine)
{
  int       nLoop, i;
  QString   strChain;
  QString   strOutput;
  QString   strDevice;

  strlArgs.append(EcasoundCmd);

  nLoop = vTrackChains.size();
  for ( i = 0; i < nLoop; i++ ) {
    if ( vTrackChains[i].bMute ) {  // mute
      continue;
    }
    if ( vTrackChains[i].strFileName == "" ) {  // no file name
      continue;
    }

    // set track name
    strChain  = "-a:";
    strChain += vTrackChains[i].strTrackName;

    if ( bRecPause && vTrackChains[i].bRecPort ) {  // recording track
      strlArgs.append(strChain);    // append "-a:track_name"

      // set input
      strlArgs.append("-i");      // append "-i"
      strlArgs.append(vTrackChains[i].strInputDevice);  // append "device_name"

      // set output
      strlArgs.append("-o");      // append "-o"
      strlArgs.append(vTrackChains[i].strFileName);  // append "file_name"
      
    } else {                                        // playing track
      QFile FileSound;
      if ( FileSound.exists(vTrackChains[i].strFileName) ) {
        strlArgs.append(strChain);    // append "-a:track_name"

        // set input
        strlArgs.append("-i");      // append "-i"
        strlArgs.append(vTrackChains[i].strFileName);  // append "file_name"

        // set output
        if ( strOutput == "" ) {  // first output
          strOutput = "-a:";
          strDevice = vTrackChains[i].strOutputDevice;
        }
        strOutput += vTrackChains[i].strTrackName;
        strOutput += ",";

        // set level
        strChain.sprintf("%d", vTrackChains[i].nLevel);
        strlArgs.append("-ea:" + strChain);           // append "-ea:level"

        // set pan
        strChain.sprintf("%d", vTrackChains[i].nPan);
        strlArgs.append("-epp:" + strChain);          // append "-epp:level"
      }
    }
  }
  if ( strOutput != "" ) {      // exsists output
    strOutput.truncate(strOutput.length() -1);  // remove last ","
    strlArgs.append(strOutput); // append string like "-a:1,2,3"
    strlArgs.append("-o");      // append "-o"
    strlArgs.append(strDevice);
  }

  this->releaseArgs();

  QString strResult;

  if ( bOutCmdLine ) {
    nLoop = strlArgs.count();
    for ( i = 0; i < nLoop; i++ ) {
      if ( strlArgs[i].find(' ') != -1 ) { // argument contains space
        strResult += "\"";
        strResult += strlArgs[i];
        strResult += "\" ";
      } else {                          // not contails space
        strResult += strlArgs[i];
        strResult += " ";
      }
    }
    strResult.stripWhiteSpace();
  }

  this->makeArgs();

  return strResult;
}

/////////////////////////////////////////////////////////////////////////////

bool
CEcaManager::overwriteSettings(const QString& strCmd)
{
  QString     strArg = strCmd;
  QStringList strlBackup;

  if ( strArg.find(QRegExp("//[0-9]+//")) != -1 ) { // invalid
    return false;
  }

  strArg.replace("\\\n", "");     // remove backslash return
  strArg = CVoxStormGlobal::replaceQuartedToSlash(strArg, &strlBackup);
  printf("CVoxStormGlobal::replaceQuartedToSlash : %s\n", strArg.ascii());

  strArg = strArg.simplifyWhiteSpace(); // \n, \t, etc -> \s
  strArg = strArg.stripWhiteSpace();    // trim
  if ( !strArg.startsWith(EcasoundCmd + " ") ) {
    return false;
  }

  strArg += " ";  // ʹߤκȤΤ˺Ǹ˥ڡɬ
  QString strTmp = strArg;
  if ( strTmp.find(" -c ", 8) != -1 ) {
    return false;
  }

  this->clear();  // therefor we can compile again

  int i, j, nLoop, nPos, nFind;
  nLoop = strArg.contains(QChar(' '));
  for ( i = j = nPos = 0; i < nLoop; i++ ) {
    nFind = strArg.find(QChar(' '), nPos);
    strlArgs.append(strArg.mid(nPos, nFind - nPos)); // -1 : for space character
    nPos = nFind + 1;

    if ( strlArgs[i].find("//") != -1 ) { // replaced -> rebuild
      strlArgs[i].replace(QRegExp("//[0-9]+//"), strlBackup[j]);
      j++;
    }
  }

  this->makeArgs();

  return true;
}

/////////////////////////////////////////////////////////////////////////////

void
CEcaManager::start(int* pnStatus)
{
  if ( pnStatus != NULL ) {
    *pnStatus = 0;  // initialize
  }

  if ( ppcArgs == NULL ) {  // not compiled
    if ( pnStatus != NULL ) {
      *pnStatus = -3;
    }
    return;
  }
  if ( strlArgs.count() == 1 ) {  // no track
    if ( pnStatus != NULL ) {
      *pnStatus = -2;
    }
    return;
  }

  if ( execvp(EcasoundCmd.ascii(), ppcArgs) == -1 ) {
    perror("execvp");
    if ( pnStatus != NULL ) {
      *pnStatus = -1;
    }
    return;
  }
}

/////////////////////////////////////////////////////////////////////////////

void
CEcaManager::stop()
{
}

/////////////////////////////////////////////////////////////////////////////

bool
CEcaManager::isCompiled() const
{
  if ( ppcArgs == NULL ) {  // not compiled
    return false;
  } else {
    return true;
  }
}

/////////////////////////////////////////////////////////////////////////////

void
CEcaManager::makeArgs()
{
  uint nLen;
  int  i, nLoop;

  if ( ppcArgs != NULL ) {
    this->releaseArgs();
  }

  nLoop = strlArgs.count();
  printf("printing strlArgs\n");
  for ( i = 0; i < nLoop; i++ ) {
    printf("%d, %s\n", i, strlArgs[i].ascii());
  }
  printf("done\n\n");
  
  nLoop = strlArgs.count();
  ppcArgs = new char*[nLoop + 1]; // + 1 : for NULL string
  for ( i = 0; i < nLoop; i++ ) {
    nLen = strlArgs[i].length();
    ppcArgs[i] = new char[nLen + 1];
    strcpy(ppcArgs[i], strlArgs[i].ascii());
  }
  ppcArgs[i] = NULL;

  printf("test ppcArgs\n");
  for ( i = 0; i < nLoop; i++ ) {
    printf("%d, %s\n", i, ppcArgs[i]);
  }
  printf("done\n\n");
}

/////////////////////////////////////////////////////////////////////////////

void
CEcaManager::releaseArgs()
{
  if ( ppcArgs != NULL ) {
    int nLoop, i;
    nLoop = strlArgs.count();
    for ( i = 0; i < nLoop; i++ ) {
      delete [] ppcArgs[i];
    }
    delete [] ppcArgs;
    ppcArgs = NULL;
  }
}

/////////////////////////////////////////////////////////////////////////////

void
CEcaManager::setInput(const QString& strFileName)
{
  strInput = strFileName;
}

/////////////////////////////////////////////////////////////////////////////

void
CEcaManager::setOutput(const QString& strFileName)
{
  strOutput = strFileName;
}

/////////////////////////////////////////////////////////////////////////////

int
CEcaManager::getIndexByName(const QString& strTrackName) const
{
  int i, nTrack;

  nTrack = vTrackChains.size();
  for ( i = 0; i < nTrack; i++ ) {
    if ( strTrackName == vTrackChains[i].strTrackName ) {
      return i;
    }
  }

  return -1;
}

/////////////////////////////////////////////////////////////////////////////

void
CEcaManager::slotChangeLevel(const QString& strTrackName, int nLevel)
{
}

/////////////////////////////////////////////////////////////////////////////

void 
CEcaManager::slotChangePan(const QString& strTrackName, int nPan)
{
}

/////////////////////////////////////////////////////////////////////////////

void 
CEcaManager::slotToggleMute(const QString& strTrackName, bool bMute)
{
}

/////////////////////////////////////////////////////////////////////////////

void 
CEcaManager::slotToggleRec(const QString& strTrackName, bool bRec)
{
}

/////////////////////////////////////////////////////////////////////////////

#include "cecamanager.moc"
