/***************************************************************************
                          cladspaeffect.cpp  -  description
                             -------------------
    begin                : 2004ǯ  7 18  16:28:12 JST
    copyright            : (C) 2004 by Tomoaki Murakami
    email                : solarisphere@yahoo.co.jp
 ***************************************************************************/

/***************************************************************************
 *   Copyright (C) 2004 by Tomoaki Murakami                                *
 *   solarisphrere@yahoo.co.jp                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "cladspaeffect.h"

/////////////////////////////////////////////////////////////////////////////

CLadspaEffect::CLadspaEffect()
{
  
}

/////////////////////////////////////////////////////////////////////////////

CLadspaEffect::CLadspaEffect(
  const QString& strLibFileName,
  const LADSPA_Descriptor* Desc)
{
  bind(strLibFileName, Desc);
}

/////////////////////////////////////////////////////////////////////////////

CLadspaEffect::CLadspaEffect(const CLadspaEffect& src)
{
  nID          = src.nID;
  strFileName  = src.strFileName;
  strName      = src.strName;
  strMaker     = src.strMaker;
  strCopyright = src.strCopyright;
  effectPorts  = src.effectPorts;
}

/////////////////////////////////////////////////////////////////////////////

CLadspaEffect::~CLadspaEffect()
{
}

/////////////////////////////////////////////////////////////////////////////

CLadspaEffect&
CLadspaEffect::operator=(const CLadspaEffect& src)
{
  nID          = src.nID;
  strFileName  = src.strFileName;
  strName      = src.strName;
  strMaker     = src.strMaker;
  strCopyright = src.strCopyright;
  effectPorts  = src.effectPorts;

  return (*this);
}

/////////////////////////////////////////////////////////////////////////////

void 
CLadspaEffect::bind(
  const QString& strLibFileName, 
  const LADSPA_Descriptor* Desc)
{
  if ( Desc == NULL ) {
    return;
  }

  nID          = Desc->UniqueID;
  strFileName  = strLibFileName;
  strName      = Desc->Name;
  strMaker     = Desc->Maker;
  strCopyright = Desc->Copyright;

  effectPorts.clear();
  int i;
  int nPortCount = Desc->PortCount;
  for ( i = 0; i < nPortCount; i++ ) {
    effectPorts.push_back(
      CEffectPort(Desc->PortNames[i], Desc->PortRangeHints[i]));
  }
}

/////////////////////////////////////////////////////////////////////////////

ulong
CLadspaEffect::id() const
{
  return nID;
}

/////////////////////////////////////////////////////////////////////////////

QString
CLadspaEffect::libFileName() const
{
  return strFileName;
}

/////////////////////////////////////////////////////////////////////////////

QString
CLadspaEffect::name() const
{
  return strName;
}

/////////////////////////////////////////////////////////////////////////////

QString
CLadspaEffect::maker() const
{
  return strMaker;
}

/////////////////////////////////////////////////////////////////////////////

QString 
CLadspaEffect::copyright() const
{
  return strCopyright;
}

/////////////////////////////////////////////////////////////////////////////

int
CLadspaEffect::effectPortCount() const
{
  return effectPorts.size();
}

/////////////////////////////////////////////////////////////////////////////

CEffectPort
CLadspaEffect::effectPort(int nIndex) const
{
  if ( (nIndex < 0) || 
       (effectPorts.size() <= static_cast<uint>(nIndex)) ) {
    return CEffectPort();
  }
  
  return effectPorts[nIndex];
}

/////////////////////////////////////////////////////////////////////////////

void 
CLadspaEffect::setEffectPortParam(int nIndex, float fParam)
{
  if ( (nIndex < 0) || 
       (effectPorts.size() <= static_cast<uint>(nIndex)) ) {
    return;
  }

  effectPorts[nIndex].setValue(fParam);
}
  
/////////////////////////////////////////////////////////////////////////////
