/***************************************************************************/
/*! \file   ceffectport.h
    \brief  饹CEffectPortΥإåե롣
    \author Tomoaki Murakami
    \date   2004ǯ  7 18  15:53:12 JST
*/
/***************************************************************************/

/***************************************************************************
 *   Copyright (C) 2004 by Tomoaki Murakami                                *
 *   solarisphrere@yahoo.co.jp                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef CEFFECTPORT_H
#define CEFFECTPORT_H

#include <ladspa.h>
#include <qobject.h>
#include <qstring.h>

/*-------------------------------------------------------------------------*/
/*! \class  CEffectPort
    \brief  LADSPAեȤΥѥ᡼ݡȡ
*/
/*-------------------------------------------------------------------------*/
class CEffectPort
{
public:
  //! \brief 󥹥ȥ饯
  CEffectPort();
  //! \brief 󥹥ȥ饯
  CEffectPort(const QString& strPortName, const LADSPA_PortRangeHint& hint);
  //! \brief ԡ󥹥ȥ饯
  CEffectPort(const CEffectPort& src);
  //! \brief ǥȥ饯
  ~CEffectPort();
  //! \brief 黻ҡ
  CEffectPort& operator=(const CEffectPort& src);

  //! ̾Τ֤
  QString name() const;
  //! ֤ͤ
  float   maximumValue() const;
  //! Ǿ֤ͤ
  float   minimumValue() const;
  //! ֤ͤ
  float   value() const;

  //! ̾Τꤹ롣
  void setName(const QString& strPortName);
  //! ͤꤹ롣
  void setMaximumValue(float fMaxValue);
  //! Ǿͤꤹ롣
  void setMinimumValue(float fMinValue);
  //! ͤꤹ롣
  void setValue(float fPortValue);

private:
  //! ̾Ρ
  QString strName;
  //! 
  float   fMax;
  //! Ǿ
  float   fMin;
  //! 
  float   fValue;
};

#endif
