/***************************************************************************
                          wsoundlocator.cpp  -  description
                             -------------------
    begin                : 2004ǯ  5 30  02:16:12 JST
    copyright            : (C) 2003 by Tomoaki Murakami
    email                : solarisphere@yahoo.co.jp
 ***************************************************************************/

/***************************************************************************
 *   Copyright (C) 2004 by Tomoaki Murakami                                *
 *   solarisphrere@yahoo.co.jp                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <qfileinfo.h>
#include <qlayout.h>
#include "wsoundlocator.h"
#include "cecatools.h"

/////////////////////////////////////////////////////////////////////////////

WSoundLocator::WSoundLocator(
  const QTime& timeMaxSession, 
  QWidget*     WidgetParent, 
  const char*  cName)
 : QScrollView(WidgetParent, cName), nRemainder(0)
{
  setFrameStyle(QFrame::WinPanel | QFrame::Plain);
  setHScrollBarMode(QScrollView::AlwaysOn);
  setVScrollBarMode(QScrollView::AlwaysOff);

  WidgetBase = new QWidget(this);

  QVBoxLayout* VBoxLayout = new QVBoxLayout(WidgetBase);

  Ruler = new WRuler(1, WidgetBase);
  Ruler->setPaletteBackgroundColor(colorGroup().background());
  Ruler->setPaletteForegroundColor(colorGroup().foreground());
  VBoxLayout->addWidget(Ruler);

  GanttItem = new WGanttItem(QColor(111, 109, 158),
                             QColor(138, 136, 197),
                             WidgetBase);
  QTime timeTmp;
  WidgetBase->setMaximumWidth(timeTmp.secsTo(timeMaxSession));
  WidgetBase->setMinimumWidth(timeTmp.secsTo(timeMaxSession));
  //  WidgetBase->setMaximumHeight(GanttItem->height());
  //  WidgetBase->setMinimumHeight(GanttItem->height());
  addChild(WidgetBase);
  GanttItem->move(0, 0);
  VBoxLayout->addWidget(GanttItem);

  GanttItem->hide();

  WidgetBase->setMinimumHeight(GanttItem->height() + Ruler->height());
  WidgetBase->setMaximumHeight(GanttItem->height() + Ruler->height());

  connect(GanttItem,
          SIGNAL(startPositionChanged(int)),
          this, 
          SLOT(slotChangedStartPosition(int)));
  connect(GanttItem, 
          SIGNAL(offsetChanged(int)), 
          this,
          SLOT(slotChangedOffset(int)));
  connect(GanttItem, 
          SIGNAL(lengthChanged(int)),
          this, 
          SLOT(slotChangedLength(int)));
}

/////////////////////////////////////////////////////////////////////////////

WSoundLocator::~WSoundLocator()
{
}

/////////////////////////////////////////////////////////////////////////////

void
WSoundLocator::bind(const QString& strFileName)
{
  strSrcFileName = strFileName;

  QFileInfo fileInfo(strFileName);
  if ( !fileInfo.exists() ) {
    GanttItem->hide();
    return;
  }

  CEcaTools ecaTools;
  QTime time = ecaTools.sourceLength(strFileName);
  nRemainder = time.msec();
  QTime timeTmp;
  GanttItem->slotSetMaximumLength(timeTmp.secsTo(time));
  GanttItem->slotSetText(time.toString("mm:ss.zzz"));
  GanttItem->show();
}

/////////////////////////////////////////////////////////////////////////////

void 
WSoundLocator::setBaseColor(const QColor& color)
{
  WidgetBase->setPaletteBackgroundColor(color);
}

/////////////////////////////////////////////////////////////////////////////

void 
WSoundLocator::setItemFaceColor(const QColor& color)
{
  GanttItem->setPaletteBackgroundColor(color);
}

/////////////////////////////////////////////////////////////////////////////

void 
WSoundLocator::setItemEdgeColor(const QColor& color)
{
  GanttItem->setPaletteEdgeColor(color);
}

/////////////////////////////////////////////////////////////////////////////

void 
WSoundLocator::setMaxSessionLength(const QTime& time)
{
  QTime timeTmp;
  int nPix = timeTmp.secsTo(time);

  WidgetBase->setMaximumWidth(nPix);
  WidgetBase->setMinimumWidth(nPix);
}

/////////////////////////////////////////////////////////////////////////////

QTime
WSoundLocator::sourceLength() const
{
  CEcaTools ecaTools;
  return ecaTools.sourceLength(strSrcFileName);
}

/////////////////////////////////////////////////////////////////////////////

QTime
WSoundLocator::startPosition() const
{
  QTime time;
  return (time.addSecs(GanttItem->startPosition())).addMSecs(nRemainder);
}

/////////////////////////////////////////////////////////////////////////////

QTime
WSoundLocator::offset() const
{
  QTime time;
  return (time.addSecs(GanttItem->offset())).addMSecs(nRemainder);
}

/////////////////////////////////////////////////////////////////////////////

QTime 
WSoundLocator::length() const
{
  QTime time;
  return (time.addSecs(GanttItem->length())).addMSecs(nRemainder);
}

/////////////////////////////////////////////////////////////////////////////

void 
WSoundLocator::slotSetStartPosition(const QTime& time)
{
  if ( startPosition() == time ) {
    return;
  }

  nRemainder = time.msec();
  QTime timeTmp;
  GanttItem->slotSetStartPosition(timeTmp.secsTo(time));
}

/////////////////////////////////////////////////////////////////////////////

void 
WSoundLocator::slotSetOffset(const QTime& time)
{
  if ( offset() == time ) {
    return;
  }

  nRemainder = time.msec();
  QTime timeTmp;
  GanttItem->slotSetOffset(timeTmp.secsTo(time));
}

/////////////////////////////////////////////////////////////////////////////

void 
WSoundLocator::slotSetLength(const QTime& time)
{
  QTime timeTmp;

  // time is ZERO : souce-length
  if ( timeTmp.msecsTo(time) == 0 ) {
    timeTmp = sourceLength();
    nRemainder = timeTmp.msec();
    GanttItem->slotSetLength(time.secsTo(timeTmp));
    GanttItem->slotSetText(timeTmp.toString("mm:ss.zzz"));
    return;
  }

  GanttItem->slotSetText(time.toString("mm:ss.zzz"));
  if ( length() == time ) {
    return;
  }

  nRemainder = time.msec();
  GanttItem->slotSetLength(timeTmp.secsTo(time));
}

/////////////////////////////////////////////////////////////////////////////

void 
WSoundLocator::slotSetItemEnabled(bool bEnabled)
{
  GanttItem->setEnabled(bEnabled);
}

/////////////////////////////////////////////////////////////////////////////

void 
WSoundLocator::slotChangedStartPosition(int nSecond)
{
  QTime time;
  emit startPositionChanged((time.addSecs(nSecond)).addMSecs(nRemainder));
}

/////////////////////////////////////////////////////////////////////////////

void 
WSoundLocator::slotChangedOffset(int nSecond)
{
  QTime time;
  emit offsetChanged((time.addSecs(nSecond)).addMSecs(nRemainder));
}

/////////////////////////////////////////////////////////////////////////////

void 
WSoundLocator::slotChangedLength(int nSecond)
{
  QTime time;
  emit lengthChanged((time.addSecs(nSecond)).addMSecs(nRemainder));
}

/////////////////////////////////////////////////////////////////////////////

#include "wsoundlocator.moc"
