/***************************************************************************
                          cecatools.cpp  -  description
                             -------------------
    begin                : 2004ǯ  5 29  00:47:12 JST
    copyright            : (C) 2004 by Tomoaki Murakami
    email                : solarisphere@yahoo.co.jp
 ***************************************************************************/

/***************************************************************************
 *   Copyright (C) 2004 by Tomoaki Murakami                                *
 *   solarisphrere@yahoo.co.jp                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "cecatools.h"

/////////////////////////////////////////////////////////////////////////////

CEcaTools::CEcaTools()
{
  command("cs-add EcaTools");
}

/////////////////////////////////////////////////////////////////////////////

CEcaTools::~CEcaTools()
{
  command("cs-disconnect");
  command("cs-remove");
}

/////////////////////////////////////////////////////////////////////////////

QTime
CEcaTools::sourceLength(const QString& strFileName)
{
  command("c-add Len");
  command("ai-add " + DQ + strFileName + DQ);
  command("ao-add /tmp/tmp.wav");
  command("ai-attach");
  command("ao-attach");
  command("cs-connect");
  command("cs-get-length");

  double dLength = lastFloat();

  command("ai-remove");
  command("ao-remove");
  command("c-remove");
  command("cs-disconnect");

  QTime timeTmp;
  return timeTmp.addMSecs(static_cast<int>(dLength * 1000.0));
}

/////////////////////////////////////////////////////////////////////////////

CSourceFormat::SampleFormat
CEcaTools::sampleFormat(const QString& strFileName)
{
  command("c-add Format");
  command("ai-add " + DQ + strFileName + DQ);
  command("ai-get-format");

  QString strFormats = lastString();

  command("ai-remove");
  command("c-remove");

  QStringList strlFormats = QStringList::split(",", strFormats);
  if ( strlFormats.size() != 3 ) {
    return CSourceFormat::Invalid;
  }

  return CSourceFormat::sampleFormatIdentifier(strlFormats[0]);
}

/////////////////////////////////////////////////////////////////////////////
