/*
 * Decompiled with CFR 0.152.
 */
package org.tonouchi.vocabulardb;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.tonouchi.vocabularconfig.Config;
import org.tonouchi.vocabulardb.WordCard;
import org.tonouchi.vocabulardb.WordList;

public class DBService {
    private static final DBService service = new DBService();
    private Connection con = null;

    public static DBService getDBService() {
        return service;
    }

    public void initialize(Connection con) {
        this.con = con;
    }

    public void begin() {
        try {
            this.con.setAutoCommit(false);
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }

    public void commit() {
        try {
            this.con.commit();
            this.con.setAutoCommit(true);
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }

    public void rollback() {
        try {
            this.con.rollback();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void updateACard(WordCard wordCard) {
        try {
            String sql = "update cards set word=?, pos=?, japanese=?, english=?, example=? where id=?";
            PreparedStatement prepStmt = this.con.prepareStatement(sql);
            prepStmt.setString(1, wordCard.getWord());
            prepStmt.setString(2, wordCard.getPos());
            prepStmt.setString(3, wordCard.getJapanese());
            prepStmt.setString(4, wordCard.getEnglish());
            prepStmt.setString(5, wordCard.getExample());
            prepStmt.setInt(6, wordCard.getId());
            prepStmt.executeUpdate();
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }

    public void deleteAList(WordList list) {
        try {
            this.begin();
            PreparedStatement prepStmtDelList = this.con.prepareStatement("delete from binders where id=?");
            prepStmtDelList.setInt(1, list.getId());
            PreparedStatement prepStmtDelCards = this.con.prepareStatement("delete from cards where list_id=?");
            prepStmtDelCards.setInt(1, list.getId());
            prepStmtDelList.executeUpdate();
            prepStmtDelCards.executeUpdate();
            this.commit();
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            this.rollback();
        }
    }

    public void deleteACard(WordCard wordCard) {
        try {
            String sql = "delete from cards where id=?";
            PreparedStatement prepStmt = this.con.prepareStatement(sql);
            prepStmt.setInt(1, wordCard.getId());
            prepStmt.executeUpdate();
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }

    public List<WordCard> getCards(WordList list) {
        ArrayList<WordCard> wordCards = new ArrayList<WordCard>();
        try {
            PreparedStatement prepStmt = this.con.prepareStatement("select * from cards where list_id=?");
            prepStmt.setInt(1, list.getId());
            ResultSet rset = prepStmt.executeQuery();
            if (rset.first()) {
                do {
                    WordCard wordCard = new WordCard();
                    wordCard.setId(rset.getInt("id"));
                    wordCard.setWord(rset.getString("word"));
                    wordCard.setPos(rset.getString("pos"));
                    wordCard.setJapanese(rset.getString("japanese"));
                    wordCard.setEnglish(rset.getString("english"));
                    wordCard.setExample(rset.getString("example"));
                    wordCard.setCreated(rset.getTimestamp("created"));
                    wordCards.add(wordCard);
                } while (rset.next());
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        return wordCards;
    }

    public List<WordCard> getAllCards() {
        ArrayList<WordCard> wordCards = new ArrayList<WordCard>();
        try {
            ResultSet rset = this.con.createStatement().executeQuery("select * from cards");
            if (rset.first()) {
                do {
                    WordCard wordCard = new WordCard();
                    wordCard.setId(rset.getInt("id"));
                    wordCard.setWord(rset.getString("word"));
                    wordCard.setPos(rset.getString("pos"));
                    wordCard.setJapanese(rset.getString("japanese"));
                    wordCard.setEnglish(rset.getString("english"));
                    wordCard.setExample(rset.getString("example"));
                    wordCard.setCreated(rset.getTimestamp("created"));
                    wordCards.add(wordCard);
                } while (rset.next());
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        return wordCards;
    }

    public List<WordList> getWordLists() {
        ArrayList<WordList> wordList = new ArrayList<WordList>();
        try {
            ResultSet rset = this.con.createStatement().executeQuery("select * from binders");
            if (rset.first()) {
                do {
                    WordList list = new WordList();
                    list.setId(rset.getInt("id"));
                    list.setName(rset.getString("name"));
                    list.setCreated(rset.getTimestamp("created"));
                    wordList.add(list);
                } while (rset.next());
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        return wordList;
    }

    public void persistWordList(WordList wordList, List<WordCard> wordCards) {
        this.begin();
        this.persistWordList(wordList);
        int wordListIdToBeUsed = this.getCurrentWordListId();
        wordList.setId(wordListIdToBeUsed);
        for (WordCard wordCard : wordCards) {
            wordCard.setListId(wordListIdToBeUsed);
            this.persistWordCard(wordCard);
        }
        this.commit();
    }

    private void persistWordCard(WordCard wordCard) {
        try {
            PreparedStatement prepStmt = this.con.prepareStatement("insert into cards(word, pos, japanese, english, example, list_id) values(?, ?, ?, ?, ?, ?)");
            prepStmt.setString(1, wordCard.getWord());
            prepStmt.setString(2, wordCard.getPos());
            prepStmt.setString(3, wordCard.getJapanese());
            prepStmt.setString(4, wordCard.getEnglish());
            prepStmt.setString(5, wordCard.getExample());
            prepStmt.setInt(6, wordCard.getListId());
            prepStmt.executeUpdate();
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }

    private void persistWordList(WordList wordList) {
        try {
            PreparedStatement prepStmt = this.con.prepareStatement("insert into binders(name) values(?)");
            prepStmt.setString(1, wordList.getName());
            prepStmt.executeUpdate();
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }

    public int getCurrentWordCardId() {
        return this.getCurrentId("CARDS");
    }

    public int getCurrentWordListId() {
        return this.getCurrentId("BINDERS");
    }

    private int getCurrentId(String name) {
        String sql = "select INFORMATION_SCHEMA.SEQUENCES.CURRENT_VALUE as CURRENT_VALUE from INFORMATION_SCHEMA.COLUMNS , INFORMATION_SCHEMA.SEQUENCES  where INFORMATION_SCHEMA.SEQUENCES.SEQUENCE_NAME=INFORMATION_SCHEMA.COLUMNS.SEQUENCE_NAME AND INFORMATION_SCHEMA.COLUMNS.TABLE_NAME=? AND INFORMATION_SCHEMA.COLUMNS.COLUMN_NAME='ID'";
        try {
            PreparedStatement prepStmt = this.con.prepareStatement(sql);
            prepStmt.setString(1, name);
            ResultSet rset = prepStmt.executeQuery();
            rset.first();
            int retVal = rset.getInt("CURRENT_VALUE");
            return retVal;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return -1;
        }
    }

    public void setUpConfig() {
        String sql = "select * from configure";
        try {
            PreparedStatement prepStmt = this.con.prepareStatement(sql);
            ResultSet rset = prepStmt.executeQuery();
            if (rset.first()) {
                Config config = Config.getConfig();
                config.setUseSmartFm(rset.getBoolean("use_smart_fm"));
                config.setSmartFmAsEJ(rset.getBoolean("smart_fm_as_ej"));
                config.setSmartFmAsEx(rset.getBoolean("smart_fm_as_ex"));
                config.setUseWordNet(rset.getBoolean("use_word_net"));
                config.setWordNetAsEE(rset.getBoolean("word_net_as_ee"));
                config.setWordNetAsEx(rset.getBoolean("word_net_as_ex"));
                config.setPathToWordNet(rset.getString("path_to_word_net"));
                config.setPathToFont(rset.getString("path_to_font"));
                config.setUsePdic(rset.getBoolean("use_pdic"));
                config.setPathToPdic(rset.getString("path_to_pdic"));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void updateConfigure() {
        String sql = "update configure set use_smart_fm=?, smart_fm_as_ej=?, smart_fm_as_ex=?, use_word_net=?, word_net_as_ee=?, word_net_as_ex=?, path_to_word_net=?, path_to_font=?, use_pdic=?, path_to_pdic=?";
        try {
            PreparedStatement prepStmt = this.con.prepareStatement(sql);
            Config config = Config.getConfig();
            prepStmt.setBoolean(1, config.isUseSmartFm());
            prepStmt.setBoolean(2, config.isSmartFmAsEJ());
            prepStmt.setBoolean(3, config.isSmartFmAsEx());
            prepStmt.setBoolean(4, config.isUseWordNet());
            prepStmt.setBoolean(5, config.isWordNetAsEE());
            prepStmt.setBoolean(6, config.isWordNetAsEx());
            prepStmt.setString(7, config.getPathToWordNet());
            prepStmt.setString(8, config.getPathToFont());
            prepStmt.setBoolean(9, config.isUsePdic());
            prepStmt.setString(10, config.getPathToPdic());
            prepStmt.executeUpdate();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

