/*
 * Decompiled with CFR 0.152.
 */
package org.tonouchi.vocable.gui;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Date;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import org.tonouchi.vocable.gui.DictionaryComboBoxModel;
import org.tonouchi.vocable.gui.VocabularFrame;
import org.tonouchi.vocable.gui.WordListContext;
import org.tonouchi.vocabulardb.DBService;
import org.tonouchi.vocabulardb.WordList;
import org.tonouchi.vocabulardictionary.DictionaryService;

public class MakeListDialog
extends JDialog {
    private WordListContext context = new WordListContext();
    private JPanel end;
    private JComboBox english;
    private JComboBox example;
    private JButton goNext;
    private JButton gonext;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JScrollPane jScrollPane1;
    private JToggleButton jToggleButton1;
    private JComboBox japanese;
    private JLabel lblListName;
    private JLabel lblNavi;
    private JTextField listName;
    private JTextField pos;
    private JLabel registeredListName;
    private JLabel registeredWordCount;
    private JPanel step1;
    private JPanel stepWords;
    private JTextField word;
    private JTextPane words;

    public MakeListDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    private void initComponents() {
        this.step1 = new JPanel();
        this.lblListName = new JLabel();
        this.listName = new JTextField();
        this.lblNavi = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.words = new JTextPane();
        this.goNext = new JButton();
        this.stepWords = new JPanel();
        this.jLabel2 = new JLabel();
        this.jLabel1 = new JLabel();
        this.word = new JTextField();
        this.jLabel3 = new JLabel();
        this.pos = new JTextField();
        this.jLabel4 = new JLabel();
        this.japanese = new JComboBox();
        this.jLabel5 = new JLabel();
        this.english = new JComboBox();
        this.jLabel6 = new JLabel();
        this.example = new JComboBox();
        this.gonext = new JButton();
        this.end = new JPanel();
        this.jLabel7 = new JLabel();
        this.registeredListName = new JLabel();
        this.registeredWordCount = new JLabel();
        this.jToggleButton1 = new JToggleButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("\u65b0\u898f\u30ea\u30b9\u30c8\u306e\u4f5c\u6210");
        this.setResizable(false);
        this.getContentPane().setLayout(new CardLayout());
        this.lblListName.setText("\u30ea\u30b9\u30c8\u540d");
        this.listName.setText("\u65b0\u3057\u3044\u30ea\u30b9\u30c8 - " + new Date().toString());
        this.listName.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                MakeListDialog.this.listNameFocusLost(evt);
            }
        });
        this.listName.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                MakeListDialog.this.listNameKeyReleased(evt);
            }
        });
        this.lblNavi.setText("\u4ee5\u4e0b\u306e\u30c6\u30ad\u30b9\u30c8\u30a8\u30ea\u30a2\u306b\u767b\u9332\u3057\u305f\u3044\u30dc\u30ad\u30e3\u30d6\u30e9\u30ea\u3092\u300c;\u300d\u3067\u533a\u5207\u3063\u3066\u8a18\u5165\u3057\u3066\u304f\u3060\u3055\u3044");
        this.words.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                MakeListDialog.this.wordsFocusLost(evt);
            }
        });
        this.words.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                MakeListDialog.this.wordsKeyReleased(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.words);
        this.goNext.setText("\u6b21\u3078");
        this.goNext.setEnabled(false);
        this.goNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MakeListDialog.this.goNextActionPerformed(evt);
            }
        });
        GroupLayout step1Layout = new GroupLayout(this.step1);
        this.step1.setLayout(step1Layout);
        step1Layout.setHorizontalGroup(step1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(step1Layout.createSequentialGroup().addContainerGap().addGroup(step1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 376, Short.MAX_VALUE).addGroup(step1Layout.createSequentialGroup().addComponent(this.lblListName).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.listName, -1, 336, Short.MAX_VALUE)).addComponent(this.lblNavi).addComponent(this.goNext, GroupLayout.Alignment.TRAILING)).addContainerGap()));
        step1Layout.setVerticalGroup(step1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(step1Layout.createSequentialGroup().addContainerGap().addGroup(step1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblListName).addComponent(this.listName, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.lblNavi).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -2, 192, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 11, Short.MAX_VALUE).addComponent(this.goNext).addContainerGap()));
        this.getContentPane().add((Component)this.step1, "card2");
        this.jLabel2.setFont(new Font("MS UI Gothic", 1, 12));
        this.jLabel2.setText("\u5358\u8a9e\u306e\u7de8\u96c6");
        this.jLabel1.setText("\u5358\u8a9e\u540d");
        this.jLabel3.setText("\u54c1\u8a5e");
        this.jLabel4.setText("\u82f1\u548c\u8f9e\u5178\u306e\u691c\u7d22\u7d50\u679c");
        this.japanese.setEditable(true);
        this.japanese.setModel(new DictionaryComboBoxModel(DictionaryService.getDictionaryservice().getEnglishToJapanese()));
        this.jLabel5.setText("\u82f1\u82f1\u8f9e\u5178\u306e\u691c\u7d22\u7d50\u679c");
        this.english.setEditable(true);
        this.english.setModel(new DictionaryComboBoxModel(DictionaryService.getDictionaryservice().getEnglishToEnglish()));
        this.jLabel6.setText("\u4f8b\u6587\u6642\u70b9\u306e\u691c\u7d22\u7d50\u679c");
        this.example.setEditable(true);
        this.example.setModel(new DictionaryComboBoxModel(DictionaryService.getDictionaryservice().getSentences()));
        this.gonext.setText("\u6b21\u3078");
        this.gonext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MakeListDialog.this.gonextActionPerformed(evt);
            }
        });
        GroupLayout stepWordsLayout = new GroupLayout(this.stepWords);
        this.stepWords.setLayout(stepWordsLayout);
        stepWordsLayout.setHorizontalGroup(stepWordsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(stepWordsLayout.createSequentialGroup().addContainerGap().addGroup(stepWordsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.japanese, 0, 376, Short.MAX_VALUE).addComponent(this.jLabel2, -1, 376, Short.MAX_VALUE).addGroup(stepWordsLayout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.word, -1, 335, Short.MAX_VALUE)).addGroup(stepWordsLayout.createSequentialGroup().addComponent(this.jLabel3).addGap(18, 18, 18).addComponent(this.pos, -1, 334, Short.MAX_VALUE)).addComponent(this.jLabel4).addComponent(this.jLabel5).addComponent(this.english, 0, 376, Short.MAX_VALUE).addComponent(this.jLabel6).addComponent(this.example, 0, 376, Short.MAX_VALUE).addComponent(this.gonext, GroupLayout.Alignment.TRAILING)).addContainerGap()));
        stepWordsLayout.setVerticalGroup(stepWordsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(stepWordsLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(stepWordsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.word, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(stepWordsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.pos, -2, -1, -2).addComponent(this.jLabel3)).addGap(18, 18, 18).addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.japanese, -2, -1, -2).addGap(18, 18, 18).addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.english, -2, -1, -2).addGap(18, 18, 18).addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.example, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 24, Short.MAX_VALUE).addComponent(this.gonext).addContainerGap()));
        this.getContentPane().add((Component)this.stepWords, "card3");
        this.jLabel7.setText("\u30ea\u30b9\u30c8\u306e\u767b\u9332\u304c\u5b8c\u4e86\u3057\u307e\u3057\u305f");
        this.registeredListName.setText("\u30ea\u30b9\u30c8\u540d");
        this.registeredWordCount.setText("\u5358\u8a9e\u6570");
        this.jToggleButton1.setText("OK");
        this.jToggleButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MakeListDialog.this.jToggleButton1ActionPerformed(evt);
            }
        });
        GroupLayout endLayout = new GroupLayout(this.end);
        this.end.setLayout(endLayout);
        endLayout.setHorizontalGroup(endLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(endLayout.createSequentialGroup().addContainerGap().addGroup(endLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel7).addComponent(this.registeredWordCount).addComponent(this.registeredListName)).addContainerGap(262, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, endLayout.createSequentialGroup().addContainerGap(339, Short.MAX_VALUE).addComponent(this.jToggleButton1).addContainerGap()));
        endLayout.setVerticalGroup(endLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(endLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabel7).addGap(18, 18, 18).addComponent(this.registeredListName).addGap(18, 18, 18).addComponent(this.registeredWordCount).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 184, Short.MAX_VALUE).addComponent(this.jToggleButton1).addContainerGap()));
        this.getContentPane().add((Component)this.end, "card4");
        this.pack();
    }

    private void goNextActionPerformed(ActionEvent evt) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MakeListDialog.this.context.setName(MakeListDialog.this.listName.getText());
                MakeListDialog.this.context.setWords(MakeListDialog.this.words.getText());
                MakeListDialog.this.initializeStep2(MakeListDialog.this.context.nextWord());
                ((CardLayout)MakeListDialog.this.getContentPane().getLayout()).next(MakeListDialog.this.getContentPane());
                MakeListDialog.this.pos.grabFocus();
            }
        });
    }

    private void gonextActionPerformed(ActionEvent evt) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                String _word = MakeListDialog.this.word.getText() == null ? "" : MakeListDialog.this.word.getText();
                String _pos = MakeListDialog.this.pos.getText() == null ? "" : MakeListDialog.this.pos.getText();
                String _japanese = MakeListDialog.this.japanese.getSelectedItem() == null ? "" : MakeListDialog.this.japanese.getSelectedItem().toString();
                String _english = MakeListDialog.this.english.getSelectedItem() == null ? "" : MakeListDialog.this.english.getSelectedItem().toString();
                String _example = MakeListDialog.this.example.getSelectedItem() == null ? "" : MakeListDialog.this.example.getSelectedItem().toString();
                MakeListDialog.this.context.addNewWordCard(_word, _pos, _japanese, _english, _example);
                if (MakeListDialog.this.context.hasMoreWords()) {
                    MakeListDialog.this.initializeStep2(MakeListDialog.this.context.nextWord());
                } else {
                    WordList list = MakeListDialog.this.storeWordList(MakeListDialog.this.context);
                    ((VocabularFrame)MakeListDialog.this.getParent()).addANewLeaf(list);
                    ((VocabularFrame)MakeListDialog.this.getParent()).initializePositions();
                    ((CardLayout)MakeListDialog.this.getContentPane().getLayout()).next(MakeListDialog.this.getContentPane());
                    MakeListDialog.this.registeredListName.setText("\u30ea\u30b9\u30c8\u540d\uff1a" + MakeListDialog.this.context.getName());
                    MakeListDialog.this.registeredWordCount.setText("\u5358\u8a9e\u6570\uff1a" + MakeListDialog.this.context.getWordCards().size());
                }
            }
        });
    }

    private WordList storeWordList(final WordListContext context) {
        final WordList list = new WordList();
        list.setName(context.getName());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DBService service = DBService.getDBService();
                service.persistWordList(list, context.getWordCards());
            }
        });
        return list;
    }

    private void initializeStep2(final String nextWord) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    MakeListDialog.this.word.setText(nextWord);
                    MakeListDialog.this.pos.grabFocus();
                    ((DictionaryComboBoxModel)MakeListDialog.this.japanese.getModel()).update(nextWord);
                    ((DictionaryComboBoxModel)MakeListDialog.this.english.getModel()).update(nextWord);
                    ((DictionaryComboBoxModel)MakeListDialog.this.example.getModel()).update(nextWord);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
    }

    private void jToggleButton1ActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void listNameFocusLost(FocusEvent evt) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MakeListDialog.this.goNext.setEnabled(MakeListDialog.this.validateStep1());
            }
        });
    }

    private void wordsFocusLost(FocusEvent evt) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MakeListDialog.this.goNext.setEnabled(MakeListDialog.this.validateStep1());
            }
        });
    }

    private void wordsKeyReleased(KeyEvent evt) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MakeListDialog.this.goNext.setEnabled(MakeListDialog.this.validateStep1());
            }
        });
    }

    private void listNameKeyReleased(KeyEvent evt) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MakeListDialog.this.goNext.setEnabled(MakeListDialog.this.validateStep1());
            }
        });
    }

    private boolean validateStep1() {
        return this.listName.getText() != null && this.listName.getText().length() > 0 && this.words.getText() != null && this.words.getText().length() > 0;
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                MakeListDialog dialog = new MakeListDialog((Frame)new JFrame(), true);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

