/*
 * Decompiled with CFR 0.152.
 */
package org.tonouchi.vocabulardictionary.wordnet;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import net.didion.jwnl.JWNL;
import net.didion.jwnl.data.IndexWord;
import net.didion.jwnl.data.IndexWordSet;
import net.didion.jwnl.data.Synset;
import net.didion.jwnl.dictionary.Dictionary;
import org.tonouchi.vocabularconfig.Config;
import org.tonouchi.vocabulardictionary.DictionaryWrapper;
import org.tonouchi.vocabulardictionary.Result;

public class WordNet
implements DictionaryWrapper {
    @Override
    public void initialize(Config config) {
        try {
            if (!JWNL.isInitialized()) {
                JWNL.initialize((InputStream)new FileInputStream(config.getWordNetSettingPath()));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public List<Result> lookup(String word) {
        ArrayList<Result> results = new ArrayList<Result>();
        try {
            Dictionary dictionary = Dictionary.getInstance();
            IndexWordSet indexWordSet = dictionary.lookupAllIndexWords(word);
            for (IndexWord indexWord : indexWordSet.getIndexWordArray()) {
                String lemma = indexWord.getLemma();
                String pos = indexWord.getPOS().getLabel();
                for (Synset synset : indexWord.getSenses()) {
                    Result result = new Result();
                    result.setWord(lemma);
                    result.setCategory(pos);
                    String gloss = synset.getGloss();
                    if (gloss.indexOf(";") >= 0) {
                        result.setDefinition(synset.getGloss().substring(0, synset.getGloss().indexOf(";")));
                    } else {
                        result.setDefinition(gloss);
                    }
                    results.add(result);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return results;
    }

    @Override
    public void close() {
        if (JWNL.isInitialized()) {
            JWNL.shutdown();
        }
    }
}

