/*
 * Decompiled with CFR 0.152.
 */
package org.tonouchi.vocabulardictionary.onelinepdic;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.tonouchi.vocabularconfig.Config;
import org.tonouchi.vocabulardictionary.DictionaryWrapper;
import org.tonouchi.vocabulardictionary.Result;

public class OnelinePDicWrapper
implements DictionaryWrapper {
    private File pdicFile = null;

    @Override
    public void initialize(Config config) {
        this.pdicFile = new File(config.getPathToPdic());
    }

    @Override
    public void close() {
        this.pdicFile = null;
    }

    @Override
    public List<Result> lookup(String word) {
        ArrayList<Result> resultList = new ArrayList<Result>();
        try {
            String str;
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(this.pdicFile));
            LineNumberReader lnr = new LineNumberReader(new InputStreamReader((InputStream)bis, "UTF-8"));
            ArrayList<String> hitLine = new ArrayList<String>();
            while ((str = lnr.readLine()) != null) {
                if (str.startsWith(word)) {
                    hitLine.add(str);
                }
                if (hitLine.size() != 10) continue;
            }
            lnr.close();
            for (String line : hitLine) {
                resultList.add(this.toResult(line));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return resultList;
    }

    private Result toResult(String str) {
        Result result = new Result();
        result.setWord(str.substring(0, str.indexOf(" /// ")));
        String meanings = null;
        meanings = str.indexOf(" / ") != -1 ? str.substring(str.indexOf(" /// ") + " /// ".length(), str.indexOf(" / ")) : str.substring(str.indexOf(" /// ") + " /// ".length());
        StringTokenizer meaningsTokens = new StringTokenizer(meanings, " \\ ");
        result.setDefinition(meaningsTokens.nextToken());
        String examples = str.substring(str.indexOf(" / ") + " / ".length());
        return result;
    }
}

