/*
 * Decompiled with CFR 0.152.
 */
package org.tonouchi.vocabulardictionary.smartfm.items;

import java.util.Stack;
import javax.xml.stream.EventFilter;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class SmartFmFilter
implements EventFilter {
    private Stack<XMLEvent> eventStack;

    public SmartFmFilter(Stack<XMLEvent> eventStack) {
        this.eventStack = eventStack;
    }

    @Override
    public boolean accept(XMLEvent event) {
        if (event.isStartElement()) {
            return this.isAcceptableTag(event.asStartElement());
        }
        if (event.isEndElement()) {
            return this.isAcceptableTag(event.asEndElement());
        }
        return event.isCharacters();
    }

    private boolean isAcceptableTag(StartElement element) {
        return this.isAcceptableTag(element.getName().getLocalPart());
    }

    private boolean isAcceptableTag(EndElement element) {
        return this.isAcceptableTag(element.getName().getLocalPart());
    }

    private boolean isAcceptableTag(String tagName) {
        if (tagName.equals("items")) {
            return true;
        }
        if (tagName.equals("item")) {
            return true;
        }
        if (tagName.equals("cue")) {
            return true;
        }
        if (tagName.equals("text")) {
            return true;
        }
        if (tagName.equals("responses")) {
            return true;
        }
        return tagName.equals("response");
    }
}

