/*
 * Decompiled with CFR 0.152.
 */
package net.didion.jwnl.data.relationship;

import java.util.List;
import net.didion.jwnl.JWNLException;
import net.didion.jwnl.data.IndexWord;
import net.didion.jwnl.data.PointerType;
import net.didion.jwnl.data.PointerUtils;
import net.didion.jwnl.data.Synset;
import net.didion.jwnl.data.list.PointerTargetNode;
import net.didion.jwnl.data.list.PointerTargetNodeList;
import net.didion.jwnl.data.list.PointerTargetTree;
import net.didion.jwnl.data.list.PointerTargetTreeNode;
import net.didion.jwnl.data.list.PointerTargetTreeNodeList;
import net.didion.jwnl.data.relationship.AsymmetricRelationship;
import net.didion.jwnl.data.relationship.Relationship;
import net.didion.jwnl.data.relationship.RelationshipList;
import net.didion.jwnl.data.relationship.SymmetricRelationship;

public class RelationshipFinder {
    private static final int DEFAULT_ASYMMETRIC_SEARCH_DEPTH = Integer.MAX_VALUE;
    private static final int DEFAULT_SYMMETRIC_SEARCH_DEPTH = 2;
    private static final RelationshipFinder INSTANCE = new RelationshipFinder();

    public static RelationshipFinder getInstance() {
        return INSTANCE;
    }

    private RelationshipFinder() {
    }

    public int getImmediateRelationship(IndexWord sourceWord, IndexWord targetWord) throws JWNLException {
        Synset[] senses = sourceWord.getSenses();
        String lemma = targetWord.getLemma();
        int i = 0;
        while (i < senses.length) {
            if (senses[i].containsWord(lemma)) {
                return i + 1;
            }
            ++i;
        }
        return -1;
    }

    public RelationshipList findRelationships(Synset sourceSynset, Synset targetSynset, PointerType type) throws JWNLException {
        return type.isSymmetric() ? this.findSymmetricRelationships(sourceSynset, targetSynset, type) : this.findAsymmetricRelationships(sourceSynset, targetSynset, type);
    }

    public RelationshipList findRelationships(Synset sourceSynset, Synset targetSynset, PointerType type, int depth) throws JWNLException {
        return type.isSymmetric() ? this.findSymmetricRelationships(sourceSynset, targetSynset, type, depth) : this.findAsymmetricRelationships(sourceSynset, targetSynset, type, depth);
    }

    private RelationshipList findAsymmetricRelationships(Synset sourceSynset, Synset targetSynset, PointerType type) throws JWNLException {
        return this.findAsymmetricRelationships(sourceSynset, targetSynset, type, Integer.MAX_VALUE);
    }

    private RelationshipList findAsymmetricRelationships(Synset sourceSynset, Synset targetSynset, PointerType type, int depth) throws JWNLException {
        PointerTargetNodeList[] sourceRelations = new PointerTargetTree(sourceSynset, PointerUtils.getInstance().makePointerTargetTreeList(sourceSynset, type, depth)).reverse();
        PointerTargetNodeList[] targetRelations = new PointerTargetTree(targetSynset, PointerUtils.getInstance().makePointerTargetTreeList(targetSynset, type, depth)).reverse();
        RelationshipList relationships = new RelationshipList();
        int i = 0;
        while (i < sourceRelations.length) {
            int j = 0;
            while (j < targetRelations.length) {
                Relationship relationship = this.findAsymmetricRelationship(sourceRelations[i], targetRelations[j], type, sourceSynset, targetSynset);
                if (relationship != null) {
                    relationships.add(relationship);
                }
                ++j;
            }
            ++i;
        }
        return relationships;
    }

    private Relationship findAsymmetricRelationship(PointerTargetNodeList sourceNodes, PointerTargetNodeList targetNodes, PointerType type, Synset sourceSynset, Synset targetSynset) {
        if (!sourceNodes.get(0).equals(targetNodes.get(0))) {
            return null;
        }
        PointerTargetNodeList relationship = new PointerTargetNodeList();
        int targetStart = 0;
        int commonParentIndex = 0;
        int i = sourceNodes.size() - 1;
        while (i >= 0) {
            PointerTargetNode testNode = (PointerTargetNode)sourceNodes.get(i);
            int idx = targetNodes.indexOf(testNode);
            if (idx >= 0) {
                targetStart = idx;
                break;
            }
            relationship.add(testNode.clone());
            ++commonParentIndex;
            --i;
        }
        i = targetStart;
        while (i < targetNodes.size()) {
            PointerTargetNode node = (PointerTargetNode)((PointerTargetNode)targetNodes.get(i)).clone();
            node.setType(type.getSymmetricType());
            relationship.add(node);
            ++i;
        }
        return new AsymmetricRelationship(type, relationship, commonParentIndex, sourceSynset, targetSynset);
    }

    private RelationshipList findSymmetricRelationships(Synset sourceSynset, Synset targetSynset, PointerType type) throws JWNLException {
        return this.findSymmetricRelationships(sourceSynset, targetSynset, type, 2);
    }

    private RelationshipList findSymmetricRelationships(Synset sourceSynset, final Synset targetSynset, PointerType type, int depth) throws JWNLException {
        PointerTargetTree tree = new PointerTargetTree(sourceSynset, PointerUtils.getInstance().makePointerTargetTreeList(sourceSynset, type, null, depth, false));
        PointerTargetTreeNodeList.Operation opr = new PointerTargetTreeNodeList.Operation(){

            public Object execute(PointerTargetTreeNode testNode) {
                if (targetSynset.equals(testNode.getSynset())) {
                    return testNode;
                }
                return null;
            }
        };
        List l = tree.getAllMatches(opr);
        RelationshipList list = new RelationshipList();
        int i = 0;
        while (i < l.size()) {
            PointerTargetNodeList nodes = this.findSymmetricRelationship((PointerTargetTreeNode)l.get(i), type);
            list.add(new SymmetricRelationship(type, nodes, sourceSynset, targetSynset));
            ++i;
        }
        return list;
    }

    private PointerTargetNodeList findSymmetricRelationship(PointerTargetTreeNode node, PointerType type) {
        PointerTargetNodeList list = new PointerTargetNodeList();
        this.buildSymmetricRelationshipList(list, node);
        list = list.reverse();
        ((PointerTargetNode)list.get(0)).setType(type);
        return list;
    }

    private void buildSymmetricRelationshipList(PointerTargetNodeList list, PointerTargetTreeNode node) {
        list.add(node.getPointerTarget(), node.getType());
        if (node.getParent() != null) {
            this.buildSymmetricRelationshipList(list, node.getParent());
        }
    }
}

