/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import java.sql.SQLException;
import org.h2.constant.SysProperties;
import org.h2.engine.Session;
import org.h2.index.Cursor;
import org.h2.index.IndexType;
import org.h2.index.PageBtree;
import org.h2.index.PageBtreeCursor;
import org.h2.index.PageBtreeLeaf;
import org.h2.index.PageBtreeNode;
import org.h2.index.PageIndex;
import org.h2.message.Message;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.store.Data;
import org.h2.store.PageStore;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.TableData;
import org.h2.value.Value;
import org.h2.value.ValueLob;
import org.h2.value.ValueNull;

public class PageBtreeIndex
extends PageIndex {
    private PageStore store;
    private TableData tableData;
    private boolean needRebuild;
    private long rowCount;

    public PageBtreeIndex(TableData tableData, int n, String string, IndexColumn[] indexColumnArray, IndexType indexType, int n2, Session session) throws SQLException {
        this.initBaseIndex(tableData, n, string, indexColumnArray, indexType);
        this.tableData = tableData;
        if (!this.database.isPersistent() || n < 0) {
            throw Message.throwInternalError("" + string);
        }
        this.store = this.database.getPageStore();
        this.store.addIndex(this);
        if (n2 == -1) {
            this.rootPageId = this.store.allocatePage();
            this.needRebuild = true;
            this.store.addMeta(this, session);
            PageBtreeLeaf pageBtreeLeaf = PageBtreeLeaf.create(this, this.rootPageId, 0);
            this.store.logUndo(pageBtreeLeaf, null);
            this.store.update(pageBtreeLeaf);
        } else {
            this.rootPageId = this.store.getRootPageId(n);
            PageBtree pageBtree = this.getPage(this.rootPageId);
            this.rowCount = pageBtree.getRowCount();
            if (this.rowCount == 0L && this.store.isRecoveryRunning()) {
                this.needRebuild = true;
            }
        }
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("opened " + this.getName() + " rows:" + this.rowCount);
        }
    }

    public void add(Session session, Row row) throws SQLException {
        PageBtree pageBtree;
        int n;
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("add " + row.getKey());
        }
        SearchRow searchRow = this.getSearchRow(row);
        while ((n = (pageBtree = this.getPage(this.rootPageId)).addRowTry(searchRow)) != -1) {
            if (this.trace.isDebugEnabled()) {
                this.trace.debug("split " + n);
            }
            SearchRow searchRow2 = pageBtree.getRow(n - 1);
            this.store.logUndo(pageBtree, pageBtree.data);
            PageBtree pageBtree2 = pageBtree;
            PageBtree pageBtree3 = pageBtree.split(n);
            this.store.logUndo(pageBtree3, null);
            int n2 = pageBtree.getPos();
            int n3 = this.store.allocatePage();
            pageBtree2.setPageId(n3);
            pageBtree2.setParentPageId(n2);
            pageBtree3.setParentPageId(n2);
            PageBtreeNode pageBtreeNode = PageBtreeNode.create(this, n2, 0);
            this.store.logUndo(pageBtreeNode, null);
            pageBtreeNode.init(pageBtree2, searchRow2, pageBtree3);
            this.store.update(pageBtree2);
            this.store.update(pageBtree3);
            this.store.update(pageBtreeNode);
            pageBtree = pageBtreeNode;
        }
        ++this.rowCount;
    }

    private SearchRow getSearchRow(Row row) {
        SearchRow searchRow = this.table.getTemplateSimpleRow(this.columns.length == 1);
        searchRow.setKeyAndVersion(row);
        for (int i = 0; i < this.columns.length; ++i) {
            int n = this.columns[i].getColumnId();
            searchRow.setValue(n, row.getValue(n));
        }
        return searchRow;
    }

    PageBtree getPage(int n) throws SQLException {
        PageBtree pageBtree = (PageBtree)this.store.getPage(n);
        if (pageBtree == null) {
            PageBtreeLeaf pageBtreeLeaf = PageBtreeLeaf.create(this, n, 0);
            this.store.logUndo(pageBtreeLeaf, null);
            this.store.update(pageBtreeLeaf);
            return pageBtreeLeaf;
        }
        return pageBtree;
    }

    public boolean canGetFirstOrLast() {
        return true;
    }

    public Cursor findNext(Session session, SearchRow searchRow, SearchRow searchRow2) throws SQLException {
        return this.find(session, searchRow, true, searchRow2);
    }

    public Cursor find(Session session, SearchRow searchRow, SearchRow searchRow2) throws SQLException {
        return this.find(session, searchRow, false, searchRow2);
    }

    private Cursor find(Session session, SearchRow searchRow, boolean bl, SearchRow searchRow2) throws SQLException {
        if (SysProperties.CHECK && this.store == null) {
            throw Message.getSQLException(90007);
        }
        PageBtree pageBtree = this.getPage(this.rootPageId);
        PageBtreeCursor pageBtreeCursor = new PageBtreeCursor(session, this, searchRow2);
        pageBtree.find(pageBtreeCursor, searchRow, bl);
        return pageBtreeCursor;
    }

    public Cursor findFirstOrLast(Session session, boolean bl) throws SQLException {
        SearchRow searchRow;
        if (bl) {
            Cursor cursor = this.find(session, null, false, null);
            while (cursor.next()) {
                SearchRow searchRow2 = cursor.getSearchRow();
                Value value = searchRow2.getValue(this.columnIds[0]);
                if (value == ValueNull.INSTANCE) continue;
                return cursor;
            }
            return cursor;
        }
        PageBtree pageBtree = this.getPage(this.rootPageId);
        PageBtreeCursor pageBtreeCursor = new PageBtreeCursor(session, this, null);
        pageBtree.last(pageBtreeCursor);
        pageBtreeCursor.previous();
        while ((searchRow = pageBtreeCursor.getSearchRow()) != null) {
            Value value = searchRow.getValue(this.columnIds[0]);
            if (value != ValueNull.INSTANCE) {
                return pageBtreeCursor;
            }
            if (pageBtreeCursor.previous()) continue;
        }
        return pageBtreeCursor;
    }

    public double getCost(Session session, int[] nArray) {
        return 10L * this.getCostRangeIndex(nArray, this.tableData.getRowCount(session));
    }

    public boolean needRebuild() {
        return this.needRebuild;
    }

    public void remove(Session session, Row row) throws SQLException {
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("remove " + row.getKey());
        }
        if (this.tableData.getContainsLargeObject()) {
            for (int i = 0; i < row.getColumnCount(); ++i) {
                Value value = row.getValue(i);
                if (!value.isLinked()) continue;
                session.unlinkAtCommit((ValueLob)value);
            }
        }
        if (this.rowCount == 1L) {
            this.removeAllRows();
        } else {
            PageBtree pageBtree = this.getPage(this.rootPageId);
            pageBtree.remove(row);
            --this.rowCount;
        }
    }

    public void remove(Session session) throws SQLException {
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("remove");
        }
        this.removeAllRows();
        this.store.free(this.rootPageId, true);
        this.store.removeMeta(this, session);
    }

    public void truncate(Session session) throws SQLException {
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("truncate");
        }
        this.removeAllRows();
        if (this.tableData.getContainsLargeObject()) {
            ValueLob.removeAllForTable(this.database, this.table.getId());
        }
        this.tableData.setRowCount(0L);
    }

    private void removeAllRows() throws SQLException {
        PageBtree pageBtree = this.getPage(this.rootPageId);
        this.store.logUndo(pageBtree, pageBtree.data);
        pageBtree.freeChildren();
        pageBtree = PageBtreeLeaf.create(this, this.rootPageId, 0);
        this.store.removeRecord(this.rootPageId);
        this.store.update(pageBtree);
        this.rowCount = 0L;
    }

    public void checkRename() {
    }

    Row getRow(Session session, long l) throws SQLException {
        return this.tableData.getRow(session, l);
    }

    PageStore getPageStore() {
        return this.store;
    }

    public long getRowCountApproximation() {
        return this.tableData.getRowCountApproximation();
    }

    public long getRowCount(Session session) {
        return this.tableData.getRowCount(session);
    }

    public void close(Session session) {
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("close");
        }
    }

    SearchRow readRow(Data data, int n, boolean bl) throws SQLException {
        data.setPos(n);
        long l = data.readVarLong();
        if (bl) {
            return this.tableData.getRow(null, l);
        }
        SearchRow searchRow = this.table.getTemplateSimpleRow(this.columns.length == 1);
        searchRow.setKey(l);
        for (Column column : this.columns) {
            int n2 = column.getColumnId();
            searchRow.setValue(n2, data.readValue());
        }
        return searchRow;
    }

    void writeRow(Data data, int n, SearchRow searchRow, boolean bl) throws SQLException {
        data.setPos(n);
        data.writeVarLong(searchRow.getKey());
        if (!bl) {
            for (Column column : this.columns) {
                int n2 = column.getColumnId();
                data.writeValue(searchRow.getValue(n2));
            }
        }
    }

    int getRowSize(Data data, SearchRow searchRow, boolean bl) throws SQLException {
        int n = data.getVarLongLen(searchRow.getKey());
        if (!bl) {
            for (Column column : this.columns) {
                Value value = searchRow.getValue(column.getColumnId());
                n += data.getValueLen(value);
            }
        }
        return n;
    }

    public boolean canFindNext() {
        return true;
    }

    void setRootPageId(Session session, int n) throws SQLException {
        this.store.removeMeta(this, session);
        this.rootPageId = n;
        this.store.addMeta(this, session);
        this.store.addIndex(this);
    }
}

