/*
 * Decompiled with CFR 0.152.
 */
package net.didion.jwnl.utilities;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import net.didion.jwnl.JWNL;
import net.didion.jwnl.JWNLException;
import net.didion.jwnl.data.DictionaryElement;
import net.didion.jwnl.data.POS;
import net.didion.jwnl.dictionary.AbstractCachingDictionary;
import net.didion.jwnl.dictionary.Dictionary;
import net.didion.jwnl.dictionary.file.DictionaryCatalogSet;
import net.didion.jwnl.dictionary.file.DictionaryFileType;
import net.didion.jwnl.dictionary.file.ObjectDictionaryFile;

public class DictionaryToMap {
    private DictionaryCatalogSet _destFiles;
    static /* synthetic */ Class class$0;

    public DictionaryToMap(String destDirectory, String propFile) throws JWNLException, IOException {
        JWNL.initialize(new FileInputStream(propFile));
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("net.didion.jwnl.princeton.file.PrincetonObjectDictionaryFile");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this._destFiles = new DictionaryCatalogSet(destDirectory, clazz);
    }

    public void convert() throws JWNLException, IOException {
        this._destFiles.open();
        boolean canClearCache = Dictionary.getInstance() instanceof AbstractCachingDictionary && ((AbstractCachingDictionary)Dictionary.getInstance()).isCachingEnabled();
        Iterator typeItr = DictionaryFileType.getAllDictionaryFileTypes().iterator();
        while (typeItr.hasNext()) {
            DictionaryFileType fileType = (DictionaryFileType)typeItr.next();
            Iterator posItr = POS.getAllPOS().iterator();
            while (posItr.hasNext()) {
                POS pos = (POS)posItr.next();
                System.out.println("Converting " + pos + " " + fileType + " file...");
                this.serialize(pos, fileType);
            }
            if (canClearCache) {
                ((AbstractCachingDictionary)Dictionary.getInstance()).clearCache(fileType.getElementType());
            }
            System.gc();
        }
        this._destFiles.close();
    }

    private Iterator getIterator(POS pos, DictionaryFileType fileType) throws JWNLException {
        if (fileType == DictionaryFileType.DATA) {
            return Dictionary.getInstance().getSynsetIterator(pos);
        }
        if (fileType == DictionaryFileType.INDEX) {
            return Dictionary.getInstance().getIndexWordIterator(pos);
        }
        if (fileType == DictionaryFileType.EXCEPTION) {
            return Dictionary.getInstance().getExceptionIterator(pos);
        }
        throw new IllegalArgumentException();
    }

    private void serialize(POS pos, DictionaryFileType fileType) throws JWNLException, IOException {
        ObjectDictionaryFile file = (ObjectDictionaryFile)this._destFiles.getDictionaryFile(pos, fileType);
        int count = 0;
        Iterator itr = this.getIterator(pos, fileType);
        while (itr.hasNext()) {
            if (++count % 10000 == 0) {
                System.out.println("Counted and cached word " + count + "...");
            }
            itr.next();
        }
        HashMap<Object, DictionaryElement> map = new HashMap<Object, DictionaryElement>((int)Math.ceil((float)count / 0.9f) + 1, 0.9f);
        Iterator listItr = this.getIterator(pos, fileType);
        while (listItr.hasNext()) {
            DictionaryElement elt = (DictionaryElement)listItr.next();
            map.put(elt.getKey(), elt);
        }
        file.writeObject(map);
        file.close();
        map = null;
        file = null;
        System.gc();
        Runtime rt = Runtime.getRuntime();
        System.out.println("total mem: " + rt.totalMemory() / 1024L + "K free mem: " + rt.freeMemory() / 1024L + "K");
        System.out.println("Successfully serialized...");
    }

    public static void main(String[] args) {
        String destinationDirectory = null;
        String propertyFile = null;
        if (args.length == 2) {
            destinationDirectory = args[0];
            propertyFile = args[1];
        } else {
            System.out.println("java DictionaryToMap <destination directory> <properties file>");
            System.exit(-1);
        }
        try {
            new DictionaryToMap(destinationDirectory, propertyFile).convert();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }
}

