/*
 * Decompiled with CFR 0.152.
 */
package org.tonouchi.vocabulardictionary;

import java.util.ArrayList;
import java.util.List;
import org.tonouchi.vocabularconfig.Config;
import org.tonouchi.vocabulardictionary.DictionaryWrapper;
import org.tonouchi.vocabulardictionary.smartfm.items.SmartFmItem;
import org.tonouchi.vocabulardictionary.smartfm.sentences.SmartFmSentences;
import org.tonouchi.vocabulardictionary.wordnet.WordNet;
import org.tonouchi.vocabulardictionary.wordnet.WordNetExamples;

public class DictionaryService {
    private static DictionaryService instance = new DictionaryService();
    private List<DictionaryWrapper> englishToJapanese = new ArrayList<DictionaryWrapper>();
    private List<DictionaryWrapper> englishToEnglish = new ArrayList<DictionaryWrapper>();
    private List<DictionaryWrapper> sentences = new ArrayList<DictionaryWrapper>();

    public static DictionaryService getDictionaryservice() {
        return instance;
    }

    private DictionaryService() {
        this.englishToJapanese.add(new SmartFmItem());
        this.englishToEnglish.add(new WordNet());
        this.sentences.add(new SmartFmSentences());
        this.sentences.add(new WordNetExamples());
    }

    public void init(Config config) {
        for (DictionaryWrapper wrapper : this.englishToJapanese) {
            wrapper.initialize(config);
        }
        for (DictionaryWrapper wrapper : this.englishToEnglish) {
            wrapper.initialize(config);
        }
        for (DictionaryWrapper wrapper : this.sentences) {
            wrapper.initialize(config);
        }
    }

    public List<DictionaryWrapper> getEnglishToJapanese() {
        return this.englishToJapanese;
    }

    public List<DictionaryWrapper> getEnglishToEnglish() {
        return this.englishToEnglish;
    }

    public List<DictionaryWrapper> getSentences() {
        return this.sentences;
    }
}

