/*
 * Decompiled with CFR 0.152.
 */
package org.tonouchi.vocable.gui;

import java.awt.Color;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import org.tonouchi.vocable.gui.DictionaryComboBoxModel;
import org.tonouchi.vocable.gui.models.VocabularListModel;
import org.tonouchi.vocable.gui.models.VocabularTableModel;
import org.tonouchi.vocable.gui.models.VocabularomComboModel;
import org.tonouchi.vocabulardb.DBService;
import org.tonouchi.vocabulardb.WordCard;
import org.tonouchi.vocabulardb.WordList;
import org.tonouchi.vocabulardictionary.DictionaryService;
import org.tonouchi.vocabularpublisher.PDFExporter;
import org.tonouchi.vocabularpublisher.XMLExporter;
import org.tonouchi.vocabularpublisher.XMLImporter;

public class VocabularFrame
extends JFrame {
    private static final long serialVersionUID = -1L;
    private JComboBox english;
    private JComboBox example;
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButton3;
    private JButton jButton4;
    private JComboBox jComboBox1;
    private JComboBox jComboBox2;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JList jList1;
    private JMenu jMenu1;
    private JMenu jMenu2;
    private JMenuBar jMenuBar1;
    private JMenuItem jMenuItem1;
    private JMenuItem jMenuItem2;
    private JMenuItem jMenuItem3;
    private JMenuItem jMenuItem4;
    private JMenuItem jMenuItem5;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane4;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JTabbedPane jTabbedPane1;
    private JTable jTable1;
    private JTextArea jTextArea1;
    private JComboBox japanese;
    private JTextField pos;
    private JTextField word;

    public VocabularFrame() {
        this.initComponents();
        this.jTable1.setSelectionMode(2);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel1 = new JPanel();
        this.jButton1 = new JButton();
        this.japanese = new JComboBox();
        this.english = new JComboBox();
        this.example = new JComboBox();
        this.word = new JTextField();
        this.pos = new JTextField();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jPanel3 = new JPanel();
        this.jScrollPane3 = new JScrollPane();
        this.jTextArea1 = new JTextArea();
        this.jButton2 = new JButton();
        this.jPanel2 = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.jTable1 = new JTable();
        this.jComboBox1 = new JComboBox();
        this.jButton4 = new JButton();
        this.jPanel4 = new JPanel();
        this.jComboBox2 = new JComboBox();
        this.jScrollPane4 = new JScrollPane();
        this.jList1 = new JList();
        this.jButton3 = new JButton();
        this.jMenuBar1 = new JMenuBar();
        this.jMenu2 = new JMenu();
        this.jMenuItem1 = new JMenuItem();
        this.jSeparator1 = new JSeparator();
        this.jMenuItem2 = new JMenuItem();
        this.jMenuItem3 = new JMenuItem();
        this.jSeparator2 = new JSeparator();
        this.jMenuItem4 = new JMenuItem();
        this.jMenu1 = new JMenu();
        this.jMenuItem5 = new JMenuItem();
        this.setDefaultCloseOperation(3);
        this.jPanel1.setBackground(new Color(255, 255, 255));
        this.jButton1.setText("\u4fdd\u5b58\uff01");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VocabularFrame.this.jButton1ActionPerformed(evt);
            }
        });
        this.japanese.setModel(new DictionaryComboBoxModel(DictionaryService.getDictionaryservice().getEnglishToJapanese()));
        this.japanese.setBorder(null);
        this.english.setModel(new DictionaryComboBoxModel(DictionaryService.getDictionaryservice().getEnglishToEnglish()));
        this.example.setModel(new DictionaryComboBoxModel(DictionaryService.getDictionaryservice().getSentences()));
        this.word.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                VocabularFrame.this.wordFocusLost(evt);
            }
        });
        this.jLabel1.setText("\u5358\u8a9e");
        this.jLabel2.setText("\u54c1\u8a5e");
        this.jLabel3.setText("\u65e5\u672c\u8a9e");
        this.jLabel4.setText("\u82f1\u8a9e");
        this.jLabel5.setText("\u4f8b\u6587");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.LEADING, jPanel1Layout.createSequentialGroup().addComponent(this.jLabel5).addGap(18, 18, 18).addComponent(this.example, 0, 648, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.LEADING, jPanel1Layout.createSequentialGroup().addComponent(this.jLabel4).addGap(18, 18, 18).addComponent(this.english, 0, 648, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.LEADING, jPanel1Layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.japanese, 0, 649, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.LEADING, jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.jLabel2)).addGap(17, 17, 17).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.word, -1, 649, Short.MAX_VALUE).addComponent(this.pos, -1, 649, Short.MAX_VALUE)))).addContainerGap()).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap(633, Short.MAX_VALUE).addComponent(this.jButton1).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.word, -2, -1, -2).addComponent(this.jLabel1)).addGap(18, 18, 18).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.pos, -2, -1, -2).addComponent(this.jLabel2)).addGap(18, 18, 18).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.japanese, -2, -1, -2).addComponent(this.jLabel3)).addGap(18, 18, 18).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.english, -2, -1, -2)).addGap(18, 18, 18).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.example, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButton1).addContainerGap(164, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab("\u5358\u8a9e\u767b\u9332(\u500b\u5225\uff09", this.jPanel1);
        this.jTextArea1.setColumns(20);
        this.jTextArea1.setRows(5);
        this.jTextArea1.setBorder(BorderFactory.createTitledBorder("\u300c;\u300d\u3067\u30dc\u30ad\u30e3\u30d6\u30e9\u30ea\u3092\u533a\u5207\u3063\u3066\u4e00\u62ec\u767b\u9332"));
        this.jScrollPane3.setViewportView(this.jTextArea1);
        this.jButton2.setText("\u767b\u9332");
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VocabularFrame.this.jButton2ActionPerformed(evt);
            }
        });
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane3, -1, 690, Short.MAX_VALUE).addComponent(this.jButton2)).addContainerGap()));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane3, -2, 311, -2).addGap(18, 18, 18).addComponent(this.jButton2).addContainerGap()));
        this.jTabbedPane1.addTab("\u4e00\u62ec\u767b\u9332", this.jPanel3);
        this.jTable1.setModel(new VocabularTableModel());
        this.jTable1.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                VocabularFrame.this.jTable1KeyReleased(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.jTable1);
        this.jComboBox1.setModel(new VocabularomComboModel());
        this.jButton4.setText("\u9078\u629e\u3057\u305f\u5358\u8a9e\u3092\u30ea\u30b9\u30c8\u306b\u8ffd\u52a0");
        this.jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VocabularFrame.this.jButton4ActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButton4).addComponent(this.jScrollPane2, -1, 714, Short.MAX_VALUE).addComponent(this.jComboBox1, 0, 714, Short.MAX_VALUE));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jScrollPane2, -2, 267, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBox1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton4)));
        this.jTabbedPane1.addTab("\u5358\u8a9e\u4e00\u89a7", this.jPanel2);
        this.jComboBox2.setModel(new VocabularomComboModel());
        this.jComboBox2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VocabularFrame.this.jComboBox2ActionPerformed(evt);
            }
        });
        this.jList1.setModel(new VocabularListModel());
        this.jScrollPane4.setViewportView(this.jList1);
        this.jButton3.setText("\u3053\u306e\u30ea\u30b9\u30c8\u3092PDF\u306b\u51fa\u529b");
        this.jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VocabularFrame.this.jButton3ActionPerformed(evt);
            }
        });
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jComboBox2, 0, 714, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, jPanel4Layout.createSequentialGroup().addContainerGap().addComponent(this.jButton3)).addComponent(this.jScrollPane4, -1, 714, Short.MAX_VALUE));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addComponent(this.jComboBox2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane4, -2, 296, -2).addGap(18, 18, 18).addComponent(this.jButton3).addContainerGap()));
        this.jTabbedPane1.addTab("\u30ea\u30b9\u30c8", this.jPanel4);
        this.jScrollPane1.setViewportView(this.jTabbedPane1);
        this.jMenu2.setText("\u30d5\u30a1\u30a4\u30eb");
        this.jMenu2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VocabularFrame.this.jMenu2ActionPerformed(evt);
            }
        });
        this.jMenuItem1.setText("PDF\u306b\u30a8\u30af\u30b9\u30dd\u30fc\u30c8");
        this.jMenuItem1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VocabularFrame.this.jMenuItem1ActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.jMenuItem1);
        this.jMenu2.add(this.jSeparator1);
        this.jMenuItem2.setText("XML\u306b\u30a8\u30af\u30b9\u30dd\u30fc\u30c8");
        this.jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VocabularFrame.this.jMenuItem2ActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.jMenuItem2);
        this.jMenuItem3.setText("XML\u304b\u3089\u30a4\u30f3\u30dd\u30fc\u30c8");
        this.jMenuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VocabularFrame.this.jMenuItem3ActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.jMenuItem3);
        this.jMenu2.add(this.jSeparator2);
        this.jMenuItem4.setText("\u7d42\u4e86");
        this.jMenuItem4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VocabularFrame.this.jMenuItem4ActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.jMenuItem4);
        this.jMenuBar1.add(this.jMenu2);
        this.jMenu1.setText("\u30ea\u30b9\u30c8");
        this.jMenu1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VocabularFrame.this.jMenu1ActionPerformed(evt);
            }
        });
        this.jMenuItem5.setText("\u30ea\u30b9\u30c8\u306e\u4f5c\u6210");
        this.jMenuItem5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VocabularFrame.this.jMenuItem5ActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.jMenuItem5);
        this.jMenuBar1.add(this.jMenu1);
        this.setJMenuBar(this.jMenuBar1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 721, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 399, Short.MAX_VALUE));
        this.pack();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                WordCard card = new WordCard();
                card.setWord(VocabularFrame.this.word.getText());
                card.setPos(VocabularFrame.this.pos.getText());
                if (VocabularFrame.this.japanese.getSelectedItem() != null) {
                    card.setJapanese(VocabularFrame.this.japanese.getSelectedItem().toString());
                } else {
                    card.setJapanese("");
                }
                if (VocabularFrame.this.english.getSelectedItem() != null) {
                    card.setEnglish(VocabularFrame.this.english.getSelectedItem().toString());
                } else {
                    card.setEnglish("");
                }
                if (VocabularFrame.this.example.getSelectedItem() != null) {
                    card.setExample(VocabularFrame.this.example.getSelectedItem().toString());
                } else {
                    card.setExample("");
                }
                DBService.getDBService().saveACard(card);
                ((VocabularTableModel)VocabularFrame.this.jTable1.getModel()).updateTableData();
                VocabularFrame.this.word.setText("");
                VocabularFrame.this.pos.setText("");
                VocabularFrame.this.japanese.removeAllItems();
                VocabularFrame.this.english.removeAllItems();
                VocabularFrame.this.example.removeAllItems();
                VocabularFrame.this.word.grabFocus();
            }
        });
    }

    private void jMenuItem1ActionPerformed(ActionEvent evt) {
        final VocabularFrame thisFrame = this;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFileChooser chooser = new JFileChooser();
                switch (chooser.showSaveDialog(thisFrame)) {
                    case 0: {
                        File file = chooser.getSelectedFile();
                        new PDFExporter().export(file, DBService.getDBService().getCards());
                    }
                }
            }
        });
    }

    private void jMenuItem2ActionPerformed(ActionEvent evt) {
        final VocabularFrame thisFrame = this;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFileChooser chooser = new JFileChooser();
                switch (chooser.showSaveDialog(thisFrame)) {
                    case 0: {
                        File file = chooser.getSelectedFile();
                        new XMLExporter().export(file, DBService.getDBService().getCards());
                    }
                }
            }
        });
    }

    private void jMenuItem3ActionPerformed(ActionEvent evt) {
        final VocabularFrame thisFrame = this;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFileChooser chooser = new JFileChooser();
                switch (chooser.showOpenDialog(thisFrame)) {
                    case 0: {
                        File file = chooser.getSelectedFile();
                        List imported = new XMLImporter().importXML(file);
                        DBService.getDBService().batchSave(imported);
                        ((VocabularTableModel)VocabularFrame.this.jTable1.getModel()).updateTableData();
                    }
                }
            }
        });
    }

    private void jMenu2ActionPerformed(ActionEvent evt) {
    }

    private void jMenuItem4ActionPerformed(ActionEvent evt) {
        final VocabularFrame thisFrame = this;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                thisFrame.dispose();
            }
        });
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        final String words = this.jTextArea1.getText().replaceAll(System.getProperty("line.separator"), ";");
        this.jTextArea1.setText("");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                StringTokenizer tkn = new StringTokenizer(words, ";");
                ArrayList<WordCard> cards = new ArrayList<WordCard>();
                while (tkn.hasMoreElements()) {
                    WordCard card = new WordCard();
                    card.setWord(tkn.nextToken());
                    card.setPos("");
                    card.setJapanese("");
                    card.setEnglish("");
                    card.setExample("");
                    cards.add(card);
                }
                DBService.getDBService().batchSave(cards);
                ((VocabularTableModel)VocabularFrame.this.jTable1.getModel()).updateTableData();
            }
        });
    }

    private void jTable1KeyReleased(KeyEvent evt) {
        int keyCode = evt.getKeyCode();
        switch (keyCode) {
            case 155: {
                ((VocabularTableModel)this.jTable1.getModel()).addRow(new Object[0]);
            }
        }
    }

    private void jMenu1ActionPerformed(ActionEvent evt) {
    }

    private void jMenuItem5ActionPerformed(ActionEvent evt) {
        final VocabularFrame thisFrame = this;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                String name = JOptionPane.showInputDialog(thisFrame, (Object)"\u65b0\u898f\u30ea\u30b9\u30c8\u540d\u3092\u5165\u308c\u308c");
                if (name.length() > 0) {
                    DBService.getDBService().createAList(name);
                }
                ((VocabularomComboModel)VocabularFrame.this.jComboBox1.getModel()).updateInformation();
                ((VocabularomComboModel)VocabularFrame.this.jComboBox2.getModel()).updateInformation();
            }
        });
    }

    private void jComboBox2ActionPerformed(ActionEvent evt) {
        WordList list = (WordList)this.jComboBox2.getSelectedItem();
        List cards = DBService.getDBService().getWordCards(list);
        ((VocabularListModel)this.jList1.getModel()).setData(cards);
    }

    private void jButton4ActionPerformed(ActionEvent evt) {
        int[] rows;
        WordList list = (WordList)this.jComboBox1.getModel().getSelectedItem();
        for (int row : rows = this.jTable1.getSelectedRows()) {
            WordCard card = ((VocabularTableModel)this.jTable1.getModel()).getACard(row);
            DBService.getDBService().bindWordInList(card, list);
        }
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
        final VocabularFrame thisFrame = this;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFileChooser chooser = new JFileChooser();
                switch (chooser.showSaveDialog(thisFrame)) {
                    case 0: {
                        File file = chooser.getSelectedFile();
                        VocabularListModel model = (VocabularListModel)VocabularFrame.this.jList1.getModel();
                        ArrayList cards = new ArrayList();
                        Enumeration cardEnum = model.elements();
                        while (cardEnum.hasMoreElements()) {
                            cards.add(cardEnum.nextElement());
                        }
                        new PDFExporter().export(file, cards);
                    }
                }
            }
        });
    }

    private void wordFocusLost(FocusEvent evt) {
        if (this.word.getText().length() > 0) {
            ((DictionaryComboBoxModel)this.japanese.getModel()).update(this.word.getText());
            ((DictionaryComboBoxModel)this.english.getModel()).update(this.word.getText());
            ((DictionaryComboBoxModel)this.example.getModel()).update(this.word.getText());
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new VocabularFrame().setVisible(true);
            }
        });
    }
}

