/*
 * Decompiled with CFR 0.152.
 */
package org.tonouchi.vocable;

import java.sql.Connection;
import java.sql.DriverManager;
import org.tonouchi.vocable.VocablerRuntimeException;
import org.tonouchi.vocabularconfig.Config;

public class DBConnecitonHolder {
    private Connection con = null;
    private static final DBConnecitonHolder instance = new DBConnecitonHolder();

    public static DBConnecitonHolder getInstance() {
        return instance;
    }

    void connect(Config config) {
        try {
            if (this.con != null && !this.con.isClosed()) {
                throw new IllegalStateException("Already connected");
            }
            Class.forName(config.getDbDriverName());
            this.con = DriverManager.getConnection(config.getDbUrl());
        }
        catch (IllegalStateException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new VocablerRuntimeException("Cannot conect to Database", ex);
        }
    }

    Connection getConnection() {
        return this.con;
    }

    void close() {
        try {
            if (this.con == null || this.con.isClosed()) {
                throw new IllegalStateException("Connection already closed");
            }
            this.con.close();
            this.con = null;
        }
        catch (IllegalStateException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new VocablerRuntimeException("Cannot close the DB connection", ex);
        }
    }
}

