/*
 * Decompiled with CFR 0.152.
 */
package org.tonouchi.vocabularpublisher;

import com.lowagie.text.Document;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.List;
import org.tonouchi.vocabularconfig.Config;
import org.tonouchi.vocabulardb.WordCard;

public class PDFExporter {
    public void export(File file, List<WordCard> cards) {
        try {
            BaseFont baseFont = BaseFont.createFont((String)Config.getConfig().getPdfFontPath(), (String)"Identity-H", (boolean)true);
            Font omote = new Font(baseFont, 16.0f);
            Font ura_large = new Font(baseFont, 8.0f);
            Font ura_small = new Font(baseFont, 5.0f);
            Rectangle JouhouCard = new Rectangle(125.0f, 75.0f);
            Document document = new Document(JouhouCard, 10.0f, 10.0f, 10.0f, 10.0f);
            PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(file));
            document.open();
            for (WordCard data : cards) {
                Paragraph theWord = new Paragraph(data.getWord().length() > 20 ? data.getWord().substring(0, 20) : data.getWord(), omote);
                Paragraph pos = new Paragraph(data.getPos().length() > 16 ? data.getPos().substring(0, 16) : data.getPos(), ura_small);
                Paragraph japanese = new Paragraph(data.getJapanese().length() > 14 ? data.getJapanese().substring(0, 14) : data.getJapanese(), ura_large);
                Paragraph english = new Paragraph((data.getEnglish().length() > 66 ? data.getEnglish().substring(0, 66) : data.getEnglish()).replaceAll(data.getWord(), "-"), ura_small);
                Paragraph example = new Paragraph((data.getExample().length() > 66 ? data.getExample().substring(0, 66) : data.getExample()).replaceAll(data.getWord(), "-"), ura_small);
                theWord.setAlignment(1);
                pos.setSpacingAfter(1.0f);
                japanese.setIndentationLeft(1.0f);
                english.setIndentationLeft(1.0f);
                example.setIndentationLeft(1.0f);
                japanese.setSpacingAfter(1.0f);
                english.setSpacingAfter(1.0f);
                example.setSpacingAfter(1.0f);
                document.add((Element)theWord);
                document.newPage();
                document.add((Element)pos);
                document.add((Element)japanese);
                document.add((Element)english);
                document.add((Element)example);
                document.newPage();
            }
            document.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

