/*
 * Decompiled with CFR 0.152.
 */
package net.didion.jwnl.utilities;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.didion.jwnl.data.Exc;
import net.didion.jwnl.data.IndexWord;
import net.didion.jwnl.data.POS;
import net.didion.jwnl.data.Pointer;
import net.didion.jwnl.data.Synset;
import net.didion.jwnl.data.Verb;
import net.didion.jwnl.data.Word;
import net.didion.jwnl.dictionary.AbstractCachingDictionary;
import net.didion.jwnl.dictionary.Dictionary;
import net.didion.jwnl.util.MessageLog;
import net.didion.jwnl.util.MessageLogLevel;

public class DictionaryToDatabase {
    private static final MessageLog LOG;
    private static int INTERNAL_ID;
    private static long TIME;
    private Connection connection;
    private Map idToSynsetOffset = new HashMap();
    private Map synsetOffsetToId = new HashMap();
    static /* synthetic */ Class class$0;

    static {
        INTERNAL_ID = 0;
        TIME = 0L;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("net.didion.jwnl.utilities.DictionaryToDatabase");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = new MessageLog(clazz);
    }

    /*
     * Exception decompiling
     */
    public static void main(String[] args) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 4[TRYBLOCK] [3 : 162->166)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static synchronized int nextId() {
        if (LOG.isLevelEnabled(MessageLogLevel.DEBUG) && ++INTERNAL_ID % 1000 == 0) {
            long temp = System.currentTimeMillis();
            LOG.log(MessageLogLevel.DEBUG, "inserted " + INTERNAL_ID + "th entry");
            LOG.log(MessageLogLevel.DEBUG, "free memory: " + Runtime.getRuntime().freeMemory());
            LOG.log(MessageLogLevel.DEBUG, "time: " + (temp - TIME));
            TIME = System.currentTimeMillis();
        }
        return INTERNAL_ID;
    }

    public DictionaryToDatabase(Connection conn) {
        this.connection = conn;
        ((AbstractCachingDictionary)Dictionary.getInstance()).setCachingEnabled(false);
    }

    public void createTables(String scriptFilePath) throws IOException, SQLException {
        LOG.log(MessageLogLevel.INFO, "creating tables");
        BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(scriptFilePath)));
        StringBuffer buf = new StringBuffer();
        String line = reader.readLine();
        while (line != null) {
            if ((line = line.trim()).length() > 0) {
                buf.append(line);
                if (line.endsWith(";")) {
                    System.out.println(buf.toString());
                    this.connection.prepareStatement(buf.toString()).execute();
                    buf = new StringBuffer();
                } else {
                    buf.append(" ");
                }
            }
            line = reader.readLine();
        }
        LOG.log(MessageLogLevel.INFO, "creating tables");
    }

    public void insertData() throws Exception {
        TIME = System.currentTimeMillis();
        Iterator posItr = POS.getAllPOS().iterator();
        while (posItr.hasNext()) {
            POS pos = (POS)posItr.next();
            LOG.log(MessageLogLevel.INFO, "inserting data for pos " + pos);
            this.storeIndexWords(Dictionary.getInstance().getIndexWordIterator(pos));
            this.storeSynsets(Dictionary.getInstance().getSynsetIterator(pos));
            this.storeIndexWordSynsets();
            this.storeExceptions(Dictionary.getInstance().getExceptionIterator(pos));
            this.idToSynsetOffset.clear();
            this.synsetOffsetToId.clear();
            LOG.log(MessageLogLevel.INFO, "done inserting data for pos " + pos);
        }
    }

    private void storeIndexWords(Iterator itr) throws SQLException {
        LOG.log(MessageLogLevel.INFO, "storing index words");
        PreparedStatement iwStmt = this.connection.prepareStatement("INSERT INTO IndexWord VALUES(?,?,?)");
        int count = 0;
        while (itr.hasNext()) {
            IndexWord iw = (IndexWord)itr.next();
            int id = DictionaryToDatabase.nextId();
            iwStmt.setInt(1, id);
            iwStmt.setString(2, iw.getLemma());
            iwStmt.setString(3, iw.getPOS().getKey());
            iwStmt.execute();
            this.idToSynsetOffset.put(new Integer(id), iw.getSynsetOffsets());
            if (count++ % 1000 != 0) continue;
            System.out.println(count);
        }
    }

    private void storeSynsets(Iterator itr) throws SQLException {
        PreparedStatement synsetStmt = this.connection.prepareStatement("INSERT INTO Synset VALUES(?,?,?,?,?)");
        PreparedStatement synsetWordStmt = this.connection.prepareStatement("INSERT INTO SynsetWord VALUES(?,?,?,?)");
        PreparedStatement synsetPointerStmt = this.connection.prepareStatement("INSERT INTO SynsetPointer VALUES(?,?,?,?,?,?,?)");
        PreparedStatement synsetVerbFrameStmt = this.connection.prepareStatement("INSERT INTO SynsetVerbFrame VALUES(?,?,?,?)");
        LOG.log(MessageLogLevel.INFO, "storing synsets");
        int count = 0;
        while (itr.hasNext()) {
            if (count++ % 1000 == 0) {
                System.out.println("synset: " + count);
            }
            Synset synset = (Synset)itr.next();
            int id = DictionaryToDatabase.nextId();
            this.synsetOffsetToId.put(new Long(synset.getOffset()), new Integer(id));
            synsetStmt.setInt(1, id);
            synsetStmt.setLong(2, synset.getOffset());
            synsetStmt.setString(3, synset.getPOS().getKey());
            synsetStmt.setBoolean(4, synset.isAdjectiveCluster());
            synsetStmt.setString(5, synset.getGloss());
            synsetStmt.execute();
            Word[] words = synset.getWords();
            synsetWordStmt.setInt(2, id);
            synsetVerbFrameStmt.setInt(2, id);
            int i = 0;
            while (i < words.length) {
                int wordId = DictionaryToDatabase.nextId();
                synsetWordStmt.setInt(1, wordId);
                synsetWordStmt.setString(3, words[i].getLemma());
                synsetWordStmt.setInt(4, words[i].getIndex());
                synsetWordStmt.execute();
                if (words[i] instanceof Verb) {
                    synsetVerbFrameStmt.setInt(4, words[i].getIndex());
                    int[] flags = ((Verb)words[i]).getVerbFrameIndicies();
                    int j = 0;
                    while (j < flags.length) {
                        synsetVerbFrameStmt.setInt(1, DictionaryToDatabase.nextId());
                        synsetVerbFrameStmt.setInt(3, flags[j]);
                        synsetVerbFrameStmt.execute();
                        ++j;
                    }
                }
                ++i;
            }
            Pointer[] pointers = synset.getPointers();
            synsetPointerStmt.setInt(2, id);
            int i2 = 0;
            while (i2 < pointers.length) {
                synsetPointerStmt.setInt(1, DictionaryToDatabase.nextId());
                synsetPointerStmt.setString(3, pointers[i2].getType().getKey());
                synsetPointerStmt.setLong(4, pointers[i2].getTargetOffset());
                synsetPointerStmt.setString(5, pointers[i2].getTargetPOS().getKey());
                synsetPointerStmt.setInt(6, pointers[i2].getSourceIndex());
                synsetPointerStmt.setInt(7, pointers[i2].getTargetIndex());
                synsetPointerStmt.execute();
                ++i2;
            }
        }
    }

    private void storeIndexWordSynsets() throws SQLException {
        LOG.log(MessageLogLevel.INFO, "storing index word synsets");
        PreparedStatement iwsStmt = this.connection.prepareStatement("INSERT INTO IndexWordSynset VALUES(?,?,?)");
        Iterator itr = this.idToSynsetOffset.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry entry = itr.next();
            int iwId = (Integer)entry.getKey();
            iwsStmt.setInt(2, iwId);
            long[] offsets = (long[])entry.getValue();
            int i = 0;
            while (i < offsets.length) {
                Integer offset = (Integer)this.synsetOffsetToId.get(new Long(offsets[i]));
                int synsetId = offset;
                iwsStmt.setInt(1, DictionaryToDatabase.nextId());
                iwsStmt.setLong(3, synsetId);
                iwsStmt.execute();
                ++i;
            }
        }
    }

    private void storeExceptions(Iterator itr) throws SQLException {
        LOG.log(MessageLogLevel.INFO, "storing exceptions");
        PreparedStatement exStmt = this.connection.prepareStatement("INSERT INTO SynsetException VALUES(?,?,?,?)");
        while (itr.hasNext()) {
            Exc exc = (Exc)itr.next();
            exStmt.setString(4, exc.getLemma());
            Iterator excItr = exc.getExceptions().iterator();
            while (excItr.hasNext()) {
                exStmt.setInt(1, DictionaryToDatabase.nextId());
                exStmt.setString(2, exc.getPOS().getKey());
                exStmt.setString(3, (String)excItr.next());
                exStmt.execute();
            }
        }
    }
}

