/*
 * Decompiled with CFR 0.152.
 */
package net.didion.jwnl.princeton.data;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.StringTokenizer;
import net.didion.jwnl.data.Exc;
import net.didion.jwnl.data.FileDictionaryElementFactory;
import net.didion.jwnl.data.IndexWord;
import net.didion.jwnl.data.POS;
import net.didion.jwnl.data.Pointer;
import net.didion.jwnl.data.PointerType;
import net.didion.jwnl.data.Synset;
import net.didion.jwnl.data.SynsetProxy;
import net.didion.jwnl.data.Verb;
import net.didion.jwnl.data.Word;
import net.didion.jwnl.princeton.data.MutableVerb;
import net.didion.jwnl.util.MessageLog;
import net.didion.jwnl.util.MessageLogLevel;
import net.didion.jwnl.util.TokenizerParser;

public abstract class AbstractPrincetonFileDictionaryElementFactory
implements FileDictionaryElementFactory {
    private static final MessageLog _log;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("net.didion.jwnl.princeton.data.AbstractPrincetonFileDictionaryElementFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        _log = new MessageLog(clazz);
    }

    protected AbstractPrincetonFileDictionaryElementFactory() {
    }

    public IndexWord createIndexWord(POS pos, String line) {
        TokenizerParser tokenizer = new TokenizerParser(line, " ");
        String lemma = tokenizer.nextToken().replace('_', ' ');
        tokenizer.nextToken();
        tokenizer.nextToken();
        int pointerCount = tokenizer.nextInt();
        int i = 0;
        while (i < pointerCount) {
            tokenizer.nextToken();
            ++i;
        }
        int senseCount = tokenizer.nextInt();
        tokenizer.nextInt();
        long[] synsetOffsets = new long[senseCount];
        int i2 = 0;
        while (i2 < senseCount) {
            synsetOffsets[i2] = tokenizer.nextLong();
            ++i2;
        }
        if (_log.isLevelEnabled(MessageLogLevel.TRACE)) {
            _log.log(MessageLogLevel.TRACE, "PRINCETON_INFO_003", new Object[]{lemma, pos});
        }
        return new IndexWord(lemma, pos, synsetOffsets);
    }

    public Synset createSynset(POS pos, String line) {
        TokenizerParser tokenizer = new TokenizerParser(line, " ");
        long offset = tokenizer.nextLong();
        long lexFileNameId = tokenizer.nextLong();
        String synsetPOS = tokenizer.nextToken();
        boolean isAdjectiveCluster = false;
        if (synsetPOS.equals("s")) {
            isAdjectiveCluster = true;
        }
        SynsetProxy proxy = new SynsetProxy(pos);
        int wordCount = tokenizer.nextHexInt();
        Word[] words = new Word[wordCount];
        int i = 0;
        while (i < wordCount) {
            String lemma = tokenizer.nextToken();
            tokenizer.nextHexInt();
            words[i] = this.createWord(proxy, i, lemma);
            ++i;
        }
        int pointerCount = tokenizer.nextInt();
        Pointer[] pointers = new Pointer[pointerCount];
        int i2 = 0;
        while (i2 < pointerCount) {
            String pt = tokenizer.nextToken();
            PointerType pointerType = PointerType.getPointerTypeForKey(pt);
            long targetOffset = tokenizer.nextLong();
            POS targetPOS = POS.getPOSForKey(tokenizer.nextToken());
            int linkIndices = tokenizer.nextHexInt();
            int sourceIndex = linkIndices / 256;
            int targetIndex = linkIndices & 0xFF;
            SynsetProxy source = sourceIndex == 0 ? proxy : words[sourceIndex - 1];
            pointers[i2] = new Pointer(source, i2, pointerType, targetPOS, targetOffset, targetIndex);
            ++i2;
        }
        if (pos == POS.VERB) {
            int verbFrameCount = tokenizer.nextInt();
            int i3 = 0;
            while (i3 < verbFrameCount) {
                tokenizer.nextToken();
                int frameNumber = tokenizer.nextInt();
                int wordIndex = tokenizer.nextHexInt();
                if (wordIndex > 0) {
                    ((MutableVerb)words[wordIndex - 1]).setVerbFrameFlag(frameNumber);
                } else {
                    int j = 0;
                    while (j < words.length) {
                        ((MutableVerb)words[j]).setVerbFrameFlag(frameNumber);
                        ++j;
                    }
                }
                ++i3;
            }
        }
        String gloss = null;
        int index = line.indexOf(124);
        if (index > 0) {
            gloss = line.substring(index + 2).trim();
        }
        BitSet verbFrames = new BitSet();
        int i4 = 0;
        while (i4 < words.length) {
            if (words[i4] instanceof Verb) {
                verbFrames.or(((Verb)words[i4]).getVerbFrameFlags());
            }
            ++i4;
        }
        Synset synset = new Synset(pos, offset, words, pointers, gloss, verbFrames, isAdjectiveCluster);
        synset.setLexFileId(lexFileNameId);
        proxy.setSource(synset);
        if (_log.isLevelEnabled(MessageLogLevel.TRACE)) {
            _log.log(MessageLogLevel.TRACE, "PRINCETON_INFO_002", new Object[]{pos, new Long(offset)});
        }
        return proxy;
    }

    protected Word createWord(Synset synset, int index, String lemma) {
        Word word = synset.getPOS().equals(POS.VERB) ? new MutableVerb(synset, index, lemma) : new Word(synset, index, lemma);
        return word;
    }

    public Exc createExc(POS pos, String line) {
        StringTokenizer st = new StringTokenizer(line);
        String lemma = st.nextToken().replace('_', ' ');
        ArrayList<String> exceptions = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            exceptions.add(st.nextToken().replace('_', ' '));
        }
        if (_log.isLevelEnabled(MessageLogLevel.TRACE)) {
            _log.log(MessageLogLevel.TRACE, "PRINCETON_INFO_001", new Object[]{pos, lemma});
        }
        return new Exc(pos, lemma, exceptions);
    }
}

