/*
 * Decompiled with CFR 0.152.
 */
package org.tonouchi.vocabulardb;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.tonouchi.vocabulardb.WordCard;
import org.tonouchi.vocabulardb.WordList;

public class DBService {
    private static final DBService service = new DBService();
    private Connection con = null;

    public static DBService getDBService() {
        return service;
    }

    public void initialize(Connection con) {
        this.con = con;
    }

    public void deleteACard(WordCard card) {
        try {
            PreparedStatement prepStmt = this.con.prepareStatement("delete from cards where id=?");
            prepStmt.setInt(1, card.getId());
            prepStmt.executeUpdate();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void batchDelete(List<WordCard> cards) {
        try {
            this.con.setAutoCommit(false);
            for (WordCard card : cards) {
                this.deleteACard(card);
            }
            this.con.commit();
            this.con.setAutoCommit(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public WordCard getACard(int id) {
        try {
            PreparedStatement prepStmt = this.con.prepareStatement("select * from cards where id=?");
            prepStmt.setInt(1, id);
            ResultSet rset = prepStmt.executeQuery();
            if (rset.first()) {
                return this.mapACard(rset);
            }
            throw new IllegalArgumentException();
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
    }

    private WordCard mapACard(ResultSet rset) throws SQLException {
        WordCard card = new WordCard();
        card.setCreated(rset.getTimestamp("created"));
        card.setEnglish(rset.getString("english"));
        card.setExample(rset.getString("example"));
        card.setId(rset.getInt("id"));
        card.setJapanese(rset.getString("japanese"));
        card.setPos(rset.getString("pos"));
        card.setWord(rset.getString("word"));
        return card;
    }

    public void saveACard(WordCard wordCard) {
        try {
            PreparedStatement prepStatement = this.con.prepareStatement("insert into cards(word, pos, japanese, english, example) values(?,?,?,?,?)");
            prepStatement.setString(1, wordCard.getWord());
            prepStatement.setString(2, wordCard.getPos());
            prepStatement.setString(3, wordCard.getJapanese());
            prepStatement.setString(4, wordCard.getEnglish());
            prepStatement.setString(5, wordCard.getExample());
            prepStatement.executeUpdate();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void batchSave(List<WordCard> cards) {
        try {
            this.con.setAutoCommit(false);
            for (WordCard card : cards) {
                this.saveACard(card);
            }
            this.con.commit();
            this.con.setAutoCommit(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public List<WordCard> getCards() {
        ArrayList<WordCard> cards = new ArrayList<WordCard>();
        try {
            PreparedStatement prepStatement = this.con.prepareStatement("select * from cards order by created desc");
            ResultSet rset = prepStatement.executeQuery();
            if (rset.first()) {
                do {
                    cards.add(this.mapACard(rset));
                } while (rset.next());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return cards;
    }

    public void updateACard(WordCard card) {
        try {
            PreparedStatement prepStmt = this.con.prepareStatement("update cards set word=?, pos=?, japanese=?, english=?, example=? where id=?");
            prepStmt.setString(1, card.getWord());
            prepStmt.setString(2, card.getPos());
            prepStmt.setString(3, card.getJapanese());
            prepStmt.setString(4, card.getEnglish());
            prepStmt.setString(5, card.getExample());
            prepStmt.setInt(6, card.getId());
            prepStmt.executeUpdate();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void createAList(String name) {
        try {
            PreparedStatement prepStmt = this.con.prepareStatement("insert into binders(name) values(?)");
            prepStmt.setString(1, name);
            prepStmt.executeUpdate();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public List<WordList> getWordLists() {
        ArrayList<WordList> _list = new ArrayList<WordList>();
        try {
            PreparedStatement prepStmt = this.con.prepareStatement("select * from binders");
            ResultSet rset = prepStmt.executeQuery();
            if (rset.first()) {
                do {
                    WordList list = new WordList();
                    list.setId(rset.getInt("id"));
                    list.setName(rset.getString("name"));
                    list.setCreated(rset.getTimestamp("created"));
                    _list.add(list);
                } while (rset.next());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return _list;
    }

    public void bindWordInList(WordCard card, WordList list) {
        try {
            PreparedStatement prepStmt = this.con.prepareStatement("insert into leaves(card_id, binder_id) values(?, ?)");
            prepStmt.setInt(1, card.getId());
            prepStmt.setInt(2, list.getId());
            prepStmt.executeUpdate();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public List<WordCard> getWordCards(WordList list) {
        ArrayList<WordCard> cards = new ArrayList<WordCard>();
        try {
            PreparedStatement prepStmt = this.con.prepareStatement("select c.id as id, c.word as word, c.pos as pos, c.japanese as japanese, c.english as english, c.example as example, c.created as created from cards c inner join leaves l on c.id=l.card_id where l.binder_id=?");
            prepStmt.setInt(1, list.getId());
            ResultSet rset = prepStmt.executeQuery();
            if (rset.first()) {
                do {
                    cards.add(this.mapACard(rset));
                } while (rset.next());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return cards;
    }
}

