/*
 * Decompiled with CFR 0.152.
 */
package org.tonouchi.vocabulardictionary.smartfm.sentences;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import javax.xml.stream.events.XMLEvent;
import org.tonouchi.vocabulardictionary.smartfm.items.ItemCommand;
import org.tonouchi.vocabulardictionary.smartfm.items.SmartFmCommand;
import org.tonouchi.vocabulardictionary.smartfm.sentences.SetASentenceCommand;

public class SmartFmSentencesCommandFactory {
    private Hashtable<String, SmartFmCommand> commandMap = new Hashtable();
    private SmartFmCommand smartFmCommand = new SmartFmCommand();

    public SmartFmSentencesCommandFactory() {
        this.commandMap.put("/sentences/sentence", new ItemCommand());
        this.commandMap.put("/sentences/sentence/text/@CHARACTERS", new SetASentenceCommand());
    }

    public SmartFmCommand create(Stack<XMLEvent> eventStack) {
        String key = this.toKey(eventStack);
        if (this.commandMap.containsKey(key)) {
            return this.commandMap.get(key);
        }
        return this.smartFmCommand;
    }

    private String toKey(Stack<XMLEvent> eventStack) {
        Enumeration eventEnumeration = eventStack.elements();
        StringBuffer buf = new StringBuffer();
        while (eventEnumeration.hasMoreElements()) {
            XMLEvent event = (XMLEvent)eventEnumeration.nextElement();
            if (event.isStartElement()) {
                buf.append('/').append(event.asStartElement().getName().getLocalPart());
                continue;
            }
            if (!event.isCharacters()) continue;
            buf.append('/').append("@CHARACTERS");
        }
        return buf.toString();
    }
}

