/*
 * Decompiled with CFR 0.152.
 */
package org.tonouchi.vocabularconfig.stax;

import java.io.InputStream;
import java.util.Enumeration;
import java.util.Stack;
import javax.xml.stream.EventFilter;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.events.XMLEvent;
import org.tonouchi.vocabularconfig.ConfigBuilder;
import org.tonouchi.vocabularconfig.stax.commands.CommandFactory;

public class XMLConfigBuilder
extends ConfigBuilder<InputStream> {
    @Override
    public void initialize(InputStream inputResource) {
        try {
            XMLInputFactory factory = XMLInputFactory.newInstance();
            XMLEventReader reader = factory.createXMLEventReader(inputResource);
            reader = factory.createFilteredReader(reader, new EventFilter(){

                @Override
                public boolean accept(XMLEvent event) {
                    return event.isStartElement() || event.isEndElement();
                }
            });
            CommandFactory commandFactory = new CommandFactory();
            Stack<XMLEvent> eventStack = new Stack<XMLEvent>();
            while (reader.hasNext()) {
                XMLEvent event = reader.nextEvent();
                if (event.isStartElement()) {
                    eventStack.push(event);
                    commandFactory.getCommand(this.getCommandKey(eventStack)).invoke(eventStack.peek());
                    continue;
                }
                if (!event.isEndElement()) continue;
                eventStack.pop();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private String getCommandKey(Stack<XMLEvent> eventStack) {
        Enumeration eventEnumeration = eventStack.elements();
        StringBuffer buf = new StringBuffer();
        while (eventEnumeration.hasMoreElements()) {
            XMLEvent event = (XMLEvent)eventEnumeration.nextElement();
            if (!event.isStartElement()) continue;
            buf.append('/').append(event.asStartElement().getName().getLocalPart());
        }
        return buf.toString();
    }
}

