/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.h2.engine.Session;
import org.h2.index.Cursor;
import org.h2.message.Message;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.table.Column;
import org.h2.table.TableLink;
import org.h2.value.DataType;
import org.h2.value.Value;

public class LinkedCursor
implements Cursor {
    private final TableLink tableLink;
    private final PreparedStatement prep;
    private final String sql;
    private final Session session;
    private final ResultSet rs;
    private Row current;

    LinkedCursor(TableLink tableLink, ResultSet resultSet, Session session, String string, PreparedStatement preparedStatement) {
        this.session = session;
        this.tableLink = tableLink;
        this.rs = resultSet;
        this.sql = string;
        this.prep = preparedStatement;
    }

    private void closeResultSetAndReusePreparedStatement() throws SQLException {
        this.rs.close();
        this.tableLink.reusePreparedStatement(this.prep, this.sql);
    }

    public Row get() {
        return this.current;
    }

    public SearchRow getSearchRow() {
        return this.current;
    }

    public int getPos() {
        throw Message.throwInternalError();
    }

    public boolean next() throws SQLException {
        boolean bl = this.rs.next();
        if (!bl) {
            this.closeResultSetAndReusePreparedStatement();
            this.current = null;
            return false;
        }
        this.current = this.tableLink.getTemplateRow();
        for (int i = 0; i < this.current.getColumnCount(); ++i) {
            Column column = this.tableLink.getColumn(i);
            Value value = DataType.readValue(this.session, this.rs, i + 1, column.getType());
            this.current.setValue(i, value);
        }
        return true;
    }

    public boolean previous() {
        throw Message.throwInternalError();
    }
}

