/*
    GtkShot for Windows
    copyright (c) 1998-2007 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#include "dialog.h"
#include "drive.h"
#include "gshot.h"
#include "resource.h"
#include <tchar.h>


/******************************************************************************
*                                                                             *
* ja:_CAO֐Q                                                         *
*                                                                             *
******************************************************************************/
BOOL CALLBACK
DriveDlgProc (HWND   hDlg,
              UINT   uMsg,
              WPARAM wParam,
              LPARAM lParam)
{
  switch (uMsg)
    {
      case WM_INITDIALOG:
        {
          int i;
          TCHAR szName[160], szVersion[80];

          for (i = 0; i < 9; i++)
            if (capGetDriverDescription (i, szName, sizeof (TCHAR) * 160,
                                            szVersion, sizeof (TCHAR) * 80))
              {
                int nID;

                nID = SendDlgItemMessage (hDlg, IDC_LISTBOX51,
                                            LB_ADDSTRING, 0, (LPARAM)szName);
                if (nID < 0)
                  {
                    MessageBox (hDlg, _T("LB_ADDSTRING"),
                                      APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                    EndDialog (hDlg, IDCANCEL);
                    return TRUE;
                  }
                if (SendDlgItemMessage (hDlg, IDC_LISTBOX51,
                                            LB_SETITEMDATA, nID, i) == LB_ERR)
                  {
                    MessageBox (hDlg, _T("LB_SETITEMDATA"),
                                      APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                    EndDialog (hDlg, IDCANCEL);
                    return TRUE;
                  }
                if (nDeviceID == i && SendDlgItemMessage (hDlg, IDC_LISTBOX51,
                                            LB_SETCURSEL, nID, 0) == LB_ERR)
                  {
                    MessageBox (hDlg, _T("LB_SETCURSEL"),
                                      APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                    EndDialog (hDlg, IDCANCEL);
                    return TRUE;
                  }
              }
        }
        return TRUE;
      case WM_COMMAND:
        switch (LOWORD (wParam))
          {
            case IDOK:
              {
                int nID;

                nID = SendDlgItemMessage (hDlg, IDC_LISTBOX51,
                                                        LB_GETCURSEL, 0, 0);
                if (nID == LB_ERR)
                  MessageBox (hDlg, _T("LB_GETCURSEL"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                nDeviceID = SendDlgItemMessage (hDlg, IDC_LISTBOX51,
                                                    LB_GETITEMDATA, nID, 0);
                InitHardware (hWndMain);
              }
            case IDCANCEL:
              if (!EndDialog (hDlg, LOWORD (wParam)))
                MessageBox (hDlg, _T("EndDialog"),
                                  APPLICATION, MB_OK | MB_ICONEXCLAMATION);
              return TRUE;
            case IDC_LISTBOX51:
              if (HIWORD (wParam) == LBN_SELCHANGE
                                        && !EnableDlgItem (hDlg, IDOK, TRUE))
                {
                  MessageBox (hDlg, _T("EnableDlgItem"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                  EndDialog (hDlg, IDCANCEL);
                }
          }
          return TRUE;
      }
    return FALSE;
}
