/*
    memapi
    copyright (c) 1998-2007 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#include "memapi.h"


/******************************************************************************
*                                                                             *
* ja:֐Q                                                             *
*                                                                             *
******************************************************************************/
/*  ja:̓er
    lpvBuf0,obt@0
    lpvBuf1,obt@1
     uBytes,oCg
        RET,:lpvBuf0,:lpvBuf1,0:                    */
INT WINAPI
MemoryCompare (LPCVOID lpvBuf0,
               LPCVOID lpvBuf1,
               UINT    uBytes)
{
  INT nResult;
  UINT i;
  LPBYTE lpbBuf0, lpbBuf1;

  lpbBuf0 = (LPBYTE)lpvBuf0;
  lpbBuf1 = (LPBYTE)lpvBuf1;
  for (i = 0; i < uBytes; i++)
    if ((nResult = *lpbBuf0++ - *lpbBuf1++) != 0)
      return nResult;
  return 0;
}


/*  ja:mۂ
    uBytes,TCY
       RET,mۂ,NULL:G[                                       */
LPVOID WINAPI
MemoryAlloc (UINT uBytes)
{
  return uBytes > 0 ? HeapAlloc (GetProcessHeap (), HEAP_ZERO_MEMORY, uBytes)
                    : NULL;
}


/*  ja:
    lpMemory,mۂ
         RET,TRUE:I,FALSE:G[                                     */
BOOL WINAPI
MemoryFree (LPVOID lpMemory)
{
  return !lpMemory || HeapFree (GetProcessHeap (), 0, lpMemory);
}


/*  ja:̃TCYύX
    lpMemory,mۂ
      uBytes,TCY
         RET,mۂ,NULL:G[                                     */
LPVOID WINAPI
MemoryReAlloc (LPVOID lpMemory, UINT uBytes)
{
  return uBytes > 0 ? lpMemory
        ? HeapReAlloc (GetProcessHeap (), HEAP_ZERO_MEMORY, lpMemory, uBytes)
        : MemoryAlloc (uBytes)
        : (MemoryFree (lpMemory), NULL);
}
