/*
    GtkShot for Windows
    copyright (c) 1998-2006 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#include "dialog.h"
#include "gshot.h"
#include "live.h"
#include "memapi.h"
#include "resource.h"
#include "valstr.h"
#include <tchar.h>


/******************************************************************************
*                                                                             *
* ja:_CAO֐Q                                                         *
*                                                                             *
******************************************************************************/
BOOL CALLBACK
LiveDlgProc (HWND   hDlg,
             UINT   uMsg,
             WPARAM wParam,
             LPARAM lParam)
{
  static CHOOSECOLOR cc;

  switch (uMsg)
    {
      case WM_INITDIALOG:
        {
          int i, j;
          DWORD dwTemp[MAX_RATE];
          TCHAR szText[128];

          static DWORD dwCustColors[16] = {
RGB ( 64,  64,  64), RGB (  0, 128, 255), RGB (  0, 255, 128), RGB (128,   0, 255),
RGB (128, 255,   0), RGB (255,   0, 128), RGB (255, 128,   0), RGB (128, 128, 255),
RGB (128, 255, 128), RGB (255, 128, 128), RGB (128, 255, 255), RGB (255, 128, 255),
RGB (255, 255, 128), RGB (192, 255, 255), RGB (255, 192, 255), RGB (255, 255, 192)};

          /* ja:CHOOSECOLOR\ */
          cc.lStructSize = sizeof (CHOOSECOLOR);
          cc.hwndOwner = hDlg;
          cc.rgbResult = crColor;
          cc.lpCustColors = dwCustColors;
          cc.Flags = CC_RGBINIT;
          /* ja:`FbN{bNX̐ݒ */
          if (!CheckDlgButton (hDlg, IDC_CHECKBOX41,
                                        fScale ? BST_CHECKED : BST_UNCHECKED)
                    || !CheckDlgButton (hDlg, IDC_CHECKBOX42,
                                        fJust ? BST_CHECKED : BST_UNCHECKED)
                    || !CheckDlgButton (hDlg, IDC_CHECKBOX43,
                                        fColor ? BST_CHECKED : BST_UNCHECKED))
            {
              MessageBox (hDlg, _T("CheckDlgButton"),
                                APPLICATION, MB_OK | MB_ICONEXCLAMATION);
              EndDialog (hDlg, IDCANCEL);
              return TRUE;
            }
          /* ja:R{{bNX̐ݒ */
          MemoryCopy (dwTemp, dwHistory, MAX_RATE * sizeof (DWORD));
          for (i = 0; i < MAX_RATE - 1; i++)
            for (j = i + 1; j < MAX_RATE; j++)
              if (dwTemp[j] < dwTemp[i])
                {
                  DWORD dwDmy;

                  dwDmy = dwTemp[j];
                  dwTemp[j] = dwTemp[i];
                  dwTemp[i] = dwDmy;
                }
          SendDlgItemMessage (hDlg, IDC_COMBOBOX41, CB_LIMITTEXT, 12, 0);
          for (i = 0; i < MAX_RATE; i++)
            if (dwTemp[i] != 0)
              {
                FloatStr (dwTemp[i], 1000, szText);
                if (SendDlgItemMessage (hDlg, IDC_COMBOBOX41, CB_ADDSTRING,
                                                        0, (LPARAM)szText) < 0)
                  {
                    MessageBox (hDlg, _T("CB_ADDSTRING"),
                                      APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                    EndDialog (hDlg, IDCANCEL);
                    return TRUE;
                  }
              }
          FloatStr (dwPreviewRate, 1000, szText);
          if (!SetDlgItemText (hDlg, IDC_COMBOBOX41, szText))
            {
              MessageBox (hDlg, _T("SetDlgItemText"),
                                APPLICATION, MB_OK | MB_ICONEXCLAMATION);
              EndDialog (hDlg, IDCANCEL);
              return TRUE;
            }
          /* ja:WI{^̐ݒ */
          if (!CheckRadioButton (hDlg, IDC_RADIOBUTTON41, IDC_RADIOBUTTON43,
                            fPreview ? IDC_RADIOBUTTON42:
                            fOverlay ? IDC_RADIOBUTTON43 : IDC_RADIOBUTTON41))
            {
              MessageBox (hDlg, _T("CheckRadioButton"),
                                APPLICATION, MB_OK | MB_ICONEXCLAMATION);
              EndDialog (hDlg, IDCANCEL);
              return TRUE;
            }
          /* ja:Rg[̕\ */
          if (!EnableDlgItem (hDlg, IDC_CHECKBOX42, fScale)
                || !EnableDlgItem (hDlg, IDC_CHECKBOX43, fScale && !fJust)
                || !EnableDlgItem (hDlg, IDC_COMBOBOX41, fPreview)
                || !EnableDlgItem (hDlg, IDC_GROUPBOX41, fScale && !fJust)
                || !EnableDlgItem (hDlg, IDC_PUSHBUTTON41,
                                                fScale && !fJust && !fColor)
                || !EnableDlgItem (hDlg, IDC_RADIOBUTTON43, cdrive.fHasOverlay)
                || !EnableDlgItem (hDlg, IDC_STATIC41, fPreview))
            {
              MessageBox (hDlg, _T("EnableDlgItem"),
                                APPLICATION, MB_OK | MB_ICONEXCLAMATION);
              EndDialog (hDlg, IDCANCEL);
            }
        }
        return TRUE;
      case WM_COMMAND:
        switch (LOWORD (wParam))
          {
            case IDOK:
              {
                int i, nRate, nScale;
                TCHAR szText[128];

                /* ja:XP[O */
                fScale = IsDlgButtonChecked (hDlg, IDC_CHECKBOX41)
                                                                == BST_CHECKED;
                /* ja:c */
                fJust = IsDlgButtonChecked (hDlg, IDC_CHECKBOX42)
                                                                == BST_CHECKED;
                /* ja:VXeF */
                fColor = IsDlgButtonChecked (hDlg, IDC_CHECKBOX43)
                                                                == BST_CHECKED;
                /* ja:[g */
                GetDlgItemText (hDlg, IDC_COMBOBOX41, szText, 128);
                StrFloat (&nRate, &nScale, szText);
                dwPreviewRate = MulDiv (nRate, 1000, nScale);
                /* ja:vr[,I[o[C */
                if (IsDlgButtonChecked (hDlg, IDC_RADIOBUTTON42)
                                                                == BST_CHECKED)
                  {
                    fPreview = TRUE;
                    fOverlay = FALSE;
                  }
                else if (IsDlgButtonChecked (hDlg,
                                            IDC_RADIOBUTTON43) == BST_CHECKED)
                  {
                    fPreview = FALSE;
                    fOverlay = TRUE;
                  }
                else
                  {
                    fPreview = fOverlay = FALSE;
                  }
                SetLive (hWndMain);
                /* ja:uV̍XV */
                crColor = cc.rgbResult;
                if (!DeleteObject (hBrush))
                    MessageBox (hDlg, _T("DeleteObject"),
                                      APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                hBrush = CreateSolidBrush (fColor
                                    ? GetSysColor (COLOR_WINDOW) : crColor);
                if (!hBrush)
                  MessageBox (hDlg, _T("CreateSolidBrush"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                if (!InvalidateRect (hWndMain, NULL, TRUE))
                  MessageBox (hDlg, _T("InvalidateRect"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                /* ja:[g̗ */
                for (i = 0; i < MAX_RATE - 1; i++)
                  if (dwHistory[i] == dwPreviewRate)
                    break;
                MemoryCopy (dwHistory + 1, dwHistory, i * sizeof (DWORD));
                dwHistory[0] = dwPreviewRate;
              }
            case IDCANCEL:
              if (!EndDialog (hDlg, LOWORD (wParam)))
                MessageBox (hDlg, _T("EndDialog"),
                                  APPLICATION, MB_OK | MB_ICONEXCLAMATION);
              return TRUE;
            case IDC_RADIOBUTTON41:
            case IDC_RADIOBUTTON42:
            case IDC_RADIOBUTTON43:
              {
                BOOL fResult;

                fResult = IsDlgButtonChecked (hDlg, IDC_CHECKBOX41)
                                                                ==BST_CHECKED
                        && IsDlgButtonChecked (hDlg, IDC_CHECKBOX42)
                                                                != BST_CHECKED;
                if (!EnableDlgItem (hDlg, IDC_CHECKBOX42, IsDlgButtonChecked
                                        (hDlg, IDC_CHECKBOX41) == BST_CHECKED)
                    || !EnableDlgItem (hDlg, IDC_CHECKBOX43, fResult)
                    || !EnableDlgItem (hDlg, IDC_COMBOBOX41,
                                        LOWORD (wParam) == IDC_RADIOBUTTON42)
                    || !EnableDlgItem (hDlg, IDC_STATIC41,
                                        LOWORD (wParam) == IDC_RADIOBUTTON42)
                    || !EnableDlgItem (hDlg, IDC_GROUPBOX41, fResult)
                    || !EnableDlgItem (hDlg, IDC_PUSHBUTTON41, fResult
                                        && IsDlgButtonChecked (hDlg,
                                            IDC_CHECKBOX43) != BST_CHECKED))
                  {
                    MessageBox (hDlg, _T("EnableDlgItem"),
                                      APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                    EndDialog (hDlg, IDCANCEL);
                    return TRUE;
                  }
              }
              goto loop;
            case IDC_COMBOBOX41:
              if (HIWORD (wParam) != CBN_EDITCHANGE
                                        && HIWORD (wParam) != CBN_SELCHANGE)
                return TRUE;
              goto loop;
            case IDC_PUSHBUTTON41:
              if (!ChooseColor (&cc))
                return TRUE;
              goto loop;
            case IDC_CHECKBOX41:
              {
                BOOL fResult;

                fResult = IsDlgButtonChecked (hDlg, IDC_CHECKBOX41)
                                                                == BST_CHECKED;
                if (IsDlgButtonChecked (hDlg, IDC_CHECKBOX41) != BST_CHECKED
                    && !CheckDlgButton (hDlg, IDC_CHECKBOX42, BST_UNCHECKED))
                  {
                    MessageBox (hDlg, _T("CheckDlgButton"),
                                      APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                    EndDialog (hDlg, IDCANCEL);
                    return TRUE;
                  }
                if (!EnableDlgItem (hDlg, IDC_CHECKBOX42, fResult))
                  {
                    MessageBox (hDlg, _T("EnableDlgItem"),
                                      APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                    EndDialog (hDlg, IDCANCEL);
                    return TRUE;
                  }
                fResult = fResult && IsDlgButtonChecked (hDlg,
                                                IDC_CHECKBOX42) != BST_CHECKED;
                if (!EnableDlgItem (hDlg, IDC_CHECKBOX43, fResult)
                        || !EnableDlgItem (hDlg, IDC_GROUPBOX41, fResult)
                        || !EnableDlgItem (hDlg, IDC_PUSHBUTTON41, fResult
                                        && IsDlgButtonChecked (hDlg,
                                            IDC_CHECKBOX43) != BST_CHECKED))
                  {
                    MessageBox (hDlg, _T("EnableDlgItem"),
                                      APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                    EndDialog (hDlg, IDCANCEL);
                    return TRUE;
                  }
              }
            case IDC_CHECKBOX42:
              {
                BOOL fResult;

                fResult = IsDlgButtonChecked (hDlg, IDC_CHECKBOX41)
                                                                ==BST_CHECKED
                    && IsDlgButtonChecked (hDlg, IDC_CHECKBOX42)
                                                                != BST_CHECKED;
                if (!EnableDlgItem (hDlg, IDC_CHECKBOX43, fResult)
                        || !EnableDlgItem (hDlg, IDC_GROUPBOX41, fResult)
                        || !EnableDlgItem (hDlg, IDC_PUSHBUTTON41, fResult
                                        && IsDlgButtonChecked (hDlg,
                                            IDC_CHECKBOX43) != BST_CHECKED))
                  {
                    MessageBox (hDlg, _T("EnableDlgItem"),
                                      APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                    EndDialog (hDlg, IDCANCEL);
                    return TRUE;
                  }
              }
              goto loop;
            case IDC_CHECKBOX43:
              if (!EnableDlgItem (hDlg, IDC_PUSHBUTTON41,
                    IsDlgButtonChecked (hDlg, IDC_CHECKBOX43) != BST_CHECKED))
                {
                  MessageBox (hDlg, _T("EnableDlgItem"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                  EndDialog (hDlg, IDCANCEL);
                  return TRUE;
                }
            loop:
              {
                int nRate, nScale;
                BOOL fResult;
                TCHAR szText[128];

                GetDlgItemText (hDlg, IDC_COMBOBOX41, szText, 128);
                fResult = StrFloat (&nRate, &nScale, szText);
                if (!EnableDlgItem (hDlg, IDOK,
                                        fResult && nRate > 0 && nScale > 0))
                  {
                    MessageBox (hDlg, _T("EnableDlgItem"),
                                      APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                    EndDialog (hDlg, IDCANCEL);
                  }
              }
          }
        return TRUE;
    }
  return FALSE;
}
