/*
    memapi
    copyright (c) 1998-2006 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#include "memapi.h"


/******************************************************************************
*                                                                             *
* ja:֐Q                                                             *
*                                                                             *
******************************************************************************/
/*  ja:̓er
    lpvBuf1,obt@1
    lpvBuf2,obt@2
     uBytes,oCg
        RET,:lpvBuf1,:lpvBuf2,0:                    */
INT WINAPI
MemoryCompare (LPVOID lpvBuf1,
               LPVOID lpvBuf2,
               UINT   uBytes)
{
  int nResult = 0;

  __asm {
            mov     ecx,uBytes
            jecxz   loop0
            pushf
            cld
            mov     esi,lpvBuf1
            mov     edi,lpvBuf2
            repe    cmpsb
            dec     esi
            dec     edi
            xor     eax,eax
            mov     al,[esi]
            sub     al,[edi]
            mov     nResult,eax
            popf
    loop0:
  }
  return nResult;
}
