/*
    GtkShot for Windows
    copyright (c) 1998-2006 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#include "dialog.h"
#include "gshot.h"
#include "license.h"
#include "resource.h"
#include "version.h"
#include <tchar.h>


/******************************************************************************
*                                                                             *
* ja:_CAO֐Q                                                         *
*                                                                             *
******************************************************************************/
BOOL CALLBACK
HelpDlgProc (HWND   hDlg,
             UINT   uMsg,
             WPARAM wParam,
             LPARAM lParam)
{
  if (uMsg == WM_COMMAND)
    {
      switch (LOWORD (wParam))
        {
          case IDCANCEL:
            if (!EndDialog (hDlg, LOWORD (wParam)))
              MessageBox (hDlg, _T("EndDialog"),
                                APPLICATION, MB_OK | MB_ICONEXCLAMATION);
            return TRUE;
          case IDC_PUSHBUTTON91:
            DialogBoxGUI (hInst, MAKEINTRESOURCE (DIALOG_1),
                                                        hDlg, LicensedDlgProc);
        }
      return TRUE;
    }
  return FALSE;
}
