/*
    GtkShot for Windows
    copyright (c) 1998-2006 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#include "bmmacro.h"
#include "general.h"
#include "memapi.h"
#include "other.h"
#include "resource.h"
#include <commctrl.h>
#include <tchar.h>


/******************************************************************************
*                                                                             *
* ja:x֐Q                                                           *
*                                                                             *
******************************************************************************/
/*  ja:TCYύXꂽ
    hWnd,CEChE
     RET,TRUE:I,FALSE:G[                                         */
BOOL
ResizeWindow (HWND hWnd)
{
  int y, sx, sy;
  RECT rc;

  if (!GetClientRect (hWnd, &rc))
    {
      MessageBox (hWnd, _T("GetClientRect"),
                        APPLICATION, MB_OK | MB_ICONSTOP);
      DestroyWindow (hWnd);
      return FALSE;
    }
  sx = rc.right - rc.left;
  sy = rc.bottom - rc.top;
  SendMessage (hWndTool, TB_AUTOSIZE, 0, 0);
  if (!GetWindowRect (hWndTool, &rc))
    {
      MessageBox (hWnd, _T("GetWindowRect"),
                        APPLICATION, MB_OK | MB_ICONSTOP);
      DestroyWindow (hWnd);
      return FALSE;
    }
  y = rc.bottom - rc.top;
  if (!GetWindowRect (hWndStat, &rc))
    {
      MessageBox (hWnd, _T("GetWindowRect"),
                        APPLICATION, MB_OK | MB_ICONSTOP);
      DestroyWindow (hWnd);
      return FALSE;
    }
  if (!MoveWindow (hWndStat,
                    0, sy - rc.bottom + rc.top, sx, rc.bottom - rc.top, TRUE))
    {
      MessageBox (hWnd, _T("MoveWindow"),
                        APPLICATION, MB_OK | MB_ICONSTOP);
      DestroyWindow (hWnd);
      return FALSE;
    }
  if (nDeviceID < 0)
    {
      if (!MoveWindow (hWndCap, 0, y, 0, 0, TRUE))
        {
          MessageBox (hWnd, _T("MoveWindow"),
                            APPLICATION, MB_OK | MB_ICONSTOP);
          DestroyWindow (hWnd);
          return FALSE;
        }
    }
  else if (fJust)
    {
      if (!MoveWindow (hWndCap, 0, y, sx, sy - y - rc.bottom + rc.top, TRUE))
        {
          MessageBox (hWnd, _T("MoveWindow"),
                            APPLICATION, MB_OK | MB_ICONSTOP);
          DestroyWindow (hWnd);
          return FALSE;
        }
    }
  else
    {
      int cx, cy;

      sy = sy - y - (rc.bottom - rc.top);
      /* ja:c̔䗦ێčł傫TCYɍ킹 */
      cx = min (cstat.uiImageWidth * sy / cstat.uiImageHeight, sx);
      cy = min (cstat.uiImageHeight * sx / cstat.uiImageWidth, sy);
      if (!MoveWindow (hWndCap,
                            (sx - cx) / 2, (sy - cy) / 2 + y, cx, cy, TRUE))
        {
          MessageBox (hWnd, _T("MoveWindow"),
                            APPLICATION, MB_OK | MB_ICONSTOP);
          DestroyWindow (hWnd);
          return FALSE;
        }
    }
  return TRUE;
}


/*  ja:Lv`EChE̐ݒ
        hWnd,CEChE
     uiWidth,
    uiHeight,
         RET,TRUE:I,FALSE:G[                                     */
BOOL
SetMainWindowSize (HWND hWnd,
                   UINT uiWidth,
                   UINT uiHeight)
{
  int s, y, cxWork, cyWork;
  RECT rc;
  WINDOWPLACEMENT wndpl;

  fLayout = FALSE;
  /* ja:fBXNgbv̍Ɨ̈ */
  if (!SystemParametersInfo (SPI_GETWORKAREA, 0, &rc, 0))
    {
      MessageBox (hWnd, _T("SystemParametersInfo"),
                        APPLICATION, MB_OK | MB_ICONSTOP);
      DestroyWindow (hWnd);
      return FALSE;
    }
  cxWork = rc.right - rc.left;
  cyWork = rc.bottom - rc.top;
  /* ja:c[o[ */
  if (!GetWindowRect (hWndTool, &rc))
    {
      MessageBox (hWnd, _T("GetWindowRect"),
                        APPLICATION, MB_OK | MB_ICONSTOP);
      DestroyWindow (hWnd);
      return FALSE;
    }
  y = rc.bottom - rc.top;
  /* ja:Xe[^XEChE */
  if (!GetWindowRect (hWndStat, &rc))
    {
      MessageBox (hWnd, _T("GetWindowRect"),
                        APPLICATION, MB_OK | MB_ICONSTOP);
      DestroyWindow (hWnd);
      return FALSE;
    }
  /* ja:vZ */
  y += rc.bottom - rc.top;
  /* ja:EChẼTCY擾 */
  wndpl.length = sizeof (WINDOWPLACEMENT);
  if (!GetWindowPlacement (hWnd, &wndpl))
    {
      MessageBox (hWnd, _T("GetWindowPlacement"),
                        APPLICATION, MB_OK | MB_ICONSTOP);
      DestroyWindow (hWnd);
      return FALSE;
    }
  wndpl.flags = 0;
  if (wndpl.showCmd == SW_SHOWMAXIMIZED)
    wndpl.showCmd = SW_RESTORE;
  wndpl.rcNormalPosition.right = wndpl.rcNormalPosition.left + uiWidth
                                    + GetSystemMetrics (SM_CXSIZEFRAME) * 2;
  wndpl.rcNormalPosition.bottom = wndpl.rcNormalPosition.top
        + uiHeight + y + GetSystemMetrics (SM_CYCAPTION)
        + GetSystemMetrics (SM_CYMENU) + GetSystemMetrics (SM_CYSIZEFRAME) * 2;
  /* ja:Eɂ͂ݏoĂ邩 */
  s = wndpl.rcNormalPosition.right - cxWork;
  if (s > 0)
    {
      wndpl.rcNormalPosition.left -= s;
      wndpl.rcNormalPosition.right -= s;
    }
  /* ja:ɂ͂ݏoĂ邩 */
  s = wndpl.rcNormalPosition.bottom - cyWork;
  if (s > 0)
    {
      wndpl.rcNormalPosition.top -= s;
      wndpl.rcNormalPosition.bottom -= s;
    }
  /* ja:ɂ͂ݏoĂ邩 */
  if (wndpl.rcNormalPosition.left < 0)
    {
      wndpl.rcNormalPosition.right -= wndpl.rcNormalPosition.left;
      wndpl.rcNormalPosition.left = 0;
    }
  /* ja:ɂ͂ݏoĂ邩 */
  if (wndpl.rcNormalPosition.top < 0)
    {
      wndpl.rcNormalPosition.bottom -= wndpl.rcNormalPosition.top;
      wndpl.rcNormalPosition.top = 0;
    }
  /* ja:EChẼTCYݒ */
  if (!SetWindowPlacement (hWnd, &wndpl))
    {
      MessageBox (hWnd, _T("SetWindowPlacement"),
                        APPLICATION, MB_OK | MB_ICONSTOP);
      DestroyWindow (hWnd);
      return FALSE;
    }
  /* ja:NCAgEChẼTCY␳ */
  if (!GetClientRect (hWnd, &rc))
    {
      MessageBox (hWnd, _T("GetClientRect"),
                        APPLICATION, MB_OK | MB_ICONSTOP);
      DestroyWindow (hWnd);
      return FALSE;
    }
  if (uiHeight + y != rc.bottom - rc.top)
    {
      wndpl.rcNormalPosition.bottom += uiHeight - (rc.bottom - rc.top - y);
      /* ja:ɂ͂ݏoĂ邩 */
      s = wndpl.rcNormalPosition.bottom - cyWork;
      if (s > 0)
        {
          wndpl.rcNormalPosition.top -= s;
          wndpl.rcNormalPosition.bottom -= s;
        }
      /* ja:ɂ͂ݏoĂ邩 */
      if (wndpl.rcNormalPosition.top < 0)
        {
          wndpl.rcNormalPosition.bottom -= wndpl.rcNormalPosition.top;
          wndpl.rcNormalPosition.top = 0;
        }
      /* ja:EChẼTCYݒ */
      if (!SetWindowPlacement (hWnd, &wndpl))
        {
          MessageBox (hWnd, _T("SetWindowPlacement"),
                            APPLICATION, MB_OK | MB_ICONSTOP);
          DestroyWindow (hWnd);
          return FALSE;
        }
    }
  /* ja:WTCY */
  siMainWnd.cx = wndpl.rcNormalPosition.right - wndpl.rcNormalPosition.left;
  siMainWnd.cy = wndpl.rcNormalPosition.bottom - wndpl.rcNormalPosition.top;
  fLayout = TRUE;
  return TRUE;
}


/*  ja:Cu̐ݒ
    hWnd,CEChE
     RET,TRUE:I,FALSE:G[                                         */
BOOL
SetLive (HWND hWnd)
{
  HMENU hMenu;
  LONG lStyle;

  /* ja:vr[̐ݒ */
  if (!capPreview (hWndCap, fPreview))
    {
      MessageBox (hWnd, _T("capPreview"),
                        APPLICATION, MB_OK | MB_ICONSTOP);
      DestroyWindow (hWnd);
      return FALSE;
    }
  /* ja:vr[̃[gݒ */
  if (!capPreviewRate (hWndCap, 1000000 / dwPreviewRate))
    {
      MessageBox (hWnd, _T("capPreviewRate"),
                        APPLICATION, MB_OK | MB_ICONSTOP);
      DestroyWindow (hWnd);
      return FALSE;
    }
  /* ja:XP[O */
  if (!capPreviewScale (hWndCap, fScale))
    {
      MessageBox (hWnd, _T("capPreviewScale"),
                        APPLICATION, MB_OK | MB_ICONSTOP);
      DestroyWindow (hWnd);
      return FALSE;
    }
  /* ja:I[o[CT|[gĂ邩? */
  if (cdrive.fHasOverlay)
    {
      /* ja:I[o[C̐ݒ */
      if (!capOverlay (hWndCap, fOverlay))
        {
          MessageBox (hWnd, _T("capOverlay"),
                            APPLICATION, MB_OK | MB_ICONSTOP);
          DestroyWindow (hWnd);
          return FALSE;
        }
    }
  else
    {
      fOverlay = FALSE;
    }
  /* ja:EChEX^CύX */
  lStyle = GetWindowLong (hWnd, GWL_STYLE);
  SetWindowLong (hWnd, GWL_STYLE,
                fScale ? lStyle | WS_MAXIMIZEBOX : lStyle & ~WS_MAXIMIZEBOX);
  /* ja:j[ */
  hMenu = GetMenu (hWnd);
  if (!hMenu)
    {
      MessageBox (hWnd, _T("GetMenu"),
                        APPLICATION, MB_OK | MB_ICONSTOP);
      DestroyWindow (hWnd);
      return FALSE;
    }
  if (EnableMenuItem (hMenu, CM_COPY,
                            !fOverlay ? MF_ENABLED : MF_GRAYED) ==0xffffffff
        || EnableMenuItem (hMenu, CM_REDRAW,
                !fPreview && !fOverlay ? MF_ENABLED : MF_GRAYED) == 0xffffffff)
    {
      MessageBox (hWnd, _T("EnableMenuItem"),
                        APPLICATION, MB_OK | MB_ICONSTOP);
      DestroyWindow (hWnd);
      return FALSE;
    }
  /* ja:j[XV */
  if (!DrawMenuBar (hWnd))
    {
      MessageBox (hWnd, _T("DrawMenuBar"),
                        APPLICATION, MB_OK | MB_ICONSTOP);
      DestroyWindow (hWnd);
      return FALSE;
    }
  return (fScale || SetMainWindowSize (hWnd,
            cstat.uiImageWidth, cstat.uiImageHeight)) && ResizeWindow (hWnd);
}


/*  ja:\tgEFAk̊mF
    lpProp,vpeB
       RET,TRUE:L,FALSE:                                             */
BOOL
CheckSoftwareCompress (LPPROPERTY lpProp)
{

  if (lpProp->fccHandler != 0 && lpProp->fccHandler != comptypeDIB)
    {
      COMPVARS cv;
      DWORD dwVideo;        /* ja:Lv`̃tH[}bg̃TCY */
      LPBITMAPINFO lpBmiIn; /* ja:Lv`̃tH[}bg */

      /* ja:wb^擾 */
      if ((dwVideo = capGetVideoFormatSize (hWndCap)) == 0
                                        || !(lpBmiIn = MemoryAlloc (dwVideo)))
        return FALSE;
      if (capGetVideoFormat (hWndCap, lpBmiIn, dwVideo) == 0)
        {
          MemoryFree (lpBmiIn);
          return FALSE;
        }
      MemorySet (&cv, 0, sizeof (COMPVARS));
      cv.cbSize = sizeof (COMPVARS);
      cv.fccHandler = lpProp->fccHandler;
      cv.lpbiOut = lpProp->lpBmiOut;
      cv.lKey = lpProp->lKey;
      cv.lDataRate = lpProp->lDataRate;
      cv.lQ = lpProp->lQ;
      cv.lpState = lpProp->lpState;
      cv.cbState = lpProp->cbState;
      cv.hic = ICOpen (ICTYPE_VIDEO, cv.fccHandler, ICMODE_FASTCOMPRESS);
      if (!cv.hic)
        {
          MemoryFree (lpBmiIn);
          return FALSE;
        }
      if (!ICSeqCompressFrameStart (&cv, lpBmiIn))
        {
          MemoryFree (lpBmiIn);
          ICClose (cv.hic);
          return FALSE;
        }
      ICSeqCompressFrameEnd (&cv);
      ICClose (cv.hic);
      MemoryFree (lpBmiIn);
    }
  return TRUE;
}


/*  ja:\tgEFAk̊mF                                               */
VOID
CheckCompress (VOID)
{
  int i;

  if (!CheckSoftwareCompress (&stProperty))
    {
      MemoryFree (stProperty.lpState);
      MemoryFree (stProperty.lpBmiOut);
      stProperty.fccHandler = 0;
      stProperty.lpBmiOut = NULL;
      stProperty.lKey = 0;
      stProperty.lDataRate = 0;
      stProperty.lQ = ICQUALITY_DEFAULT;
      stProperty.lpState = NULL;
      stProperty.cbState = 0;
    }
  for (i = 0; i < nRecordList; i++)
    if (!CheckSoftwareCompress (&lpRecordList[i].stProp))
      {
        MemoryFree (lpRecordList[i].stProp.lpState);
        MemoryFree (lpRecordList[i].stProp.lpBmiOut);
        lpRecordList[i].stProp.fccHandler = 0;
        lpRecordList[i].stProp.lpBmiOut = NULL;
        lpRecordList[i].stProp.lKey = 0;
        lpRecordList[i].stProp.lDataRate = 0;
        lpRecordList[i].stProp.lQ = ICQUALITY_DEFAULT;
        lpRecordList[i].stProp.lpState = NULL;
        lpRecordList[i].stProp.cbState = 0;
      }
}


/*  ja:foCX̐ݒ
    hWnd,CEChE
     RET,TRUE:I,FALSE:G[                                         */
BOOL
InitHardware (HWND hWnd)
{
  HMENU hMenu;

  /* ja:j[ */
  hMenu = GetMenu (hWnd);
  if (!hMenu)
    {
      MessageBox (hWnd, _T("GetMenu"),
                        APPLICATION, MB_OK | MB_ICONSTOP);
      DestroyWindow (hWnd);
      return FALSE;
    }
  /* ja:Lv`EChEhCoɐڑ */
  if (capDriverConnect (hWndCap, nDeviceID))
    {
      int i;

      /* ja:Lv`hCo̎擾 */
      if (!capDriverGetCaps (hWndCap, &cdrive, sizeof (CAPDRIVERCAPS)))
        {
          MessageBox (hWnd, _T("capDriverGetCaps"),
                            APPLICATION, MB_OK | MB_ICONSTOP);
          DestroyWindow (hWnd);
          return FALSE;
        }
      /* ja:Lv`Xe[^X̎擾 */
      if (!capGetStatus (hWndCap, &cstat, sizeof (CAPSTATUS)))
        {
          MessageBox (hWnd, _T("capGetStatus"),
                            APPLICATION, MB_OK | MB_ICONSTOP);
          DestroyWindow (hWnd);
          return FALSE;
        }
      /* ja:\tgEFAk̃`FbN */
      CheckCompress ();
      /* ja:TEh̐ݒ */
      if (cstat.fAudioHardware)
        {
          /* ja:tH[}bg̐`FbN */
          if (waveInOpen (NULL, WAVE_MAPPER, stProperty.lpWfx,
                                0, 0, WAVE_FORMAT_QUERY) != MMSYSERR_NOERROR)
            *stProperty.lpWfx = stWfx;
          for (i = 0; i < nRecordList; i++)
            if (waveInOpen (NULL, WAVE_MAPPER, lpRecordList[i].stProp.lpWfx,
                                0, 0, WAVE_FORMAT_QUERY) != MMSYSERR_NOERROR)
              *lpRecordList[i].stProp.lpWfx = stWfx;
        }
      else
        {
          stProperty.fAudio = FALSE;
          for (i = 0; i < nRecordList; i++)
            lpRecordList[i].stProp.fAudio = FALSE;
        }
      if (!SetLive (hWnd))
        return FALSE;
      if (EnableMenuItem (hMenu, 1, MF_BYPOSITION | MF_ENABLED) == 0xffffffff
        || EnableMenuItem (hMenu, 2, MF_BYPOSITION | MF_ENABLED) == 0xffffffff
        || EnableMenuItem (hMenu, CM_SAVE, MF_ENABLED) == 0xffffffff
        || EnableMenuItem (hMenu, CM_PROPERTY, MF_ENABLED) == 0xffffffff
        || EnableMenuItem (hMenu, CM_FORMAT, cdrive.fHasDlgVideoFormat
                                        ? MF_ENABLED : MF_GRAYED) == 0xffffffff
        || EnableMenuItem (hMenu, CM_SOURCE, cdrive.fHasDlgVideoSource
                                        ? MF_ENABLED : MF_GRAYED) == 0xffffffff
        || EnableMenuItem (hMenu, CM_DISPLAY, cdrive.fHasDlgVideoDisplay
                                        ? MF_ENABLED : MF_GRAYED) == 0xffffffff
        || EnableMenuItem (hMenu, CM_ENV, MF_ENABLED) == 0xffffffff
        || EnableMenuItem (hMenu, CM_TIMER, MF_ENABLED) == 0xffffffff)
        {
          MessageBox (hWnd, _T("EnableMenuItem"),
                            APPLICATION, MB_OK | MB_ICONSTOP);
          DestroyWindow (hWnd);
          return FALSE;
        }
      if (!SendMessage (hWndTool, TB_ENABLEBUTTON, CM_SAVE, TRUE)
                || !SendMessage (hWndTool, TB_ENABLEBUTTON, CM_PROPERTY, TRUE)
                || !SendMessage (hWndTool, TB_ENABLEBUTTON, CM_CAPTURE, TRUE)
                || !SendMessage (hWndTool, TB_ENABLEBUTTON, CM_FRAME, TRUE)
                || !SendMessage (hWndTool, TB_ENABLEBUTTON, CM_COPY, TRUE))
        {
          MessageBox (hWnd, _T("TB_ENABLEBUTTON"),
                            APPLICATION, MB_OK | MB_ICONSTOP);
          DestroyWindow (hWnd);
          return FALSE;
        }
    }
  else
    {
      /* ja:foCXɐڑłȂ */
      nDeviceID = -1;
      if (!SetMainWindowSize (hWnd, 320, 240) || !ResizeWindow (hWnd))
        return FALSE;
      if (EnableMenuItem (hMenu, 1, MF_BYPOSITION | MF_GRAYED) == 0xffffffff
        || EnableMenuItem (hMenu, 2, MF_BYPOSITION | MF_GRAYED) == 0xffffffff
        || EnableMenuItem (hMenu, CM_SAVE, MF_GRAYED) == 0xffffffff
        || EnableMenuItem (hMenu, CM_PROPERTY, MF_GRAYED) == 0xffffffff
        || EnableMenuItem (hMenu, CM_FORMAT, MF_GRAYED) == 0xffffffff
        || EnableMenuItem (hMenu, CM_SOURCE, MF_GRAYED) == 0xffffffff
        || EnableMenuItem (hMenu, CM_DISPLAY, MF_GRAYED) == 0xffffffff
        || EnableMenuItem (hMenu, CM_ENV, MF_GRAYED) == 0xffffffff
        || EnableMenuItem (hMenu, CM_TIMER, MF_GRAYED) == 0xffffffff)
        {
          MessageBox (hWnd, _T("EnableMenuItem"),
                            APPLICATION, MB_OK | MB_ICONSTOP);
          DestroyWindow (hWnd);
          return FALSE;
        }
      if (!SendMessage (hWndTool, TB_ENABLEBUTTON, CM_SAVE, FALSE)
                || !SendMessage (hWndTool, TB_ENABLEBUTTON, CM_PROPERTY, FALSE)
                || !SendMessage (hWndTool, TB_ENABLEBUTTON, CM_CAPTURE, FALSE)
                || !SendMessage (hWndTool, TB_ENABLEBUTTON, CM_FRAME, FALSE)
                || !SendMessage (hWndTool, TB_ENABLEBUTTON, CM_COPY, FALSE))
        {
          MessageBox (hWnd, _T("TB_ENABLEBUTTON"),
                            APPLICATION, MB_OK | MB_ICONSTOP);
          DestroyWindow (hWnd);
          return FALSE;
        }
    }
  /* ja:j[XV */
  if (!DrawMenuBar (hWnd))
    {
      MessageBox (hWnd, _T("DrawMenuBar"),
                        APPLICATION, MB_OK | MB_ICONSTOP);
      DestroyWindow (hWnd);
      return FALSE;
    }
  return TRUE;
}


/*  ja:ɎOɕ\ύX̏
    hWnd,CEChE
     RET,TRUE:I,FALSE:G[                                         */
BOOL
ChangeTopMost (HWND hWnd)
{
  HMENU hMenu;

  if (!SetWindowPos (hWnd, fTopMost ? HWND_TOPMOST : HWND_NOTOPMOST,
                                        0, 0, 0, 0, SWP_NOMOVE | SWP_NOSIZE))
    {
      MessageBox (hWnd, _T("SetWindowPos"),
                        APPLICATION, MB_OK | MB_ICONSTOP);
      DestroyWindow (hWnd);
      return FALSE;
    }
  /* ja:j[ */
  hMenu = GetMenu (hWnd);
  if (!hMenu)
    {
      MessageBox (hWnd, _T("GetMenu"),
                        APPLICATION, MB_OK | MB_ICONSTOP);
      DestroyWindow (hWnd);
      return FALSE;
    }
  /* ja:ɎOɕ\ */
  if (CheckMenuItem (hMenu, CM_TOP, fTopMost
                                    ? MF_CHECKED : MF_UNCHECKED) == 0xffffffff)
    {
      MessageBox (hWnd, _T("CheckMenuItem"),
                        APPLICATION, MB_OK | MB_ICONSTOP);
      DestroyWindow (hWnd);
      return FALSE;
    }
  /* ja:j[XV */
  if (!DrawMenuBar (hWnd))
    {
      MessageBox (hWnd, _T("DrawMenuBar"),
                        APPLICATION, MB_OK | MB_ICONSTOP);
      DestroyWindow (hWnd);
      return FALSE;
    }
  return TRUE;
}


/*  ja:WXg֏                                                 */
VOID
RegWrite (VOID)
{
  int i, nWidth, nHeight;
  DWORD dwResult;
  FILETIME filetime;
  HKEY hKey;
  TCHAR szName[MAXPATH];
  WINDOWPLACEMENT wndpl;

  if (!(nRegStat & 2))
    return;
  wndpl.length = sizeof (WINDOWPLACEMENT);
  if (!GetWindowPlacement (hWndMain, &wndpl))
    {
      MessageBox (hWndMain, _T("GetWindowPlacement"),
                            APPLICATION, MB_OK | MB_ICONEXCLAMATION);
      return;
    }
  nWidth = wndpl.rcNormalPosition.right - wndpl.rcNormalPosition.left;
  nHeight = wndpl.rcNormalPosition.bottom - wndpl.rcNormalPosition.top;
  if (RegOpenKeyEx (HKEY_CURRENT_USER, _T("Software\\maid.org\\GtkShot"),
                                    0, KEY_ALL_ACCESS, &hKey) != ERROR_SUCCESS)
    {
      if ((nRegStat & 4) && MessageBox (NULL,
            LoadText (hInst, IDS_OTHER_REG), APPLICATION, MB_OKCANCEL) != IDOK)
        return;
      if (RegCreateKeyEx (HKEY_CURRENT_USER, _T("Software\\maid.org\\GtkShot"),
                            0, _T(""), REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS,
                                    NULL, &hKey, &dwResult) != ERROR_SUCCESS)
        {
          MessageBox (NULL, _T("RegCreateKeyEx"),
                            APPLICATION, MB_OK | MB_ICONEXCLAMATION);
          return;
        }
    }
  /* ja:TuL[폜 */
  while (dwResult = MAXPATH, RegEnumKeyEx (hKey, 0, szName, &dwResult,
                                NULL, NULL, NULL, &filetime) == ERROR_SUCCESS)
    if (RegDeleteKey (hKey, szName) != ERROR_SUCCESS)
      {
        MessageBox (NULL, _T("RegDeleteKey"),
                          APPLICATION, MB_OK | MB_ICONEXCLAMATION);
        RegCloseKey (hKey);
        return;
      }
  /* ja:L[̒l폜 */
  while (dwResult = MAXPATH, RegEnumValue (hKey, 0, szName, &dwResult,
                                    NULL, NULL, NULL, NULL) == ERROR_SUCCESS)
    if (RegDeleteValue (hKey, szName) != ERROR_SUCCESS)
      {
        MessageBox (NULL, _T("RegDeleteValue"),
                          APPLICATION, MB_OK | MB_ICONEXCLAMATION);
        RegCloseKey (hKey);
        return;
      }
  if (RegSetValueEx (hKey, _T("Left"), 0, REG_DWORD,
        (LPBYTE)&wndpl.rcNormalPosition.left, sizeof (int)) != ERROR_SUCCESS
    || RegSetValueEx (hKey, _T("Top"), 0, REG_DWORD,
        (LPBYTE)&wndpl.rcNormalPosition.top, sizeof (int)) != ERROR_SUCCESS
    || RegSetValueEx (hKey, _T("Width"), 0, REG_DWORD,
        (LPBYTE)&nWidth, sizeof (int)) != ERROR_SUCCESS
    || RegSetValueEx (hKey, _T("Height"), 0, REG_DWORD,
        (LPBYTE)&nHeight, sizeof (int)) != ERROR_SUCCESS
    || RegSetValueEx (hKey, _T("DeviceID"), 0, REG_DWORD,
        (LPBYTE)&nDeviceID, sizeof (int)) != ERROR_SUCCESS
    || RegSetValueEx (hKey, _T("FileList"), 0, REG_DWORD,
        (LPBYTE)&nFileList, sizeof (int)) != ERROR_SUCCESS
    || RegSetValueEx (hKey, _T("RecordList"), 0, REG_DWORD,
        (LPBYTE)&nRecordList, sizeof (int)) != ERROR_SUCCESS
    || RegSetValueEx (hKey, _T("MakeUserHitOKToCapture"), 0, REG_DWORD,
        (LPBYTE)&fMakeUserHitOKToCapture, sizeof (BOOL)) != ERROR_SUCCESS
    || RegSetValueEx( hKey, _T("Color"), 0, REG_DWORD,
        (LPBYTE)&fColor, sizeof (BOOL)) != ERROR_SUCCESS
    || RegSetValueEx (hKey, _T("Just"), 0, REG_DWORD,
        (LPBYTE)&fJust, sizeof (BOOL)) != ERROR_SUCCESS
    || RegSetValueEx (hKey, _T("NumFrame"), 0, REG_DWORD,
        (LPBYTE)&fNumFrame, sizeof (BOOL)) != ERROR_SUCCESS
    || RegSetValueEx (hKey, _T("Preview"), 0, REG_DWORD,
        (LPBYTE)&fPreview, sizeof (BOOL)) != ERROR_SUCCESS
    || RegSetValueEx (hKey, _T("Overlay"), 0, REG_DWORD,
        (LPBYTE)&fOverlay, sizeof (BOOL)) != ERROR_SUCCESS
    || RegSetValueEx (hKey, _T("OverWrite"), 0, REG_DWORD,
        (LPBYTE)&fOverWrite, sizeof (BOOL)) != ERROR_SUCCESS
    || RegSetValueEx (hKey, _T("Rate"), 0, REG_DWORD,
        (LPBYTE)&fRate, sizeof (BOOL)) != ERROR_SUCCESS
    || RegSetValueEx (hKey, _T("Recycle"), 0, REG_DWORD,
        (LPBYTE)&fRecycle, sizeof (BOOL)) != ERROR_SUCCESS
    || RegSetValueEx (hKey, _T("Scale"), 0, REG_DWORD,
        (LPBYTE)&fScale, sizeof (BOOL)) != ERROR_SUCCESS
    || RegSetValueEx (hKey, _T("Timer"), 0, REG_DWORD,
        (LPBYTE)&fTimer, sizeof (BOOL)) != ERROR_SUCCESS
    || RegSetValueEx (hKey, _T("TopMost"), 0, REG_DWORD,
        (LPBYTE)&fTopMost, sizeof (BOOL)) != ERROR_SUCCESS
    || RegSetValueEx (hKey, _T("crColor"), 0, REG_DWORD,
        (LPBYTE)&crColor, sizeof (COLORREF)) != ERROR_SUCCESS
    || RegSetValueEx (hKey, _T("PreviewRate"), 0, REG_DWORD,
        (LPBYTE)&dwPreviewRate, sizeof (DWORD)) != ERROR_SUCCESS
    || RegSetValueEx (hKey, _T("SaveFilter"), 0, REG_DWORD,
        (LPBYTE)&dwSaveFilter, sizeof (DWORD)) != ERROR_SUCCESS
    || RegSetValueEx (hKey, _T("Frame"), 0, REG_DWORD,
        (LPBYTE)&uFrame, sizeof (UINT)) != ERROR_SUCCESS
    || RegSetValueEx (hKey, _T("MaxBytes"), 0, REG_BINARY,
        (LPBYTE)&uiMaxBytes, sizeof (UINT64)) != ERROR_SUCCESS
    || RegSetValueEx (hKey, _T("CaptureFile"), 0, REG_SZ,
        (LPBYTE)szCaptureFile,
            (lstrlen (szCaptureFile) + 1) * sizeof (TCHAR)) != ERROR_SUCCESS
    || RegSetValueEx (hKey, _T("FrameFile"), 0, REG_SZ, (LPBYTE)szFrameFile,
            (lstrlen (szFrameFile) + 1) * sizeof (TCHAR)) != ERROR_SUCCESS
    /* ja:vpeB */
    || RegSetValueEx (hKey, _T("CaptureAudio"), 0, REG_DWORD,
        (LPBYTE)&stProperty.fAudio, sizeof (BOOL)) != ERROR_SUCCESS
    || RegSetValueEx (hKey, _T("FrameRate"), 0, REG_DWORD,
        (LPBYTE)&stProperty.dwRate, sizeof (DWORD)) != ERROR_SUCCESS
    || stProperty.uFormat < 3
            && RegSetValueEx (hKey, _T("Format"), 0, REG_DWORD,
            (LPBYTE)&stProperty.uFormat, sizeof (UINT)) != ERROR_SUCCESS
    || RegSetValueEx (hKey, _T("WaveFormatEx"), 0, REG_BINARY,
        (LPBYTE)stProperty.lpWfx, dwMaxSizeFormat) != ERROR_SUCCESS
    || RegSetValueEx (hKey, _T("Handler"), 0, REG_DWORD,
        (LPBYTE)&stProperty.fccHandler, sizeof (FOURCC)) != ERROR_SUCCESS
    || RegSetValueEx (hKey, _T("Key"), 0, REG_DWORD,
        (LPBYTE)&stProperty.lKey, sizeof (LONG)) != ERROR_SUCCESS
    || RegSetValueEx (hKey, _T("DataRate"), 0, REG_DWORD,
        (LPBYTE)&stProperty.lDataRate, sizeof (LONG)) != ERROR_SUCCESS
    || RegSetValueEx (hKey, _T("Q"), 0, REG_DWORD,
        (LPBYTE)&stProperty.lQ, sizeof (LONG)) != ERROR_SUCCESS
    || stProperty.cbState > 0
            && RegSetValueEx (hKey, _T("State"), 0, REG_BINARY,
            (LPBYTE)stProperty.lpState, stProperty.cbState) != ERROR_SUCCESS
    || stProperty.lpBmiOut
            && RegSetValueEx (hKey, _T("Bmi"), 0, REG_BINARY,
            (LPBYTE)stProperty.lpBmiOut, bmHdrByte ((LPBITMAPINFOHEADER)
                                        stProperty.lpBmiOut)) != ERROR_SUCCESS
    /* ja: */
    || RegSetValueEx (hKey, _T("PercentDropForError"), 0, REG_DWORD,
        (LPBYTE)&cparam.wPercentDropForError, sizeof (UINT)) != ERROR_SUCCESS
    || RegSetValueEx (hKey, _T("NumVideoRequested"), 0, REG_DWORD,
        (LPBYTE)&cparam.wNumVideoRequested, sizeof (UINT)) != ERROR_SUCCESS
    || RegSetValueEx (hKey, _T("NumAudioRequested"), 0, REG_DWORD,
        (LPBYTE)&cparam.wNumAudioRequested, sizeof (UINT)) != ERROR_SUCCESS
    || RegSetValueEx (hKey, _T("AbortLeftMouse"), 0, REG_DWORD,
        (LPBYTE)&cparam.fAbortLeftMouse, sizeof (BOOL)) != ERROR_SUCCESS
    || RegSetValueEx (hKey, _T("AbortRightMouse"), 0, REG_DWORD,
        (LPBYTE)&cparam.fAbortRightMouse, sizeof (BOOL)) != ERROR_SUCCESS
    || RegSetValueEx (hKey, _T("LimitEnabled"), 0, REG_DWORD,
        (LPBYTE)&cparam.fLimitEnabled, sizeof (BOOL)) != ERROR_SUCCESS
    || RegSetValueEx (hKey, _T("TimeLimit"), 0, REG_DWORD,
        (LPBYTE)&cparam.wTimeLimit, sizeof (UINT)) != ERROR_SUCCESS
    || RegSetValueEx (hKey, _T("AudioBufferSize"), 0, REG_DWORD,
        (LPBYTE)&cparam.dwAudioBufferSize, sizeof (DWORD)) != ERROR_SUCCESS)
    MessageBox (hWndMain, _T("RegSetValueEx"),
                          APPLICATION, MB_OK | MB_ICONEXCLAMATION);
  /* ja:t@CXg */
  for (i = 0; i < nFileList; i++)
    {
      wsprintf (szName, _T("ListFile%04d"), i);
      if (RegSetValueEx (hKey, szName, 0, REG_SZ,( LPBYTE)lpFileList[i].szFile,
                        (lstrlen (lpFileList[i].szFile) + 1) * sizeof (TCHAR))
                                                            != ERROR_SUCCESS)
        MessageBox (hWndMain, _T("RegSetValueEx"),
                              APPLICATION, MB_OK | MB_ICONEXCLAMATION);
      wsprintf (szName, _T("ListBytes%04d"), i);
      if (RegSetValueEx (hKey, szName, 0, REG_BINARY,
            (LPBYTE)&lpFileList[i].uiBytes, sizeof (UINT64)) != ERROR_SUCCESS)
        MessageBox (hWndMain, _T("RegSetValueEx"),
                              APPLICATION, MB_OK | MB_ICONEXCLAMATION);
    }
  /* ja: */
  for (i = 0; i < MAX_RATE; i++)
    {
      wsprintf (szName, _T("History%04d"), i);
      if (RegSetValueEx (hKey, szName, 0, REG_DWORD,
                    (LPBYTE)&dwHistory[i], sizeof (DWORD)) != ERROR_SUCCESS)
        MessageBox (hWndMain, _T("RegSetValueEx"),
                              APPLICATION, MB_OK | MB_ICONEXCLAMATION);
    }
  /* ja:^C} */
  for (i = 0; i < nRecordList; i++)
    {
      int j;
      HKEY hKeySub;

      wsprintf (szName, _T("Record%04d"), i);
      if (RegCreateKeyEx (hKey, szName, 0, _T(""), REG_OPTION_NON_VOLATILE,
                KEY_ALL_ACCESS, NULL, &hKeySub, &dwResult) != ERROR_SUCCESS)
        {
          MessageBox (hWndMain, _T("RegCreateKeyEx"),
                                APPLICATION, MB_OK | MB_ICONEXCLAMATION);
          break;
        }
      if (RegSetValueEx (hKeySub, _T("Weeks"), 0, REG_DWORD,
            (LPBYTE)&lpRecordList[i].dwWeeks, sizeof (DWORD)) != ERROR_SUCCESS
        || RegSetValueEx (hKeySub, _T("Day"), 0, REG_DWORD,
            (LPBYTE)&lpRecordList[i].nDay, sizeof (int)) != ERROR_SUCCESS
        || RegSetValueEx (hKeySub, _T("Hour"), 0, REG_DWORD,
            (LPBYTE)&lpRecordList[i].nHour, sizeof (int)) != ERROR_SUCCESS
        || RegSetValueEx (hKeySub, _T("Minute"), 0, REG_DWORD,
            (LPBYTE)&lpRecordList[i].nMinute, sizeof (int)) != ERROR_SUCCESS
        || RegSetValueEx (hKeySub, _T("Second"), 0, REG_DWORD,
            (LPBYTE)&lpRecordList[i].nSecond, sizeof (int)) != ERROR_SUCCESS
        || RegSetValueEx (hKeySub, _T("TimeLimit"), 0, REG_DWORD,
            (LPBYTE)&lpRecordList[i].uTimeLimit,
                                                sizeof (UINT)) != ERROR_SUCCESS
        || RegSetValueEx (hKeySub, _T("Alloc"), 0, REG_DWORD,
            (LPBYTE)&lpRecordList[i].uAlloc, sizeof (UINT)) != ERROR_SUCCESS
        || RegSetValueEx (hKeySub, _T("FileList"), 0, REG_DWORD,
            (LPBYTE)&lpRecordList[i].nFileList, sizeof (int)) != ERROR_SUCCESS
        /* ja:vpeB */
        || RegSetValueEx (hKeySub, _T("CaptureAudio"), 0, REG_DWORD,
            (LPBYTE)&lpRecordList[i].stProp.fAudio,
                                                sizeof (BOOL)) != ERROR_SUCCESS
        || RegSetValueEx (hKeySub, _T("FrameRate"), 0, REG_DWORD,
            (LPBYTE)&lpRecordList[i].stProp.dwRate,
                                            sizeof (DWORD)) != ERROR_SUCCESS
        || RegSetValueEx (hKeySub, _T("Format"), 0, REG_DWORD,
            (LPBYTE)&lpRecordList[i].stProp.uFormat,
                                                sizeof (UINT)) != ERROR_SUCCESS
        || RegSetValueEx (hKeySub, _T("WaveFormatEx"), 0, REG_BINARY,
            (LPBYTE)lpRecordList[i].stProp.lpWfx,
                                            dwMaxSizeFormat) != ERROR_SUCCESS
        || RegSetValueEx (hKeySub, _T("Handler"), 0, REG_DWORD,
            (LPBYTE)&lpRecordList[i].stProp.fccHandler,
                                            sizeof (FOURCC)) != ERROR_SUCCESS
        || RegSetValueEx (hKeySub, _T("Key"), 0, REG_DWORD,
            (LPBYTE)&lpRecordList[i].stProp.lKey,
                                                sizeof (LONG)) != ERROR_SUCCESS
        || RegSetValueEx (hKeySub, _T("DataRate"), 0, REG_DWORD,
            (LPBYTE)&lpRecordList[i].stProp.lDataRate,
                                                sizeof (LONG)) != ERROR_SUCCESS
        || RegSetValueEx (hKeySub, _T("Q"), 0, REG_DWORD,
            (LPBYTE)&lpRecordList[i].stProp.lQ, sizeof (LONG)) != ERROR_SUCCESS
        || lpRecordList[i].stProp.cbState > 0
                        && RegSetValueEx (hKeySub, _T("State"), 0, REG_BINARY,
                        (LPBYTE)lpRecordList[i].stProp.lpState,
                            lpRecordList[i].stProp.cbState) != ERROR_SUCCESS
        || lpRecordList[i].stProp.lpBmiOut
                        && RegSetValueEx (hKeySub, _T("Bmi"), 0, REG_BINARY,
                        (LPBYTE)lpRecordList[i].stProp.lpBmiOut,
                        bmHdrByte ((LPBITMAPINFOHEADER)
                            lpRecordList[i].stProp.lpBmiOut)) != ERROR_SUCCESS)
        MessageBox (hWndMain, _T("RegSetValueEx"),
                              APPLICATION, MB_OK | MB_ICONEXCLAMATION);
      for (j = 0; j < lpRecordList[i].nFileList; j++)
        {
          wsprintf (szName, _T("ListFile%04d"), j);
          if (RegSetValueEx (hKeySub, szName, 0, REG_SZ,
                        (LPBYTE)lpRecordList[i].lpFileList[j].szFile,
                        (lstrlen (lpRecordList[i].lpFileList[j].szFile) + 1)
                                            * sizeof (TCHAR)) != ERROR_SUCCESS)
            MessageBox (hWndMain, _T("RegSetValueEx"),
                                  APPLICATION, MB_OK | MB_ICONEXCLAMATION);
          wsprintf (szName, _T("ListBytes%04d"), j);
          if (RegSetValueEx (hKeySub, szName, 0, REG_BINARY,
                        (LPBYTE)&lpRecordList[i].lpFileList[j].uiBytes,
                                            sizeof (UINT64)) != ERROR_SUCCESS)
            MessageBox (hWndMain, _T("RegSetValueEx"),
                                  APPLICATION, MB_OK | MB_ICONEXCLAMATION);
        }
      if (RegCloseKey (hKeySub) != ERROR_SUCCESS)
        MessageBox (hWndMain, _T("RegCloseKey"),
                              APPLICATION, MB_OK | MB_ICONEXCLAMATION);
    }
  if (RegCloseKey (hKey) != ERROR_SUCCESS)
    MessageBox (hWndMain, _T("RegCloseKey"),
                          APPLICATION, MB_OK | MB_ICONEXCLAMATION);
}


/******************************************************************************
*                                                                             *
* ja:obt@֐                                                             *
*                                                                             *
******************************************************************************/
/*  ja:x
    lpszText,
         RET,TRUE:I,FALSE:G[                                     */
BOOL
AddWarning (LPCTSTR lpszText)
{
  int nPos, nLength, nDate;

  nLength = GetDateFormat (LOCALE_USER_DEFAULT, DATE_LONGDATE,
                                                        NULL, NULL, NULL, 0)
                + GetTimeFormat (LOCALE_USER_DEFAULT, TIME_FORCE24HOURFORMAT,
                                                        NULL, NULL, NULL, 0);
  if (!lpszWarning)
    {
      lpszWarning = MemoryAlloc ((nLength + lstrlen (lpszText) + 2)
                                                            * sizeof (TCHAR));
      if (!lpszWarning)
        return FALSE;
      nPos = 0;
    }
  else
    {
      lpszWarning = MemoryReAlloc (lpszWarning,
                                (nLength + lstrlen (lpszWarning)
                                + lstrlen (lpszText) + 6) * sizeof (TCHAR));
      if (!lpszWarning)
        return FALSE;
      lstrcat (lpszWarning, _T("\r\n\r\n"));
      nPos = lstrlen (lpszWarning);
    }
  nDate = GetDateFormat (LOCALE_USER_DEFAULT, DATE_LONGDATE, NULL,NULL,
                                                lpszWarning + nPos, nLength);
  nPos += nDate;
  lpszWarning[nPos - 1] = ' ';
  GetTimeFormat (LOCALE_USER_DEFAULT, TIME_FORCE24HOURFORMAT, NULL, NULL,
                                        lpszWarning + nPos, nLength - nDate);
  lstrcat (lpszWarning, _T("\r\n"));
  lstrcat (lpszWarning, lpszText);
  return TRUE;
}


/*  ja:t@C̗̈mۂ
    lpszFile,t@C
     uiBytes,t@CTCY
    fMessage,TRUE:bZ[W{bNX,FALSE:bZ[W{bNXȂ
         RET,TRUE:I,FALSE:G[                                     */
BOOL
AllocateFile (LPCTSTR lpszFile,
              UINT64  uiBytes,
              BOOL    fMessage)
{
  HANDLE hFile;
  LONG lHigh;

  if (fRecycle && IsFile (lpszFile))
    {
      TCHAR szFile[MAXPATH + 1];
      SHFILEOPSTRUCT shfo;

      lstrcpy (szFile, lpszFile);
      /* ja:Ƀt@C鎞ݔɎ̂Ă */
      MemorySet (&shfo, 0, sizeof (SHFILEOPSTRUCT));
      szFile[lstrlen (szFile) + 1] = '\0';
      shfo.hwnd = hWndMain;
      shfo.wFunc = FO_DELETE;
      shfo.pFrom = szFile;
      shfo.fFlags = FOF_ALLOWUNDO | FOF_NOCONFIRMATION
                                                | FOF_NOERRORUI | FOF_SILENT;
      SHFileOperation (&shfo);
    }
  hFile = CreateFile (lpszFile, GENERIC_WRITE,
                    FILE_SHARE_READ, NULL,OPEN_ALWAYS,
                    FILE_ATTRIBUTE_NORMAL | FILE_FLAG_SEQUENTIAL_SCAN, NULL);
  if (hFile == INVALID_HANDLE_VALUE)
    {
      if (fMessage)
        MessageBox (hWndMain, LoadText (hInst, IDS_FILE_OPEN),
                              APPLICATION, MB_OK | MB_ICONEXCLAMATION);
      else
        AddWarning (LoadText (hInst, IDS_FILE_OPEN));
      return FALSE;
    }
  lHigh = uiBytes >> 32;
  if (SetFilePointer (hFile, (LONG)uiBytes, &lHigh, FILE_BEGIN) == 0xffffffff
                                                    || !SetEndOfFile (hFile))
    {
      if (fMessage)
        MessageBox (hWndMain, LoadText (hInst, IDS_FILE_WRITE),
                              APPLICATION, MB_OK | MB_ICONEXCLAMATION);
      else
        AddWarning (LoadText (hInst, IDS_FILE_WRITE));
      CloseHandle (hFile);
      return FALSE;
    }
  if (!CloseHandle (hFile))
    {
      if (fMessage)
        MessageBox (hWndMain, _T("CloseHandle"),
                              APPLICATION, MB_OK | MB_ICONEXCLAMATION);
      else
        AddWarning (_T("CloseHandle"));
      return FALSE;
    }
  return TRUE;
}


/*  ja:obt@mۂ
    lpFList,t@C̃Xg
        RET,TRUE:I,FALSE:G[                                      */
BOOL
AllocBuffer (LPFILELIST lpFList,
             DWORD      dwSize)
{
  LPBYTE p, q;

  lpFList->dwData = dwSize;
  lpFList->dwMemory = lpFList->dwData + lpFList->dwBase;
  p = lpFList->lpbMemory;
  q = lpFList->lpbData;
  lpFList->lpbMemory = MemoryAlloc (lpFList->dwMemory);
  if (!lpFList->lpbMemory)
    {
      MemoryFree (p);
      lpFList->dwData = 0;
      lpFList->dwMemory = 0;
      fControl = FALSE;
      return FALSE;
    }
  lpFList->lpbData = (LPBYTE)(((UINT)lpFList->lpbMemory
                                    / lpFList->dwBase + 1) * lpFList->dwBase);
  MemoryCopy (lpFList->lpbData, q, lpFList->dwOffset);
  MemoryFree (p);
  return TRUE;
}
