/*
    GtkShot for Windows
    copyright (c) 1998-2006 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#include "capavi.h"
#include "capdbg.h"
#include "capgsr.h"
#include "capstd.h"
#include "capture.h"
#include "dialog.h"
#include "error.h"
#include "memapi.h"
#include "other.h"
#include "resource.h"
#include <tchar.h>
#include <shlobj.h>


/******************************************************************************
*                                                                             *
* ja:Lv`                                                               *
*                                                                             *
******************************************************************************/
/*  ja:Lv`
        lpProp,vpeB
       lpFlist,t@CXg
        nFlist,Xg̐
    uTimeLimit,^掞
      fMessage,TRUE:bZ[W{bNX,FALSE:bZ[W{bNXȂ
           RET,TRUE:I,FALSE:G[                                   */
BOOL
CaptureFile (LPPROPERTY lpProp,
             LPFILELIST lpFlist,
             int        nFlist,
             UINT       uTimeLimit,
             BOOL       fMessage)
{
  int i;
  BOOL fTime;
  HMENU hMenu;
  UINT uTime;

  /* ja:mF̃_CAO */
  if (fMessage)
    {
      if (fMakeUserHitOKToCapture
                    && MessageBox (hWndMain, LoadText (hInst, IDS_CAP_START),
                        APPLICATION, MB_OKCANCEL | MB_ICONINFORMATION) != IDOK)
        return TRUE;
      MemoryFree (lpszWarning);
      lpszWarning = NULL;
    }

  /* ja:j[ */
  hMenu = GetMenu (hWndMain);
  if (!hMenu)
    {
      AddWarning (_T("GetMenu"));
      goto loop;
    }
  if (EnableMenuItem (hMenu, 0, MF_BYPOSITION | MF_GRAYED) == 0xffffffff
        || EnableMenuItem (hMenu, 1, MF_BYPOSITION | MF_GRAYED) == 0xffffffff
        || EnableMenuItem (hMenu, 2, MF_BYPOSITION | MF_GRAYED) == 0xffffffff
        || EnableMenuItem (hMenu, 3, MF_BYPOSITION | MF_GRAYED) == 0xffffffff
        || EnableMenuItem (hMenu, 4, MF_BYPOSITION | MF_GRAYED) == 0xffffffff)
    {
      AddWarning (_T("EnableMenuItem"));
      goto loop;
    }
  if (!SendMessage (hWndTool, TB_ENABLEBUTTON, CM_SAVE, FALSE)
            || !SendMessage (hWndTool, TB_ENABLEBUTTON, CM_PROPERTY, FALSE)
            || !SendMessage (hWndTool, TB_ENABLEBUTTON, CM_CAPTURE, FALSE)
            || !SendMessage (hWndTool, TB_ENABLEBUTTON, CM_FRAME, FALSE)
            || !SendMessage (hWndTool, TB_ENABLEBUTTON, CM_COPY, FALSE))
    {
      AddWarning (_T("TB_ENABLEBUTTON"));
      goto loop;
    }
  /* ja:j[XV */
  if (!DrawMenuBar (hWndMain))
    {
      AddWarning (_T("DrawMenuBar"));
      goto loop;
    }
  if (fRecycle)
    for (i = 0; i < nFlist; i++)
      if (IsFile (lpFlist[i].szFile))
        {
          SHFILEOPSTRUCT shfo;
          TCHAR szFile[MAXPATH + 1];

          lstrcpy (szFile, lpFlist[i].szFile);
          /* ja:Ƀt@C鎞ݔɎ̂Ă */
          MemorySet (&shfo, 0, sizeof (SHFILEOPSTRUCT));
          szFile[lstrlen (szFile) + 1] = '\0';
          shfo.hwnd = hWndMain;
          shfo.wFunc = FO_DELETE;
          shfo.pFrom = szFile;
          shfo.fFlags = FOF_ALLOWUNDO | FOF_NOCONFIRMATION
                                                | FOF_NOERRORUI | FOF_SILENT;
          SHFileOperation (&shfo);
        }
  fTime = cparam.fLimitEnabled;
  uTime = cparam.wTimeLimit;
  /* ja:Lv`p[^̐ݒ */
  cparam.dwRequestMicroSecPerFrame = 1000000000 / lpProp->dwRate;
  cparam.fCaptureAudio = lpProp->fAudio;
  if (uTimeLimit != 0)
    {
      cparam.fLimitEnabled = TRUE;
      cparam.wTimeLimit = uTimeLimit;
    }
  if (!capCaptureSetSetup (hWndCap, &cparam, sizeof (CAPTUREPARMS)))
    {
      AddWarning (_T("capCaptureSetSetup"));
      goto loop;
    }
  /* ja:I[fBIk̐ݒ */
  if (lpProp->fAudio && !capSetAudioFormat (hWndCap, lpProp->lpWfx,
                                lpProp->lpWfx->cbSize + sizeof(WAVEFORMATEX)))
    {
      AddWarning (_T("capSetAudioFormat"));
      goto loop;
    }
  fControl = TRUE;
  switch (lpProp->uFormat)
    {
      case 0:/* ja:AVI */
        CaptureStd (lpFlist->szFile);
        break;
      case 1:/* en:AVI */
        CaptureAVI (lpProp, lpFlist, nFlist);
        break;
      case 2:/* en:GtkShot Raw */
        CaptureGSR (lpProp, lpFlist, nFlist);
        break;
      default:/* en:DEBUG */
        CaptureDebug (lpProp, lpFlist, nFlist);
    }
  fControl = FALSE;
  cparam.fLimitEnabled = fTime;
  cparam.wTimeLimit = uTime;
  loop:
  if (hMenu
      && (EnableMenuItem (hMenu, 0, MF_BYPOSITION | MF_ENABLED) == 0xffffffff
      ||  EnableMenuItem (hMenu, 1, MF_BYPOSITION | MF_ENABLED) == 0xffffffff
      ||  EnableMenuItem (hMenu, 2, MF_BYPOSITION | MF_ENABLED) == 0xffffffff
      ||  EnableMenuItem (hMenu, 3, MF_BYPOSITION | MF_ENABLED) == 0xffffffff
      ||  EnableMenuItem (hMenu, 4, MF_BYPOSITION | MF_ENABLED) == 0xffffffff))
    AddWarning (_T("EnableMenuItem"));
  if (!SendMessage (hWndTool, TB_ENABLEBUTTON, CM_SAVE, TRUE)
            || !SendMessage (hWndTool, TB_ENABLEBUTTON, CM_PROPERTY, TRUE)
            || !SendMessage (hWndTool, TB_ENABLEBUTTON, CM_CAPTURE, TRUE)
            || !SendMessage (hWndTool, TB_ENABLEBUTTON, CM_FRAME, TRUE)
            || !SendMessage (hWndTool, TB_ENABLEBUTTON, CM_COPY, TRUE))
    AddWarning (_T("TB_ENABLEBUTTON"));
  /* ja:j[XV */
  if (!DrawMenuBar (hWndMain))
    AddWarning (_T("DrawMenuBar"));
  if (fMessage && lpszWarning)
    {
      DialogBoxGUI (hInst, MAKEINTRESOURCE (DIALOG_7), hWndMain, ErrorDlgProc);
      MemoryFree (lpszWarning);
      lpszWarning = NULL;
    }
  return TRUE;
}
