/*
    GtkShot for Windows
    copyright (c) 1998-2006 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#include "bmmacro.h"
#include "capgsr.h"
#include "general.h"
#include "memapi.h"
#include "other.h"
#include "resource.h"
#include <commctrl.h>
#include <tchar.h>


/******************************************************************************
*                                                                             *
* ja:GtkShot Raw֐Q                                                        *
*                                                                             *
******************************************************************************/
#define GSR_STREAM_VIDEO 0
#define GSR_STREAM_AUDIO 1
#define GSR_IF_KEYFRAME  1


static LPTSTR lpszError; /* ja:G[bZ[W */


/*  ja:GtkShot Raw̍\
 0 4 'G','S','R','\0'
 4 4 tO
 8 4 Xg[̐

 0 4 Xg[̎
 4 4 }CNb̃t[(I[fBI0)
 8 4 nh[(I[fBI0)
12 4 CfbNX̐
16 8 CfbNX̃ItZbg
24 4 tH[}bg̃oCg
28 ? tH[}bg
*/
static LRESULT CALLBACK
GsrVideoCallbackProc (HWND      hWnd,
                     LPVIDEOHDR lpVHdr)
{
  int i, nNull, nDelta, nBuffer;
  BOOL fKey;
  DWORD dwSize, dwWrite;
  LONG lSize;
  LPFILELIST lpFList;
  LPVOID lpBits;
  TCHAR szText[128];

  if (!capGetStatus (hWndCap, &cstat, sizeof (CAPSTATUS)))
    {
      fControl = FALSE;
      lpszError = _T("capGetStatus");
      return FALSE;
    }
  lpFList = stVsCap.lpFileList + stVsCap.nList;
  if (lpVHdr->dwBytesUsed == 0 || !fControl
                || lpFList->dwVideo == 0 && !(lpVHdr->dwFlags & VHDR_KEYFRAME))
    return FALSE;
  if (lpFList->dwVideo > 0 && (nDelta = MulDiv (lpVHdr->dwTimeCaptured, 1000,
                cparam.dwRequestMicroSecPerFrame) - stVsCap.dwFrame - 1) > 0)
    {
      /* ja:Ƃkt[} */
      nNull = max(
                min(
                  nDelta,
                  (lpFList->uiBytes - lpFList->uiOffset
                                        - (lpFList->dwVideo + lpFList->dwIndex)
                                    * sizeof (GSRINDEX)) / sizeof (GSRINDEX)
                ),
                0
              );
      /* ja:kt[ǉ */
      if (lpFList->dwVideo % 65536 + nNull >= 65535
                && !(lpFList->lpGsrIdxV = MemoryReAlloc (lpFList->lpGsrIdxV,
                            (lpFList->dwVideo + 65537) * sizeof (GSRINDEX))))
        {
          fControl = FALSE;
          lpszError = _T("MemoryReAlloc");
          return FALSE;
        }
      for (i = 0; i < nNull; i++)
        {
          lpFList->lpGsrIdxV[lpFList->dwVideo].uiOffset = 0;
          lpFList->lpGsrIdxV[lpFList->dwVideo].dwSize = 0;
          lpFList->lpGsrIdxV[lpFList->dwVideo].dwFlags = 0;
          lpFList->dwVideo++;
        }
      stVsCap.dwDrop += nNull;
      stVsCap.dwFrame += nNull;
    }
  if (stVsCap.cv.cbSize > 0)
    {
      /* ja:\tgEFAk */
      lSize = 0;
      lpBits = ICSeqCompressFrame (&stVsCap.cv, 0,
                                                lpVHdr->lpData, &fKey, &lSize);
      if (!lpBits)
        {
          fControl = FALSE;
          lpszError = _T("ICSeqCompressFrame");
          return FALSE;
        }
    }
  else if (stVsCap.cv.hic)
    {
      /* ja:k */
      if (ICDecompress (stVsCap.cv.hic,
                lpVHdr->dwFlags & VHDR_KEYFRAME ? ICDECOMPRESS_NOTKEYFRAME : 0,
                        (LPBITMAPINFOHEADER)stVsCap.lpBmiIn, lpVHdr->lpData,
            (LPBITMAPINFOHEADER)stVsCap.lpBmiOut, stVsCap.lpBits) != ICERR_OK)
        {
          fControl = FALSE;
          lpszError = _T("ICDecompress");
          return FALSE;
        }
      lpBits = stVsCap.lpBits;
      lSize = stVsCap.nImgByte;
      fKey = TRUE;
    }
  else
    {
      /* ja:\tgEFAkȂ */
      lpBits = lpVHdr->lpData;
      lSize = lpVHdr->dwBytesUsed;
      fKey = lpVHdr->dwFlags & VHDR_KEYFRAME;
    }
  /* ja:݂̏ŋK̃TCY𒴂邩`FbN */
  if (lpFList->uiOffset + lSize + (lpFList->dwVideo + lpFList->dwIndex + 1)
                                        * sizeof (GSRINDEX) > lpFList->uiBytes)
    {
      if (stVsCap.cv.cbSize > 0)
        {
          ICSeqCompressFrameEnd (&stVsCap.cv);
          if (!ICSeqCompressFrameStart (&stVsCap.cv, stVsCap.lpBmiIn))
            {
              fControl = FALSE;
              lpszError = LoadText (hInst, IDS_VCM_START);
              return FALSE;
            }
          lSize = 0;
          lpBits = ICSeqCompressFrame (&stVsCap.cv, 0,
                                                lpVHdr->lpData, &fKey,&lSize);
          if (!lpBits)
            {
              fControl = FALSE;
              lpszError = _T("ICSeqCompressFrame");
              return FALSE;
            }
        }
      do
        {
          stVsCap.nList++;
          if (stVsCap.nFileList <= stVsCap.nList)
            {
              fControl = FALSE;
              return FALSE;
            }
          lpFList++;
        }
      while (lpFList->uiOffset + lSize
                + (lpFList->dwVideo + lpFList->dwIndex + 1) * sizeof (GSRINDEX)
                                                        > lpFList->uiBytes);
    }
  /* ja:Kvȃobt@̃TCY */
  dwSize = (lpFList->dwOffset + lSize) / lpFList->dwBase * lpFList->dwBase;
  if (lpFList->dwData < dwSize + lpFList->dwBase
                        && !AllocBuffer (lpFList, dwSize + lpFList->dwBase))
    return FALSE;
  if (lpFList->dwOffset < dwSize)
    {
      /* ja:ACgꂽ]/ */
      nBuffer = min (dwSize - lpFList->dwOffset, lSize);
      MemoryCopy (lpFList->lpbData + lpFList->dwOffset, lpBits, nBuffer);
      if (!WriteFile (lpFList->hFile, lpFList->lpbData, dwSize, &dwWrite, NULL)
                                                        || dwSize != dwWrite)
        {
          fControl = FALSE;
          lpszError = LoadText (hInst, IDS_FILE_WRITE);
          return FALSE;
        }
      /* ja:cZoăobt@ɕۑ */
      nBuffer = lSize - nBuffer;
      if (nBuffer > 0)
        {
          MemoryCopy (lpFList->lpbData, (LPBYTE)lpBits + lSize - nBuffer,
                                                                    nBuffer);
          lpFList->dwOffset = nBuffer;
        }
      else
        {
          lpFList->dwOffset = 0;
        }
    }
  else
    {
      /* ja:ɏݗ\ʂ𒴂Ă */
      if (dwSize > 0)
        {
          if (!WriteFile (lpFList->hFile, lpFList->lpbData,
                                                        dwSize, &dwWrite, NULL)
                                                        || dwSize != dwWrite)
            {
              fControl = FALSE;
              lpszError = LoadText (hInst, IDS_FILE_WRITE);
              return FALSE;
            }
          nBuffer = lpFList->dwOffset - dwSize;
          MemoryCopy (lpFList->lpbData, lpFList->lpbData + dwSize, nBuffer);
          lpFList->dwOffset = nBuffer;
        }
      MemoryCopy (lpFList->lpbData + lpFList->dwOffset, lpBits, lSize);
      lpFList->dwOffset += lSize;
    }
  /* ja:CfbNXݒ肷 */
  if (lpFList->dwVideo % 65536 == 65535
                && !(lpFList->lpGsrIdxV = MemoryReAlloc (lpFList->lpGsrIdxV,
                            (lpFList->dwVideo + 65537) * sizeof (GSRINDEX))))
    {
      fControl = FALSE;
      lpszError = _T("MemoryReAlloc");
      return FALSE;
    }
  lpFList->lpGsrIdxV[lpFList->dwVideo].uiOffset = lpFList->uiOffset;
  lpFList->lpGsrIdxV[lpFList->dwVideo].dwSize = lSize;
  lpFList->lpGsrIdxV[lpFList->dwVideo].dwFlags = fKey ? GSR_IF_KEYFRAME : 0;
  lpFList->uiOffset += lSize;
  lpFList->dwVideo++;

  wsprintf (szText, szFrameFormat, stVsCap.dwFrame++,
        lpVHdr->dwTimeCaptured / (60 * 60 * 1000),
        lpVHdr->dwTimeCaptured / (60 * 1000) % 60,
        lpVHdr->dwTimeCaptured / 1000 % 60, stVsCap.dwDrop, stVsCap.nList + 1);
  SendMessage (hWndStat, SB_SETTEXT, 0, (LPARAM)szText);

  return TRUE;
}


static LRESULT CALLBACK
GsrWaveCallbackProc (HWND      hWnd,
                     LPWAVEHDR lpWHdr)
{
  int nBuffer;
  DWORD dwSize, dwWrite;
  LPFILELIST lpFList;

  if (lpWHdr->dwBytesRecorded == 0 || !fControl
                                        || stVsCap.nFileList <= stVsCap.nList)
    return FALSE;
  lpFList = stVsCap.lpFileList + stVsCap.nList;
  /* ja:݂̏ŋK̃TCY𒴂邩`FbN */
  if (lpFList->uiOffset + lpWHdr->dwBytesRecorded
                                    + (lpFList->dwVideo + lpFList->dwIndex + 1)
                                        * sizeof (GSRINDEX) > lpFList->uiBytes)
    {
      if (stVsCap.cv.cbSize > 0)
        {
          ICSeqCompressFrameEnd (&stVsCap.cv);
          if (!ICSeqCompressFrameStart (&stVsCap.cv, stVsCap.lpBmiIn))
            {
              fControl = FALSE;
              lpszError = LoadText (hInst, IDS_VCM_START);
              return FALSE;
            }
        }
      do
        {
          stVsCap.nList++;
          if (stVsCap.nFileList <= stVsCap.nList)
            {
              fControl = FALSE;
              return FALSE;
            }
          lpFList++;
        }
      while (lpFList->uiOffset + lpWHdr->dwBytesRecorded
                                    + (lpFList->dwVideo + lpFList->dwIndex + 1)
                                    * sizeof (GSRINDEX) > lpFList->uiBytes);
    }
  /* ja:Kvȃobt@̃TCY */
  dwSize = (lpFList->dwOffset + lpWHdr->dwBytesRecorded)
                                        / lpFList->dwBase * lpFList->dwBase;
  if (lpFList->dwData < dwSize + lpFList->dwBase
                        && !AllocBuffer (lpFList, dwSize + lpFList->dwBase))
    return FALSE;
  if (lpFList->dwOffset < dwSize)
    {
      /* ja:ACgꂽ]/ */
      nBuffer = min (dwSize - lpFList->dwOffset, lpWHdr->dwBytesRecorded);
      MemoryCopy (lpFList->lpbData + lpFList->dwOffset, lpWHdr->lpData,
                                                                    nBuffer);
      if (!WriteFile (lpFList->hFile, lpFList->lpbData, dwSize, &dwWrite, NULL)
                                                        || dwSize != dwWrite)
        {
          fControl = FALSE;
          lpszError = LoadText (hInst, IDS_FILE_WRITE);
          return FALSE;
        }
      /* ja:cZoăobt@ɕۑ */
      nBuffer = lpWHdr->dwBytesRecorded - nBuffer;
      if (nBuffer > 0)
        {
          MemoryCopy (lpFList->lpbData, (LPBYTE)lpWHdr->lpData
                                + lpWHdr->dwBytesRecorded - nBuffer, nBuffer);
          lpFList->dwOffset = nBuffer;
        }
      else
        {
          lpFList->dwOffset = 0;
        }
    }
  else
    {
      /* ja:`NIDŊɏݗ\ʂ𒴂Ă */
      if (dwSize > 0)
        {
          if (!WriteFile (lpFList->hFile, lpFList->lpbData,
                                                        dwSize, &dwWrite, NULL)
                                                        || dwSize != dwWrite)
            {
              fControl = FALSE;
              lpszError = LoadText (hInst, IDS_FILE_WRITE);
              return FALSE;
            }
          nBuffer = lpFList->dwOffset - dwSize;
          MemoryCopy (lpFList->lpbData, lpFList->lpbData + dwSize, nBuffer);
          lpFList->dwOffset = nBuffer;
        }
      MemoryCopy (lpFList->lpbData + lpFList->dwOffset, lpWHdr->lpData,
                                                    lpWHdr->dwBytesRecorded);
      lpFList->dwOffset += lpWHdr->dwBytesRecorded;
    }
  if (lpFList->dwIndex % 65536 == 65535
                && !(lpFList->lpGsrIdxW = MemoryReAlloc (lpFList->lpGsrIdxW,
                            (lpFList->dwIndex + 65537) * sizeof (GSRINDEX))))
    {
      fControl = FALSE;
      lpszError = _T("MemoryReAlloc");
      return FALSE;
    }
  lpFList->lpGsrIdxW[lpFList->dwIndex].uiOffset = lpFList->uiOffset;
  lpFList->lpGsrIdxW[lpFList->dwIndex].dwSize = lpWHdr->dwBytesRecorded;
  lpFList->lpGsrIdxW[lpFList->dwIndex].dwFlags = 0;
  lpFList->uiOffset += lpWHdr->dwBytesRecorded;
  lpFList->dwWave += lpWHdr->dwBytesRecorded
                                        / stVsCap.lpProp->lpWfx->nBlockAlign;
  lpFList->dwIndex++;
  return TRUE;
}


/*  ja:GtkShot RawŃLv`
     lpProp,vpeB
    lpFList,t@C̃Xg
     nFList,t@C̃Xg
        RET,TRUE:I,FALSE:G[                                      */
BOOL
CaptureGSR (LPPROPERTY lpProp,
            LPFILELIST lpFList,
            int        nFList)
{
  int i;
  DWORD dwMicroSecPerFrame;
  DWORD dwHeader;       /* ja:wb^̍ŒoCg */
  DWORD dwSize;         /* ja:Ōɏރobt@̃TCY */
  DWORD dwVideo;        /* ja:rfĨtH[}bg̃oCg */
  DWORD dwWave;         /* ja:I[fBĨtH[}bg̃oCg */
  DWORD dwAllW;         /* ja:ׂẴI[fBĨTv */
  DWORD dwWrite;

  MemorySet (&stVsCap, 0, sizeof (VSCAPTURE));

  /* ja:wb^擾 */
  dwVideo = capGetVideoFormatSize (hWndCap);
  if (dwVideo == 0)
    {
      AddWarning (_T("capGetVideoFormatSize"));
      return FALSE;
    }
  /* ja:rfItH[}bg */
  stVsCap.lpBmiOut = MemoryAlloc (dwVideo);
  if (!stVsCap.lpBmiOut)
    {
      AddWarning (_T("MemoryAlloc"));
      return FALSE;
    }
  if (capGetVideoFormat (hWndCap, stVsCap.lpBmiOut, dwVideo) == 0)
    {
      AddWarning (_T("capGetVideoFormat"));
      MemoryFree (stVsCap.lpBmiOut);
      return FALSE;
    }
  dwWave = cparam.fCaptureAudio ? lpProp->lpWfx->cbSize + sizeof (WAVEFORMATEX)
                                : 0;

  /* ja:k */
  if (lpProp->fccHandler == comptypeDIB)
    {
      /* ja:k */
      stVsCap.lpBmiIn = stVsCap.lpBmiOut;
      if (!(stVsCap.cv.hic = ICOpen (ICTYPE_VIDEO,
                                    stVsCap.lpBmiIn->bmiHeader.biCompression,
                                            ICMODE_FASTDECOMPRESS))
                && !(stVsCap.cv.hic = ICOpen (ICTYPE_VIDEO,
                                    stVsCap.lpBmiIn->bmiHeader.biCompression,
                                            ICMODE_DECOMPRESS)))
        {
          AddWarning (LoadText (hInst, IDS_VCM_OPEN));
          MemoryFree (stVsCap.lpBmiIn);
          return FALSE;
        }
      /* ja:VCMgWJ̃tH[}bg擾 */
      dwVideo = ICDecompressGetFormatSize (stVsCap.cv.hic, stVsCap.lpBmiIn);
      if (dwVideo <= 0)
        {
          AddWarning (LoadText (hInst, IDS_VCM_START));
          ICClose (stVsCap.cv.hic);
          MemoryFree (stVsCap.lpBmiIn);
          return FALSE;
        }
      stVsCap.lpBmiOut = MemoryAlloc (dwVideo);
      if (!stVsCap.lpBmiOut)
        {
          AddWarning (_T("MemoryAlloc"));
          ICClose (stVsCap.cv.hic);
          MemoryFree (stVsCap.lpBmiIn);
          return FALSE;
        }
      if (ICDecompressGetFormat (stVsCap.cv.hic,
                                stVsCap.lpBmiIn, stVsCap.lpBmiOut) != ICERR_OK
                || ICDecompressBegin (stVsCap.cv.hic,
                                stVsCap.lpBmiIn, stVsCap.lpBmiOut) != ICERR_OK)
        {
          AddWarning (LoadText (hInst, IDS_VCM_START));
          ICDecompressEnd (stVsCap.cv.hic);
          ICClose (stVsCap.cv.hic);
          MemoryFree (stVsCap.lpBmiIn);
          MemoryFree (stVsCap.lpBmiOut);
          return FALSE;
        }
      stVsCap.nImgByte = bmImgByte ((LPBITMAPINFOHEADER)stVsCap.lpBmiOut);
      stVsCap.lpBits = MemoryAlloc (stVsCap.nImgByte);
      if (!stVsCap.lpBits)
        {
          AddWarning (_T("MemoryAlloc"));
          ICDecompressEnd (stVsCap.cv.hic);
          ICClose (stVsCap.cv.hic);
          MemoryFree (stVsCap.lpBmiIn);
          MemoryFree (stVsCap.lpBmiOut);
          MemoryFree (stVsCap.lpBits);
          return FALSE;
        }
    }
  else if (lpProp->fccHandler != 0)
    {
      /* ja:Ĉk */
      stVsCap.lpBmiIn = stVsCap.lpBmiOut;
      stVsCap.cv.cbSize = sizeof (COMPVARS);
      stVsCap.cv.fccHandler = lpProp->fccHandler;
      stVsCap.cv.lpbiOut = lpProp->lpBmiOut;
      stVsCap.cv.lKey = lpProp->lKey;
      stVsCap.cv.lDataRate = lpProp->lDataRate;
      stVsCap.cv.lQ = lpProp->lQ;
      stVsCap.cv.lpState = lpProp->lpState;
      stVsCap.cv.cbState = lpProp->cbState;
      if (!(stVsCap.cv.hic = ICOpen (ICTYPE_VIDEO, stVsCap.cv.fccHandler,
                                                ICMODE_FASTCOMPRESS))
            && !(stVsCap.cv.hic = ICOpen (ICTYPE_VIDEO, stVsCap.cv.fccHandler,
                                                ICMODE_COMPRESS)))
        {
          AddWarning (LoadText (hInst, IDS_VCM_OPEN));
          MemoryFree (stVsCap.lpBmiIn);
          return FALSE;
        }
      if (!ICSeqCompressFrameStart (&stVsCap.cv,stVsCap.lpBmiIn))
        {
          AddWarning (LoadText (hInst, IDS_VCM_START));
          ICClose (stVsCap.cv.hic);
          MemoryFree (stVsCap.lpBmiIn);
          return FALSE;
        }
      if (lpProp->lpBmiOut)
        {
          dwVideo = bmHdrByte ((LPBITMAPINFOHEADER)lpProp->lpBmiOut);
          stVsCap.lpBmiOut = MemoryAlloc (dwVideo);
          if (!stVsCap.lpBmiOut)
            {
              AddWarning (_T("MemoryAlloc"));
              ICSeqCompressFrameEnd (&stVsCap.cv);
              ICClose (stVsCap.cv.hic);
              MemoryFree (stVsCap.lpBmiIn);
              return FALSE;
            }
          MemoryCopy (stVsCap.lpBmiOut, lpProp->lpBmiOut, dwVideo);
        }
      else
        {
          stVsCap.lpBmiOut = MemoryAlloc (dwVideo);
          if (!stVsCap.lpBmiOut)
            {
              AddWarning (_T("MemoryAlloc"));
              ICSeqCompressFrameEnd (&stVsCap.cv);
              ICClose (stVsCap.cv.hic);
              MemoryFree (stVsCap.lpBmiIn);
              return FALSE;
            }
          MemoryCopy (stVsCap.lpBmiOut, stVsCap.lpBmiIn, dwVideo);
        }
    }

  /* ja:wb^TCYvZ */
  dwHeader = sizeof (BYTE) * 4              /* en:'GSR' */
            + sizeof (DWORD)                /* ja:tO */
            + sizeof (DWORD)                /* ja:Xg[ */
            + sizeof (DWORD)                /* ja:Xg[̎ */
            + sizeof (DWORD)                /* ja:t[/}CNb */
            + sizeof (FOURCC)               /* ja:nh[ */
            + sizeof (DWORD)                /* ja:CfbNX̐ */
            + sizeof (UINT64)               /* ja:CfbNX̃ItZbg */
            + sizeof (DWORD)                /* ja:tH[}bg̃oCg */
            + dwVideo                       /* ja:tH[}bg */
            + (dwWave > 0 ?
              sizeof (DWORD)                /* ja:Xg[̎ */
              + sizeof (DWORD)              /* ja:t[/}CNb */
              + sizeof (FOURCC)             /* ja:nh[ */
              + sizeof (DWORD)              /* ja:CfbNX̐ */
              + sizeof (UINT64)             /* ja:CfbNX̃ItZbg */
              + sizeof (DWORD)              /* ja:tH[}bg̃oCg */
              + dwWave                      /* ja:tH[}bg */
            : 0);

  /* ja:t@CJ */
  for (i = 0; i < nFList; i++)
    {
      DWORD dwSectorsPerCluster;
      DWORD dwNumberOfFreeClusters;
      DWORD dwTotalNumberOfClusters;
      TCHAR szFile[MAXPATH];
      FNDIR fd;

      /* ja:hCu1ZN^̃oCg擾 */
      SplitFileName (lpFList[i].szFile, &fd);
      lstrcpy (szFile, fd.szDrive);
      lstrcat (szFile, _T("\\"));
      lpFList[i].dwBase = AVI_HEADERSIZE;
      if (!GetDiskFreeSpace (szFile, &dwSectorsPerCluster, &lpFList[i].dwBase,
                        &dwNumberOfFreeClusters, &dwTotalNumberOfClusters))
        {
          AddWarning (_T("GetDiskFreeSpace"));
          while (i > 0)
            {
              --i;
              CloseHandle (lpFList[i].hFile);
              DeleteFile (lpFList[i].szFile);
              MemoryFree (lpFList[i].lpAviIdx);
              MemoryFree (lpFList[i].lpbMemory);
            }
          if (lpProp->fccHandler == comptypeDIB)
            ICDecompressEnd (stVsCap.cv.hic);
          else if (lpProp->fccHandler != 0)
            ICSeqCompressFrameEnd (&stVsCap.cv);
          if (stVsCap.cv.hic)
            ICClose (stVsCap.cv.hic);
          MemoryFree (stVsCap.lpBmiIn);
          MemoryFree (stVsCap.lpBmiOut);
          MemoryFree (stVsCap.lpBits);
          return FALSE;
        }
      lpFList[i].hFile = CreateFile (lpFList[i].szFile, GENERIC_WRITE,
                        FILE_SHARE_READ, NULL, OPEN_ALWAYS,
                        FILE_ATTRIBUTE_NORMAL | FILE_FLAG_NO_BUFFERING, NULL);
      if (lpFList[i].hFile == INVALID_HANDLE_VALUE)
        {
          AddWarning (LoadText (hInst, IDS_FILE_OPEN));
          while (i > 0)
            {
              --i;
              CloseHandle (lpFList[i].hFile);
              DeleteFile (lpFList[i].szFile);
              MemoryFree (lpFList[i].lpAviIdx);
              MemoryFree (lpFList[i].lpbMemory);
            }
          if (lpProp->fccHandler == comptypeDIB)
            ICDecompressEnd (stVsCap.cv.hic);
          else if (lpProp->fccHandler != 0)
            ICSeqCompressFrameEnd (&stVsCap.cv);
          if (stVsCap.cv.hic)
            ICClose (stVsCap.cv.hic);
          MemoryFree (stVsCap.lpBmiIn);
          MemoryFree (stVsCap.lpBmiOut);
          MemoryFree (stVsCap.lpBits);
          return FALSE;
        }
      lpFList[i].uiOffset = (dwHeader / lpFList[i].dwBase + 1)
                                                        * lpFList[i].dwBase;
      if (SetFilePointer (lpFList[i].hFile, (LONG)lpFList[i].uiOffset, NULL,
                                                    FILE_BEGIN)==0xffffffff)
        {
          AddWarning (_T("SetFilePointer"));
          lpFList[i].lpAviIdx = NULL;
          lpFList[i].lpbMemory = NULL;
          while (i >= 0)
            {
              CloseHandle (lpFList[i].hFile);
              DeleteFile (lpFList[i].szFile);
              MemoryFree (lpFList[i].lpAviIdx);
              MemoryFree (lpFList[i].lpbMemory);
              i--;
            }
          if (lpProp->fccHandler == comptypeDIB)
            ICDecompressEnd (stVsCap.cv.hic);
          else if (lpProp->fccHandler != 0)
            ICSeqCompressFrameEnd (&stVsCap.cv);
          if (stVsCap.cv.hic)
            ICClose (stVsCap.cv.hic);
          MemoryFree (stVsCap.lpBmiIn);
          MemoryFree (stVsCap.lpBmiOut);
          MemoryFree (stVsCap.lpBits);
          return FALSE;
        }
      /* ja:obt@mۂ */
      lpFList[i].dwData = (max (dwHeader, 1024 * 1024) / lpFList[i].dwBase + 1)
                                                        * lpFList[i].dwBase;
      lpFList[i].dwMemory = lpFList[i].dwData + lpFList[i].dwBase;
      lpFList[i].lpbMemory = NULL;
      lpFList[i].lpGsrIdxV = MemoryAlloc (sizeof (GSRINDEX) * 65536);
      lpFList[i].lpGsrIdxW = MemoryAlloc (sizeof (GSRINDEX) * 65536);
      lpFList[i].lpbMemory = MemoryAlloc (lpFList[i].dwMemory);
      if (!lpFList[i].lpGsrIdxV || !lpFList[i].lpGsrIdxW
                                                    || !lpFList[i].lpbMemory)
        {
          AddWarning (_T("MemoryAlloc"));
          while (i >= 0)
            {
              CloseHandle (lpFList[i].hFile);
              DeleteFile (lpFList[i].szFile);
              MemoryFree (lpFList[i].lpGsrIdxV);
              MemoryFree (lpFList[i].lpGsrIdxW);
              MemoryFree (lpFList[i].lpbMemory);
              i--;
            }
          if (lpProp->fccHandler == comptypeDIB)
            ICDecompressEnd (stVsCap.cv.hic);
          else if (lpProp->fccHandler != 0)
            ICSeqCompressFrameEnd (&stVsCap.cv);
          if (stVsCap.cv.hic)
            ICClose (stVsCap.cv.hic);
          MemoryFree (stVsCap.lpBmiIn);
          MemoryFree (stVsCap.lpBmiOut);
          MemoryFree (stVsCap.lpBits);
          return FALSE;
        }
      lpFList[i].lpbData = (LPBYTE)(((UINT)lpFList[i].lpbMemory
                                / lpFList[i].dwBase + 1) * lpFList[i].dwBase);
      lpFList[i].dwOffset = 0;
      lpFList[i].dwIndex = 0;
      lpFList[i].dwVideo = 0;
      lpFList[i].dwWave = 0;
    }

  lpszError = NULL;

  stVsCap.nList = 0;
  stVsCap.nFileList = nFList;
  stVsCap.lpFileList = lpFList;
  stVsCap.dwDrop = 0;
  stVsCap.dwFrame = 0;
  stVsCap.lpProp = lpProp;

  capSetCallbackOnVideoStream (hWndCap, GsrVideoCallbackProc);
  capSetCallbackOnWaveStream (hWndCap, GsrWaveCallbackProc);
  /* ja:Lv`s */
  capCaptureSequenceNoFile (hWndCap);

  /* ja:G[bZ[W\ */
  if (lpszError)
    AddWarning (lpszError);

  /* ja:k */
  if (lpProp->fccHandler == comptypeDIB)
    ICDecompressEnd (stVsCap.cv.hic);
  else if (lpProp->fccHandler != 0)
    ICSeqCompressFrameEnd (&stVsCap.cv);
  if (stVsCap.cv.hic)
    ICClose (stVsCap.cv.hic);
  MemoryFree (stVsCap.lpBmiIn);
  MemoryFree (stVsCap.lpBits);

  /* ja:ۂ̃[g߂ */
  dwMicroSecPerFrame = 0;
  dwAllW = 0;
  if (fRate && dwWave > 0)
    for (i = 0; i < nFList; i++)
      dwAllW += lpFList[i].dwWave;
  if (dwAllW > 0 && stVsCap.dwFrame > 0)/* ja:TEhɂ킹 */
    dwMicroSecPerFrame = (INT64)dwAllW * lpProp->lpWfx->nBlockAlign
                                                                * 1000 * 1000
                            / lpProp->lpWfx->nAvgBytesPerSec / stVsCap.dwFrame;
  if (dwMicroSecPerFrame == 0)/* ja:ۂ̃[gvZ */
    dwMicroSecPerFrame = MulDiv (cstat.dwCurrentTimeElapsedMS, 1000,
                cstat.dwCurrentVideoFrame
                + abs (stVsCap.dwDrop - cstat.dwCurrentVideoFramesDropped));
  if (dwMicroSecPerFrame == 0)/* ja:_l̗p */
    dwMicroSecPerFrame = cparam.dwRequestMicroSecPerFrame;

  /* ja:fobN */
  if (fDebug)
    {
      TCHAR szText[1024];

      wsprintf (szText, _T( "GtkShot Raw\n"
                            "IR:%s\n"
                            "v[g:%u,[g:%u\n"
                            ":%u\n"
                            "t[:%u,:%u(%u)\n"
                            "rfIobt@:%u,I[fBIobt@:%u"),
                        fControl ? _T("[U[") : _T("t@CTCY"),
                        cparam.dwRequestMicroSecPerFrame, dwMicroSecPerFrame,
                        cstat.dwCurrentTimeElapsedMS,
                        cstat.dwCurrentVideoFrame, stVsCap.dwDrop,
                        cstat.dwCurrentVideoFramesDropped,
                        cparam.wNumVideoRequested, cparam.wNumAudioRequested);
      AddWarning (szText);
    }

  /* ja:t@C */
  for (i = 0; i < nFList; i++)
    {
      if (lpFList[i].dwVideo > 0 && (dwWave == 0 || lpFList[i].dwWave > 0))
        {
          DWORD dwHead;         /* ja:wb^̃ACgꂽoCg */
          LPBYTE p;
          UINT64 uiVideo;       /* ja:rfĨCfbNX̃ItZbg */
          UINT64 uiWave;        /* ja:I[fBĨCfbNX̃ItZbg */

          /* ja:t@Cւ݂̏ */
          /* ja:CfbNX */
          dwHead = (dwHeader / lpFList[i].dwBase + 1) * lpFList[i].dwBase;
          /* ja:Kvȃobt@̃TCY */
          dwSize = ((lpFList[i].dwOffset
            + (lpFList[i].dwVideo + lpFList[i].dwIndex) * sizeof (GSRINDEX))
                                / lpFList[i].dwBase + 1) * lpFList[i].dwBase;
          if (lpFList[i].dwData < dwSize && !AllocBuffer (lpFList + i, dwSize))
            {
              CloseHandle (lpFList[i].hFile);
              MemoryFree (lpFList[i].lpGsrIdxV);
              MemoryFree (lpFList[i].lpGsrIdxW);
              continue;
            }
          uiVideo = lpFList[i].uiOffset;
          uiWave = uiVideo + lpFList[i].dwVideo * sizeof (GSRINDEX);
          MemoryCopy (lpFList[i].lpbData + lpFList[i].dwOffset,
                                    lpFList[i].lpGsrIdxV,
                                    lpFList[i].dwVideo * sizeof (GSRINDEX));
          lpFList[i].dwOffset += lpFList[i].dwVideo * sizeof (GSRINDEX);
          MemoryCopy (lpFList[i].lpbData + lpFList[i].dwOffset,
                                    lpFList[i].lpGsrIdxW,
                                    lpFList[i].dwIndex * sizeof (GSRINDEX));
          lpFList[i].dwOffset += lpFList[i].dwIndex * sizeof (GSRINDEX);
          MemorySet (lpFList[i].lpbData + lpFList[i].dwOffset, 0,
                                                dwSize - lpFList[i].dwOffset);
          if (!WriteFile (lpFList[i].hFile, lpFList[i].lpbData,
                                dwSize, &dwWrite, NULL) || dwSize != dwWrite)
            AddWarning (LoadText (hInst, IDS_FILE_WRITE));
          MemoryFree (lpFList[i].lpGsrIdxV);
          MemoryFree (lpFList[i].lpGsrIdxW);

          /* ja:t@CTCY */
          lpFList[i].uiOffset += (lpFList[i].dwVideo + lpFList[i].dwIndex)
                                                        * sizeof (GSRINDEX);

          if (!SetEndOfFile (lpFList[i].hFile))
            AddWarning (_T("SetEndOfFile"));
          if (SetFilePointer (lpFList[i].hFile, 0, NULL, FILE_BEGIN)
                                                                == 0xffffffff)
            AddWarning (_T("SetFilePointer"));

          /* ja:wb^ݒ肷 */
          p = lpFList[i].lpbData;
          MemorySet (p, 0, dwHead);
          *p++ = 'G';
          *p++ = 'S';
          *p++ = 'R';
          *p++ = '\0';                      /* en:'GSR' */
          *(LPDWORD)p = 0;
          ((LPDWORD)p)++;                   /* ja:tO */
          *(LPDWORD)p = dwWave > 0 ? 2 : 1;
          ((LPDWORD)p)++;                   /* ja:Xg[̐ */
          *(LPDWORD)p = GSR_STREAM_VIDEO;
          ((LPDWORD)p)++;                   /* ja:Xg[̎ */
          *(LPDWORD)p = dwMicroSecPerFrame;
          ((LPDWORD)p)++;                   /* ja:t[/}CNb */
          *(FOURCC *)p = stVsCap.cv.cbSize > 0 ? lpProp->fccHandler
                        : (stVsCap.lpBmiOut->bmiHeader.biCompression == BI_RGB
                || stVsCap.lpBmiOut->bmiHeader.biCompression == BI_BITFIELDS)
                    ? comptypeDIB : stVsCap.lpBmiOut->bmiHeader.biCompression;
          ((FOURCC *)p)++;                  /* ja:nh[ */
          *(LPDWORD)p = lpFList[i].dwVideo;
          ((LPDWORD)p)++;                   /* ja:CfbNX̐ */
          *(UINT64 *)p = uiVideo;
          ((UINT64 *)p)++;                  /* ja:CfbNX̃ItZbg */
          *(LPDWORD)p = dwVideo;
          ((LPDWORD)p)++;                   /* ja:tH[}bg̃oCg */
          MemoryCopy (p, stVsCap.lpBmiOut, dwVideo);
          p += dwVideo;                     /* ja:tH[}bg */
          if (dwWave > 0)
            {
              *(LPDWORD)p = GSR_STREAM_AUDIO;
              ((LPDWORD)p)++;               /* ja:Xg[̎ */
              *(LPDWORD)p = 0;
              ((LPDWORD)p)++;               /* ja:t[/}CNb */
              *(FOURCC *)p = 0;
              ((FOURCC *)p)++;              /* ja:nh[ */
              *(LPDWORD)p = lpFList[i].dwIndex;
              ((LPDWORD)p)++;               /* ja:CfbNX̐ */
              *(UINT64 *)p = uiWave;
              ((UINT64 *)p)++;              /* ja:CfbNX̃ItZbg */
              *(LPDWORD)p = dwWave;
              ((LPDWORD)p)++;               /* ja:tH[}bg̃oCg */
              MemoryCopy (p, lpProp->lpWfx, dwWave);
              p += dwWave;                  /* ja:tH[}bg */
            }
          if (!WriteFile (lpFList[i].hFile, lpFList[i].lpbData,
                                dwHead, &dwWrite, NULL) || dwHead != dwWrite)
            AddWarning (LoadText (hInst, IDS_FILE_WRITE));
          if (!CloseHandle (lpFList[i].hFile))
            AddWarning (_T("CloseHandle"));

          /* ja:TCY𒲐 */
          lpFList[i].hFile = CreateFile (lpFList[i].szFile, GENERIC_WRITE,
                                        FILE_SHARE_READ, NULL, OPEN_EXISTING,
                                        FILE_ATTRIBUTE_NORMAL, NULL);
          if (lpFList[i].hFile != INVALID_HANDLE_VALUE)
            {
              LONG lMoveH, lMoveL;  /* ja:t@C|C^̈ړ */

              lMoveH = lpFList[i].uiOffset >> 32;
              lMoveL = lpFList[i].uiOffset;
              if (SetFilePointer (lpFList[i].hFile, lMoveL, &lMoveH,
                            FILE_BEGIN) == 0xffffffff && lMoveH == 0xffffffff)
                AddWarning (_T("SetFilePointer"));
              if (!SetEndOfFile (lpFList[i].hFile))
                AddWarning (_T("SetEndOfFile"));
              if (!CloseHandle (lpFList[i].hFile))
                AddWarning (_T("CloseHandle"));
            }
        }
      else
        {
          /* ja:t@CgȂ */
          if (!CloseHandle (lpFList[i].hFile))
            AddWarning (_T("CloseHandle"));
          if (!DeleteFile (lpFList[i].szFile))
            AddWarning (_T("DeleteFile"));
        }
      MemoryFree (lpFList[i].lpbMemory);
    }

  MemoryFree (stVsCap.lpBmiOut);

  return TRUE;
}
