/*
    GtkShot for Windows
    copyright (c) 1998-2006 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#include "capdbg.h"
#include "general.h"
#include "other.h"
#include "resource.h"
#include <commctrl.h>
#include <tchar.h>


/******************************************************************************
*                                                                             *
* ja:DEBUG֐Q                                                              *
*                                                                             *
******************************************************************************/
static LPTSTR lpszError; /* ja:G[bZ[W */


static LRESULT CALLBACK
DebugVideoCallbackProc (HWND       hWnd,
                        LPVIDEOHDR lpVHdr)
{
  DWORD dwWrite;
  TCHAR szText[1024];

  wsprintf (szText, _T( "Video : Frame:%08d "
                        "Time:%08d "
                        "Size:%08d "
                        "Flags:%08X\r\n"),
                        stVsCap.dwFrame,
                        lpVHdr->dwTimeCaptured,
                        lpVHdr->dwBytesUsed,
                        lpVHdr->dwFlags);
  if (!WriteFile (stVsCap.lpFileList->hFile,szText,
                                            lstrlen (szText), &dwWrite, NULL))
    {
      fControl = FALSE;
      lpszError = LoadText (hInst, IDS_FILE_WRITE);
      return FALSE;
    }
  wsprintf (szText, szFrameFormat,
                        stVsCap.dwFrame++, lpVHdr->dwTimeCaptured / 1000, 0);
  SendMessage (hWndStat, SB_SETTEXT, 0, (LPARAM)szText);
  return TRUE;
}


static LRESULT CALLBACK
DebugWaveCallbackProc (HWND     hWnd,
                      LPWAVEHDR lpWHdr)
{
  DWORD dwWrite;
  TCHAR szText[1024];

  if (!capGetStatus (hWndCap, &cstat, sizeof (CAPSTATUS)))
    {
      fControl = FALSE;
      lpszError = _T("capGetStatus");
      return FALSE;
    }
  wsprintf (szText, _T( "Audio : Frame:%08d "
                        "Time:%08d "
                        "Size:%08d "
                        "Flags:%08X\r\n"),
                        stVsCap.dwFrame,
                        0,
                        lpWHdr->dwBytesRecorded,
                        lpWHdr->dwFlags);
  if (!WriteFile (stVsCap.lpFileList->hFile, szText,
                                            lstrlen (szText), &dwWrite, NULL))
    {
      fControl = FALSE;
      lpszError = LoadText (hInst, IDS_FILE_WRITE);
      return FALSE;
    }
  return TRUE;
}


/*  ja:DEBUGŃLv`
     lpProp,vpeB
    lpFList,t@C̃Xg
     nFList,t@C̃Xg
        RET,TRUE:I,FALSE:G[                                      */
BOOL
CaptureDebug (LPPROPERTY lpProp,
              LPFILELIST lpFList,
              int        nFList)
{
  /* ja:t@CJ */
  lpFList->hFile = CreateFile (lpFList->szFile, GENERIC_WRITE,
                    FILE_SHARE_READ, NULL,OPEN_ALWAYS,
                    FILE_ATTRIBUTE_NORMAL | FILE_FLAG_SEQUENTIAL_SCAN, NULL);
  if (lpFList->hFile == INVALID_HANDLE_VALUE)
    {
      AddWarning (LoadText (hInst, IDS_FILE_OPEN));
      return FALSE;
    }
  lpszError = NULL;

  stVsCap.lpFileList = lpFList;
  stVsCap.dwFrame = 0;

  capSetCallbackOnVideoStream (hWndCap, DebugVideoCallbackProc);
  capSetCallbackOnWaveStream (hWndCap, DebugWaveCallbackProc);
  /* ja:Lv`s */
  capCaptureSequenceNoFile (hWndCap);

  /* ja:G[bZ[W\ */
  if (lpszError)
    AddWarning (lpszError);

  /* ja:t@C */
  if (!CloseHandle (lpFList->hFile))
    AddWarning (_T("CloseHandle"));

  return TRUE;
}
