/*
    GtkShot for Windows
    copyright (c) 1998-2006 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#include "callback.h"
#include "general.h"
#include "gshot.h"
#include <commctrl.h>


/******************************************************************************
*                                                                             *
* R[obN֐Q                                                          *
*                                                                             *
******************************************************************************/
LRESULT CALLBACK
ControlCallbackProc (HWND hWnd,
                     int  nState)
{
  return nState == CONTROLCALLBACK_CAPTURING ? fControl : TRUE;
}


LRESULT CALLBACK
ErrorCallbackProc (HWND    hWnd,
                   int     nID,
                   LPCTSTR lpszText)
{
  if (nID != 0)
    AddWarning (lpszText);
  return TRUE;
}


LRESULT CALLBACK
StatusCallbackProc (HWND    hWnd,
                    int     nID,
                    LPCTSTR lpszText)
{
  SendMessage (hWndStat, SB_SETTEXT, 0, (LPARAM)lpszText);
  return TRUE;
}


LRESULT CALLBACK
YieldCallbackProc (HWND hWnd)
{
  MSG msg;

  if (PeekMessage (&msg, NULL, WM_PAINT, WM_PAINT, PM_REMOVE))
    {
      TranslateMessage (&msg);
      DispatchMessage (&msg);
    }
  if (PeekMessage (&msg, NULL, WM_NCPAINT, WM_NCPAINT, PM_REMOVE))
    {
      TranslateMessage (&msg);
      DispatchMessage (&msg);
    }
  return TRUE;
}
