/*
    GtkShot for Windows
    copyright (c) 1998-2006 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#include "dialog.h"
#include "error.h"
#include "gshot.h"
#include "resource.h"
#include <tchar.h>


/******************************************************************************
*                                                                             *
* ja:_CAO֐Q                                                         *
*                                                                             *
******************************************************************************/
BOOL CALLBACK
ErrorDlgProc (HWND   hDlg,
              UINT   uMsg,
              WPARAM wParam,
              LPARAM lParam)
{
  static POINT ptMin;
  static DLGITEMPOSITION dipError[2] = {
                    {IDC_EDIT71, TRUE,  TRUE,  TRUE,  TRUE, 0, 0, 0, 0, 0, 0},
                    {IDCANCEL,   FALSE, FALSE, TRUE,  TRUE, 0, 0, 0, 0, 0, 0}};

  switch (uMsg)
    {
      case WM_INITDIALOG:
        {
          int x, y;
          RECT rc;

          /* ja:GfBgRg[̃eLXgݒ肷 */
          if (lpszWarning && !SetDlgItemText (hDlg, IDC_EDIT71, lpszWarning))
            {
              MessageBox (hDlg, _T("SetDlgItemText"),
                                APPLICATION, MB_OK | MB_ICONEXCLAMATION);
              EndDialog (hDlg, IDCANCEL);
              return TRUE;
            }
          /* ja:EChE̍ŏlۑ */
          if (!GetWindowRect (hDlg, &rc))
            {
              MessageBox (hDlg, _T("GetWindowRect"),
                                APPLICATION, MB_OK | MB_ICONEXCLAMATION);
              EndDialog (hDlg, IDCANCEL);
              return TRUE;
            }
          ptMin.x = rc.right - rc.left;
          ptMin.y = rc.bottom - rc.top;
          /* ja:ʒu */
          if (!InitDlgItemPosition (hDlg, dipError, 2))
            {
              EndDialog (hDlg, IDCANCEL);
              return TRUE;
            }
          /* ja:EChE𒆉ɕ\ */
          x = GetSystemMetrics (SM_CXSCREEN);
          y = GetSystemMetrics (SM_CYSCREEN);
          if (!SetWindowPos (hDlg, 0, x / 4, y / 4, x / 2, y / 2,
                                                                SWP_NOZORDER))
            {
              MessageBox (hDlg, _T("SetWindowPos"),
                                APPLICATION, MB_OK | MB_ICONEXCLAMATION);
              EndDialog (hDlg, IDCANCEL);
            }
        }
        return TRUE;
      case WM_GETMINMAXINFO:
        ((LPMINMAXINFO)lParam)->ptMinTrackSize = ptMin;
        return 0;
      case WM_SIZE:
        if (!SetDlgItemPosition (hDlg, dipError, 2))
          EndDialog (hDlg, IDCANCEL);
        return 0;
      case WM_COMMAND:
        if (LOWORD (wParam) == IDCANCEL)
          EndDialog (hDlg, IDCANCEL);
        return TRUE;
    }
  return FALSE;
}
