/*
    GtkShot for Windows
    copyright (c) 1998-2006 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#include "bmmacro.h"
#include "capavi.h"
#include "general.h"
#include "memapi.h"
#include "other.h"
#include "resource.h"
#include <aviriff.h>
#include <commctrl.h>
#include <tchar.h>


/******************************************************************************
*                                                                             *
* ja:AVI֐Q                                                                *
*                                                                             *
******************************************************************************/
static LPTSTR lpszError; /* ja:G[bZ[W */


static LRESULT CALLBACK
AviVideoCallbackProc (HWND       hWnd,
                      LPVIDEOHDR lpVHdr)
{
  int nDelta, nBuffer;
  BOOL fKey;
  DWORD dwSize, dwWrite;
  LONG lSize;
  LPFILELIST lpFList;
  LPVOID lpBits;
  TCHAR szText[128];

  if (!capGetStatus (hWndCap, &cstat, sizeof (CAPSTATUS)))
    {
      fControl = FALSE;
      lpszError = _T("capGetStatus");
      return FALSE;
    }
  lpFList = stVsCap.lpFileList + stVsCap.nList;
  if (lpVHdr->dwBytesUsed == 0 || !fControl
                || lpFList->dwVideo == 0 && !(lpVHdr->dwFlags & VHDR_KEYFRAME))
    return FALSE;
  if (lpFList->dwVideo > 0 && (nDelta = MulDiv (lpVHdr->dwTimeCaptured, 1000,
                cparam.dwRequestMicroSecPerFrame) - stVsCap.dwFrame - 1) > 0)
    {
      int i, nNull;
      RIFFCHUNK rcnk;

      /* ja:Ƃkt[} */
      nNull = max(
              min(
                min(
                  nDelta,
                  (lpFList->uiBytes - lpFList->uiOffset - sizeof (RIFFCHUNK)
                                - lpFList->dwIndex * sizeof (AVIINDEXENTRY))
                                / (sizeof (RIFFCHUNK) + sizeof (AVIINDEXENTRY))
                ),
                324000-lpFList->dwIndex
              ),
              0
              );
      /* ja:Kvȃobt@̃TCY */
      dwSize = lpFList->dwOffset + nNull * sizeof (RIFFCHUNK);
      if (lpFList->dwData < dwSize && !AllocBuffer (lpFList, dwSize))
        return FALSE;
      /* ja:`NID߂ */
      for (i = lpFList->dwIndex - 1; i >= 0; i--)
        if (StreamFromFOURCC (lpFList->lpAviIdx[i].ckid) == 0)
          {
            rcnk.fcc = lpFList->lpAviIdx[i].ckid;
            break;
          }
      /* ja:kt[`Nǉ */
      rcnk.cb = 0;
      for (i = 0; i < nNull; i++)
        {
          *(RIFFCHUNK *)(lpFList->lpbData + lpFList->dwOffset) = rcnk;
          lpFList->dwOffset += sizeof (RIFFCHUNK);
          lpFList->lpAviIdx[lpFList->dwIndex].ckid = rcnk.fcc;
          lpFList->lpAviIdx[lpFList->dwIndex].dwFlags = 0;
          lpFList->lpAviIdx[lpFList->dwIndex].dwChunkOffset
                                                        = lpFList->uiOffset;
          lpFList->lpAviIdx[lpFList->dwIndex].dwChunkLength = 0;
          lpFList->uiOffset += sizeof (RIFFCHUNK);
          lpFList->dwIndex++;
        }
      lpFList->dwVideo += nNull;
      stVsCap.dwDrop += nNull;
      stVsCap.dwFrame += nNull;
    }
  if (stVsCap.cv.cbSize > 0)
    {
      /* ja:\tgEFAk */
      lSize = 0;
      lpBits = ICSeqCompressFrame (&stVsCap.cv, 0,
                                                lpVHdr->lpData, &fKey, &lSize);
      if (!lpBits)
        {
          fControl = FALSE;
          lpszError = _T("ICSeqCompressFrame");
          return FALSE;
        }
    }
  else if (stVsCap.cv.hic)
    {
      /* ja:k */
      if (ICDecompress (stVsCap.cv.hic,
            lpVHdr->dwFlags & VHDR_KEYFRAME ? ICDECOMPRESS_NOTKEYFRAME : 0,
            (LPBITMAPINFOHEADER)stVsCap.lpBmiIn, lpVHdr->lpData,
            (LPBITMAPINFOHEADER)stVsCap.lpBmiOut, stVsCap.lpBits) != ICERR_OK)
        {
          fControl = FALSE;
          lpszError = _T("ICDecompress");
          return FALSE;
        }
      lpBits = stVsCap.lpBits;
      lSize = stVsCap.nImgByte;
      fKey = TRUE;
    }
  else
    {
      /* ja:\tgEFAkȂ */
      lpBits = lpVHdr->lpData;
      lSize = lpVHdr->dwBytesUsed;
      fKey = lpVHdr->dwFlags & VHDR_KEYFRAME;
    }
  /* ja:݂̏ŋK̃TCY𒴂邩`FbN */
  if (lpFList->uiOffset + lSize + sizeof (RIFFCHUNK) * 2
        + (lpFList->dwIndex + 1) * sizeof (AVIINDEXENTRY) > lpFList->uiBytes
                                                || lpFList->dwIndex >= 324000)
    {
      if (stVsCap.cv.cbSize > 0)
        {
          ICSeqCompressFrameEnd (&stVsCap.cv);
          if (!ICSeqCompressFrameStart (&stVsCap.cv, stVsCap.lpBmiIn))
            {
              fControl = FALSE;
              lpszError = LoadText (hInst, IDS_VCM_START);
              return FALSE;
            }
          lSize = 0;
          lpBits = ICSeqCompressFrame (&stVsCap.cv, 0,
                                                lpVHdr->lpData, &fKey, &lSize);
          if (!lpBits)
            {
              fControl = FALSE;
              lpszError = _T("ICSeqCompressFrame");
              return FALSE;
            }
        }
      do
        {
          stVsCap.nList++;
          if (stVsCap.nFileList <= stVsCap.nList)
            {
              fControl = FALSE;
              return FALSE;
            }
          lpFList++;
        }
      while (lpFList->uiOffset + lSize + sizeof (RIFFCHUNK) * 2
        + (lpFList->dwIndex + 1) * sizeof (AVIINDEXENTRY) > lpFList->uiBytes
                                                || lpFList->dwIndex >= 324000);
    }
  /* ja:Kvȃobt@̃TCY */
  dwSize = (lpFList->dwOffset + sizeof (RIFFCHUNK) + (lSize + 1 & ~1))
                                        / lpFList->dwBase * lpFList->dwBase;
  if (lpFList->dwData < dwSize + lpFList->dwBase
                        && !AllocBuffer (lpFList, dwSize + lpFList->dwBase))
    return FALSE;
  ((RIFFCHUNK *)(lpFList->lpbData + lpFList->dwOffset))->fcc
                = MAKEAVICKID (fKey ? cktypeDIBbits : cktypeDIBcompressed, 0);
  ((RIFFCHUNK *)(lpFList->lpbData + lpFList->dwOffset))->cb = lSize;
  lpFList->dwOffset += sizeof (RIFFCHUNK);
  if (lpFList->dwOffset < dwSize)
    {
      /* ja:ACgꂽ]/ */
      nBuffer = min (dwSize - lpFList->dwOffset, lSize);
      MemoryCopy (lpFList->lpbData + lpFList->dwOffset, lpBits, nBuffer);
      if (!WriteFile (lpFList->hFile, lpFList->lpbData, dwSize, &dwWrite, NULL)
                                                        || dwSize != dwWrite)
        {
          fControl = FALSE;
          lpszError = LoadText (hInst, IDS_FILE_WRITE);
          return FALSE;
        }
      /* ja:cZoăobt@ɕۑ */
      nBuffer = lSize - nBuffer;
      if (nBuffer > 0)
        {
          MemoryCopy (lpFList->lpbData, (LPBYTE)lpBits + lSize - nBuffer,
                                                                    nBuffer);
          lpFList->dwOffset = nBuffer + (lSize & 1);
        }
      else
        {
          lpFList->dwOffset = 0;
        }
    }
  else
    {
      /* ja:`NIDŊɏݗ\ʂ𒴂Ă */
      if (dwSize > 0)
        {
          if (!WriteFile (lpFList->hFile, lpFList->lpbData,
                                                        dwSize, &dwWrite, NULL)
                                                        || dwSize != dwWrite)
            {
              fControl = FALSE;
              lpszError = LoadText (hInst, IDS_FILE_WRITE);
              return FALSE;
            }
          nBuffer = lpFList->dwOffset - dwSize;
          MemoryCopy (lpFList->lpbData, lpFList->lpbData + dwSize, nBuffer);
          lpFList->dwOffset = nBuffer;
        }
      MemoryCopy (lpFList->lpbData + lpFList->dwOffset, lpBits, lSize);
      lpFList->dwOffset += lSize + 1 & ~1;
    }
  /* ja:CfbNXݒ肷 */
  lpFList->lpAviIdx[lpFList->dwIndex].ckid
                = MAKEAVICKID (fKey ? cktypeDIBbits : cktypeDIBcompressed, 0);
  lpFList->lpAviIdx[lpFList->dwIndex].dwFlags = fKey ? AVIIF_KEYFRAME : 0;
  lpFList->lpAviIdx[lpFList->dwIndex].dwChunkOffset = lpFList->uiOffset;
  lpFList->lpAviIdx[lpFList->dwIndex].dwChunkLength = lSize;
  lpFList->uiOffset += (lSize + 1 & ~1) + sizeof (RIFFCHUNK);
  lpFList->dwVideo++;
  lpFList->dwIndex++;

  wsprintf (szText, szFrameFormat, stVsCap. dwFrame++,
        lpVHdr->dwTimeCaptured / (60 * 60 * 1000),
        lpVHdr->dwTimeCaptured / (60 * 1000) % 60,
        lpVHdr->dwTimeCaptured / 1000 % 60, stVsCap.dwDrop, stVsCap.nList + 1);
  SendMessage (hWndStat, SB_SETTEXT, 0, (LPARAM)szText);

  return TRUE;
}


static LRESULT CALLBACK
AviWaveCallbackProc (HWND      hWnd,
                     LPWAVEHDR lpWHdr)
{
  int nBuffer;
  DWORD dwSize, dwWrite;
  LPFILELIST lpFList;

  if (lpWHdr->dwBytesRecorded == 0 || !fControl
                                        || stVsCap.nFileList <= stVsCap.nList)
    return FALSE;
  lpFList = stVsCap.lpFileList + stVsCap.nList;
  /* ja:݂̏ŋK̃TCY𒴂邩`FbN */
  if (lpFList->uiOffset + lpWHdr->dwBytesRecorded + sizeof (RIFFCHUNK) * 2
        + (lpFList->dwIndex + 1) * sizeof (AVIINDEXENTRY) > lpFList->uiBytes
                                                || lpFList->dwIndex >= 324000)
    {
      if (stVsCap.cv.cbSize > 0)
        {
          ICSeqCompressFrameEnd (&stVsCap.cv);
          if (!ICSeqCompressFrameStart (&stVsCap.cv, stVsCap.lpBmiIn))
            {
              fControl = FALSE;
              lpszError = LoadText (hInst, IDS_VCM_START);
              return FALSE;
            }
        }
      do
        {
          stVsCap.nList++;
          if (stVsCap.nFileList <= stVsCap.nList)
            {
              fControl = FALSE;
              return FALSE;
            }
          lpFList++;
        }
      while (lpFList->uiOffset
                            + lpWHdr->dwBytesRecorded + sizeof (RIFFCHUNK) * 2
            + (lpFList->dwIndex+1) * sizeof (AVIINDEXENTRY) > lpFList->uiBytes
                                                || lpFList->dwIndex >= 324000);
    }
  /* ja:Kvȃobt@̃TCY */
  dwSize = (lpFList->dwOffset + sizeof (RIFFCHUNK)
    + (lpWHdr->dwBytesRecorded + 1 & ~1)) / lpFList->dwBase * lpFList->dwBase;
  if (lpFList->dwData < dwSize + lpFList->dwBase
                        && !AllocBuffer (lpFList, dwSize + lpFList->dwBase))
    return FALSE;
  ((RIFFCHUNK *)(lpFList->lpbData + lpFList->dwOffset))->fcc
                                            = MAKEAVICKID (cktypeWAVEbytes, 1);
  ((RIFFCHUNK *)(lpFList->lpbData+lpFList->dwOffset))->cb
                                            = lpWHdr->dwBytesRecorded;
  lpFList->dwOffset += sizeof (RIFFCHUNK);
  if (lpFList->dwOffset < dwSize)
    {
      /* ja:ACgꂽ]/ */
      nBuffer = min (dwSize - lpFList->dwOffset, lpWHdr->dwBytesRecorded);
      MemoryCopy (lpFList->lpbData + lpFList->dwOffset, lpWHdr->lpData,
                                                                    nBuffer);
      if (!WriteFile (lpFList->hFile, lpFList->lpbData, dwSize, &dwWrite, NULL)
                                                        || dwSize != dwWrite)
        {
          fControl = FALSE;
          lpszError = LoadText (hInst, IDS_FILE_WRITE);
          return FALSE;
        }
      /* ja:cZoăobt@ɕۑ */
      nBuffer = lpWHdr->dwBytesRecorded - nBuffer;
      if (nBuffer > 0)
        {
          MemoryCopy (lpFList->lpbData, (LPBYTE)lpWHdr->lpData
                                + lpWHdr->dwBytesRecorded - nBuffer, nBuffer);
          lpFList->dwOffset = nBuffer + (lpWHdr->dwBytesRecorded & 1);
        }
      else
        {
          lpFList->dwOffset = 0;
        }
    }
  else
    {
      /* ja:`NIDŊɏݗ\ʂ𒴂Ă */
      if (dwSize > 0)
        {
          if (!WriteFile (lpFList->hFile, lpFList->lpbData,
                                                        dwSize, &dwWrite, NULL)
                                                        || dwSize != dwWrite)
            {
              fControl = FALSE;
              lpszError = LoadText (hInst, IDS_FILE_WRITE);
              return FALSE;
            }
          nBuffer = lpFList->dwOffset - dwSize;
          MemoryCopy (lpFList->lpbData, lpFList->lpbData + dwSize, nBuffer);
          lpFList->dwOffset = nBuffer;
        }
      MemoryCopy (lpFList->lpbData + lpFList->dwOffset, lpWHdr->lpData,
                                                    lpWHdr->dwBytesRecorded);
      lpFList->dwOffset += lpWHdr->dwBytesRecorded + 1 & ~1;
    }
  lpFList->lpAviIdx[lpFList->dwIndex].ckid = MAKEAVICKID (cktypeWAVEbytes, 1);
  lpFList->lpAviIdx[lpFList->dwIndex].dwFlags = 0;
  lpFList->lpAviIdx[lpFList->dwIndex].dwChunkOffset = lpFList->uiOffset;
  lpFList->lpAviIdx[lpFList->dwIndex].dwChunkLength = lpWHdr->dwBytesRecorded;
  lpFList->uiOffset += (lpWHdr->dwBytesRecorded + 1 & ~1) + sizeof (RIFFCHUNK);
  lpFList->dwWave += lpWHdr->dwBytesRecorded
                                        / stVsCap.lpProp->lpWfx->nBlockAlign;
  lpFList->dwIndex++;
  return TRUE;
}


/*  ja:AVIŃLv`
     lpProp,vpeB
    lpFList,t@C̃Xg
     nFList,t@C̃Xg
        RET,TRUE:I,FALSE:G[                                      */
BOOL
CaptureAVI (LPPROPERTY lpProp,
            LPFILELIST lpFList,
            int        nFList)
{
  int i, j;
  DWORD dwMicroSecPerFrame;
  DWORD dwHeader;       /* ja:wb^̍ŒoCg */
  DWORD dwSize;         /* ja:Ōɏރobt@̃TCY */
  DWORD dwVideo;        /* ja:rfĨtH[}bg̃oCg */
  DWORD dwWave;         /* ja:I[fBĨtH[}bg̃oCg */
  DWORD dwAllW;         /* ja:ׂẴI[fBĨTv */
  UINT uVideo, uWave;   /* ja:rfIAI[fBI̐̃oCg */
  static LPCSTR lpszVideo = "Video #1";
  static LPCSTR lpszWave = "Audio #1";

  MemorySet (&stVsCap, 0, sizeof (VSCAPTURE));

  uVideo = (lstrlenA (lpszVideo) + 1) * sizeof (CHAR);
  uWave = (lstrlenA (lpszWave) + 1) * sizeof (CHAR);
  /* ja:wb^擾 */
  dwVideo = capGetVideoFormatSize (hWndCap);
  if (dwVideo == 0)
    {
      AddWarning (_T("capGetVideoFormatSize"));
      return FALSE;
    }
  /* ja:rfItH[}bg */
  stVsCap.lpBmiOut = MemoryAlloc (dwVideo);
  if (!stVsCap.lpBmiOut)
    {
      AddWarning (_T("MemoryAlloc"));
      return FALSE;
    }
  if (capGetVideoFormat (hWndCap, stVsCap.lpBmiOut, dwVideo) == 0)
    {
      AddWarning (_T("capGetVideoFormat"));
      MemoryFree (stVsCap.lpBmiOut);
      return FALSE;
    }
  dwWave = cparam.fCaptureAudio ? lpProp->lpWfx->cbSize + sizeof (WAVEFORMATEX)
                                : 0;

  /* ja:k */
  if (lpProp->fccHandler == comptypeDIB)
    {
      /* ja:k */
      stVsCap.lpBmiIn = stVsCap.lpBmiOut;
      if (!(stVsCap.cv.hic = ICOpen (ICTYPE_VIDEO,
                                    stVsCap.lpBmiIn->bmiHeader.biCompression,
                                            ICMODE_FASTDECOMPRESS))
                && !(stVsCap.cv.hic = ICOpen (ICTYPE_VIDEO,
                                    stVsCap.lpBmiIn->bmiHeader.biCompression,
                                            ICMODE_DECOMPRESS)))
        {
          AddWarning (LoadText (hInst, IDS_VCM_OPEN));
          MemoryFree (stVsCap.lpBmiIn);
          return FALSE;
        }
      /* ja:VCMgWJ̃tH[}bg擾 */
      dwVideo = ICDecompressGetFormatSize (stVsCap.cv.hic, stVsCap.lpBmiIn);
      if (dwVideo <= 0)
        {
          AddWarning (LoadText (hInst, IDS_VCM_START));
          ICClose (stVsCap.cv.hic);
          MemoryFree (stVsCap.lpBmiIn);
          return FALSE;
        }
      stVsCap.lpBmiOut = MemoryAlloc (dwVideo);
      if (!stVsCap.lpBmiOut)
        {
          AddWarning (_T("MemoryAlloc"));
          ICClose (stVsCap.cv.hic);
          MemoryFree (stVsCap.lpBmiIn);
          return FALSE;
        }
      if (ICDecompressGetFormat (stVsCap.cv.hic,
                                stVsCap.lpBmiIn, stVsCap.lpBmiOut) != ICERR_OK
                || ICDecompressBegin (stVsCap.cv.hic,
                                stVsCap.lpBmiIn, stVsCap.lpBmiOut) != ICERR_OK)
        {
          AddWarning (LoadText (hInst, IDS_VCM_START));
          ICDecompressEnd (stVsCap.cv.hic);
          ICClose(stVsCap.cv.hic);
          MemoryFree (stVsCap.lpBmiIn);
          MemoryFree (stVsCap.lpBmiOut);
          return FALSE;
        }
      stVsCap.nImgByte = bmImgByte ((LPBITMAPINFOHEADER)stVsCap.lpBmiOut);
      stVsCap.lpBits = MemoryAlloc (stVsCap.nImgByte);
      if (!stVsCap.lpBits)
        {
          AddWarning (_T("MemoryAlloc"));
          ICDecompressEnd (stVsCap.cv.hic);
          ICClose (stVsCap.cv.hic);
          MemoryFree (stVsCap.lpBmiIn);
          MemoryFree (stVsCap.lpBmiOut);
          return FALSE;
        }
    }
  else if (lpProp->fccHandler != 0)
    {
      /* ja:Ĉk */
      stVsCap.lpBmiIn = stVsCap.lpBmiOut;
      stVsCap.cv.cbSize = sizeof (COMPVARS);
      stVsCap.cv.fccHandler = lpProp->fccHandler;
      stVsCap.cv.lpbiOut = lpProp->lpBmiOut;
      stVsCap.cv.lKey = lpProp->lKey;
      stVsCap.cv.lDataRate = lpProp->lDataRate;
      stVsCap.cv.lQ = lpProp->lQ;
      stVsCap.cv.lpState = lpProp->lpState;
      stVsCap.cv.cbState = lpProp->cbState;
      if (!(stVsCap.cv.hic = ICOpen(ICTYPE_VIDEO, stVsCap.cv.fccHandler,
                                                ICMODE_FASTCOMPRESS))
            && !(stVsCap.cv.hic = ICOpen (ICTYPE_VIDEO, stVsCap.cv.fccHandler,
                                                ICMODE_COMPRESS)))
        {
          AddWarning (LoadText (hInst, IDS_VCM_OPEN));
          MemoryFree (stVsCap.lpBmiIn);
          return FALSE;
        }
      if (!ICSeqCompressFrameStart (&stVsCap.cv, stVsCap.lpBmiIn))
        {
          AddWarning (LoadText (hInst, IDS_VCM_START));
          ICClose (stVsCap.cv.hic);
          MemoryFree (stVsCap.lpBmiIn);
          return FALSE;
        }
      if (lpProp->lpBmiOut)
        {
          dwVideo = bmHdrByte ((LPBITMAPINFOHEADER)lpProp->lpBmiOut);
          stVsCap.lpBmiOut = MemoryAlloc (dwVideo);
          if (!stVsCap.lpBmiOut)
            {
              AddWarning (_T("MemoryAlloc"));
              ICSeqCompressFrameEnd (&stVsCap.cv);
              ICClose (stVsCap.cv.hic);
              MemoryFree (stVsCap.lpBmiIn);
              return FALSE;
            }
          MemoryCopy (stVsCap.lpBmiOut, lpProp->lpBmiOut, dwVideo);
        }
      else
        {
          stVsCap.lpBmiOut = MemoryAlloc (dwVideo);
          if (!stVsCap.lpBmiOut)
            {
              AddWarning (_T("MemoryAlloc"));
              ICSeqCompressFrameEnd (&stVsCap.cv);
              ICClose (stVsCap.cv.hic);
              MemoryFree (stVsCap.lpBmiIn);
              return FALSE;
            }
          MemoryCopy (stVsCap.lpBmiOut, stVsCap.lpBmiIn, dwVideo);
        }
    }

  /* ja:wb^TCYvZ */
  dwHeader = sizeof (FOURCC)                                    /* 'RIFF' */
           + sizeof (DWORD)                                     /* TCY */
           + sizeof (FOURCC)                                    /* 'AVI ' */
              + sizeof (FOURCC)                                 /* 'LIST' */
              + sizeof (DWORD)                                  /* TCY */
              + sizeof (FOURCC)                                 /* 'hdrl' */
                + sizeof (FOURCC)                               /* 'avih' */
                + sizeof (DWORD)                                /* TCY */
                + sizeof (MainAVIHeader)                        /* \ */
                  + sizeof (FOURCC)                             /* 'LIST' */
                  + sizeof (DWORD)                              /* TCY */
                  + sizeof (FOURCC)                             /* 'strl' */
                    +sizeof (FOURCC)                            /* 'strh' */
                    +sizeof (DWORD)                             /* TCY */
                    +sizeof (AVIStreamHeader)                   /* \ */
                    +sizeof (FOURCC)                            /* 'strf' */
                    +sizeof (DWORD)                             /* TCY */
                    + (dwVideo + 1 & ~1)                        /* \ */
                    + sizeof (FOURCC)                           /* 'strn' */
                    + sizeof (DWORD)                            /* TCY */
                    + (uVideo + 1 & ~1)                         /*  */
                  + (dwWave > 0 ?
                    sizeof (FOURCC)                             /* 'LIST' */
                  + sizeof (DWORD)                              /* TCY */
                  + sizeof (FOURCC)                             /* 'strl' */
                    + sizeof (FOURCC)                           /* 'strh' */
                    + sizeof (DWORD)                            /* TCY */
                    + sizeof (AVIStreamHeader)                  /* \ */
                        + sizeof (FOURCC)                       /* 'strf' */
                    + sizeof (DWORD)                            /* TCY */
                    + (dwWave + 1 & ~1)                         /* \ */
                    + sizeof (FOURCC)                           /* 'strn' */
                    + sizeof (DWORD)                            /* TCY */
                    + (uWave + 1 & ~1)                          /*  */
                  : 0)
              + sizeof (FOURCC)                                 /* 'JUNK' */
              + sizeof (DWORD)                                  /* TCY */
              + sizeof (FOURCC)                                 /* 'LIST' */
              + sizeof (DWORD)                                  /* TCY */
              + sizeof (FOURCC);                                /* 'movi' */

  /* ja:t@CJ */
  for (i = 0; i < nFList; i++)
    {
      DWORD dwSectorsPerCluster;
      DWORD dwNumberOfFreeClusters;
      DWORD dwTotalNumberOfClusters;
      TCHAR szFile[MAXPATH];
      FNDIR fd;

      /* ja:hCu1ZN^̃oCg擾 */
      SplitFileName (lpFList[i].szFile, &fd);
      lstrcpy (szFile, fd.szDrive);
      lstrcat (szFile, _T("\\"));
      lpFList[i].dwBase = AVI_HEADERSIZE;
      if (!GetDiskFreeSpace (szFile, &dwSectorsPerCluster, &lpFList[i].dwBase,
                        &dwNumberOfFreeClusters, &dwTotalNumberOfClusters))
        {
          AddWarning (_T("GetDiskFreeSpace"));
          while (i > 0)
            {
              --i;
              CloseHandle (lpFList[i].hFile);
              DeleteFile (lpFList[i].szFile);
              MemoryFree (lpFList[i].lpAviIdx);
              MemoryFree (lpFList[i].lpbMemory);
            }
          if (lpProp->fccHandler == comptypeDIB)
            ICDecompressEnd (stVsCap.cv.hic);
          else if (lpProp->fccHandler != 0)
            ICSeqCompressFrameEnd (&stVsCap.cv);
          if (stVsCap.cv.hic)
            ICClose (stVsCap.cv.hic);
          MemoryFree (stVsCap.lpBmiIn);
          MemoryFree (stVsCap.lpBmiOut);
          MemoryFree (stVsCap.lpBits);
          return FALSE;
        }
      lpFList[i].hFile = CreateFile (lpFList[i].szFile, GENERIC_WRITE,
                        FILE_SHARE_READ, NULL, OPEN_ALWAYS,
                        FILE_ATTRIBUTE_NORMAL | FILE_FLAG_NO_BUFFERING, NULL);
      if (lpFList[i].hFile == INVALID_HANDLE_VALUE)
        {
          AddWarning (LoadText (hInst, IDS_FILE_OPEN));
          while (i > 0)
            {
              --i;
              CloseHandle (lpFList[i].hFile);
              DeleteFile (lpFList[i].szFile);
              MemoryFree (lpFList[i].lpAviIdx);
              MemoryFree (lpFList[i].lpbMemory);
            }
          if (lpProp->fccHandler == comptypeDIB)
            ICDecompressEnd (stVsCap.cv.hic);
          else if (lpProp->fccHandler != 0)
            ICSeqCompressFrameEnd (&stVsCap.cv);
          if (stVsCap.cv.hic)
            ICClose (stVsCap.cv.hic);
          MemoryFree (stVsCap.lpBmiIn);
          MemoryFree (stVsCap.lpBmiOut);
          MemoryFree (stVsCap.lpBits);
          return FALSE;
        }
      lpFList[i].uiOffset = (dwHeader / lpFList[i].dwBase + 1)
                                                        * lpFList[i].dwBase;
      if (SetFilePointer (lpFList[i].hFile, (LONG)lpFList[i].uiOffset, NULL,
                                                    FILE_BEGIN) == 0xffffffff)
        {
          AddWarning (_T("SetFilePointer"));
          lpFList[i].lpAviIdx = NULL;
          lpFList[i].lpbMemory = NULL;
          while (i >= 0)
            {
              CloseHandle (lpFList[i].hFile);
              DeleteFile (lpFList[i].szFile);
              MemoryFree (lpFList[i].lpAviIdx);
              MemoryFree (lpFList[i].lpbMemory);
              i--;
            }
          if (lpProp->fccHandler == comptypeDIB)
            ICDecompressEnd (stVsCap.cv.hic);
          else if (lpProp->fccHandler != 0)
            ICSeqCompressFrameEnd (&stVsCap.cv);
          if (stVsCap.cv.hic)
            ICClose (stVsCap.cv.hic);
          MemoryFree (stVsCap.lpBmiIn);
          MemoryFree (stVsCap.lpBmiOut);
          MemoryFree (stVsCap.lpBits);
          return FALSE;
        }
      /* ja:obt@mۂ */
      lpFList[i].dwData = (max (dwHeader, 1024 * 1024) / lpFList[i].dwBase + 1)
                                                        * lpFList[i].dwBase;
      lpFList[i].dwMemory = lpFList[i].dwData + lpFList[i].dwBase;
      lpFList[i].lpbMemory = NULL;
      lpFList[i].lpAviIdx = MemoryAlloc (sizeof (AVIINDEXENTRY) * 324000);
      lpFList[i].lpbMemory = MemoryAlloc (lpFList[i].dwMemory);
      if (!lpFList[i].lpAviIdx || !lpFList[i].lpbMemory)
        {
          AddWarning (_T("MemoryAlloc"));
          while (i >= 0)
            {
              CloseHandle (lpFList[i].hFile);
              DeleteFile (lpFList[i].szFile);
              MemoryFree (lpFList[i].lpAviIdx);
              MemoryFree (lpFList[i].lpbMemory);
              i--;
            }
          if (lpProp->fccHandler == comptypeDIB)
            ICDecompressEnd (stVsCap.cv.hic);
          else if (lpProp->fccHandler != 0)
            ICSeqCompressFrameEnd (&stVsCap.cv);
          if (stVsCap.cv.hic)
            ICClose (stVsCap.cv.hic);
          MemoryFree (stVsCap.lpBmiIn);
          MemoryFree (stVsCap.lpBmiOut);
          MemoryFree (stVsCap.lpBits);
          return FALSE;
        }
      lpFList[i].lpbData = (LPBYTE)(((UINT)lpFList[i].lpbMemory
                                / lpFList[i].dwBase + 1) * lpFList[i].dwBase);
      lpFList[i].dwOffset = 0;
      lpFList[i].dwIndex = 0;
      lpFList[i].dwVideo = 0;
      lpFList[i].dwWave = 0;
    }

  lpszError = NULL;

  stVsCap.nList = 0;
  stVsCap.nFileList = nFList;
  stVsCap.lpFileList = lpFList;
  stVsCap.dwDrop = 0;
  stVsCap.dwFrame = 0;
  stVsCap.lpProp = lpProp;

  capSetCallbackOnVideoStream (hWndCap, AviVideoCallbackProc);
  capSetCallbackOnWaveStream (hWndCap, AviWaveCallbackProc);

  /* ja:Lv`s */
  capCaptureSequenceNoFile (hWndCap);

  /* ja:G[bZ[W\ */
  if (lpszError)
    AddWarning (lpszError);

  /* ja:k */
  if (lpProp->fccHandler == comptypeDIB)
    ICDecompressEnd (stVsCap.cv.hic);
  else if (lpProp->fccHandler != 0)
    ICSeqCompressFrameEnd (&stVsCap.cv);
  if (stVsCap.cv.hic)
    ICClose (stVsCap.cv.hic);
  MemoryFree (stVsCap.lpBmiIn);
  MemoryFree (stVsCap.lpBits);

  /* ja:ۂ̃[g߂ */
  dwMicroSecPerFrame = 0;
  dwAllW = 0;
  if (fRate && dwWave > 0)
    for (i = 0; i < nFList; i++)
      dwAllW += lpFList[i].dwWave;
  if (dwAllW > 0 && stVsCap.dwFrame > 0)/* ja:TEhɂ킹 */
    dwMicroSecPerFrame = (INT64)dwAllW * lpProp->lpWfx->nBlockAlign
                                                                * 1000 * 1000
                            / lpProp->lpWfx->nAvgBytesPerSec / stVsCap.dwFrame;
  if (dwMicroSecPerFrame == 0)/* ja:ۂ̃[gvZ */
    dwMicroSecPerFrame = MulDiv (cstat.dwCurrentTimeElapsedMS, 1000,
                cstat.dwCurrentVideoFrame
                + abs (stVsCap.dwDrop - cstat.dwCurrentVideoFramesDropped));
  if (dwMicroSecPerFrame == 0)/* ja:_l̗p */
    dwMicroSecPerFrame = cparam.dwRequestMicroSecPerFrame;

  /* ja:fobN */
  if (fDebug)
    {
      TCHAR szText[1024];

      wsprintf (szText, _T( "AVI\n"
                            "IR:%s\n"
                            "v[g:%u,[g:%u\n"
                            ":%u\n"
                            "t[:%u,:%u(%u)\n"
                            "rfIobt@:%u,I[fBIobt@:%u"),
                        fControl ? _T("[U[") : _T("t@CTCY"),
                        cparam.dwRequestMicroSecPerFrame, dwMicroSecPerFrame,
                        cstat.dwCurrentTimeElapsedMS,
                        cstat.dwCurrentVideoFrame, stVsCap.dwDrop,
                        cstat.dwCurrentVideoFramesDropped,
                        cparam.wNumVideoRequested, cparam.wNumAudioRequested);
      AddWarning (szText);
    }

  /* ja:t@C */
  for (i = 0; i < nFList; i++)
    {
      if (lpFList[i].dwVideo > 0 && (dwWave == 0 || lpFList[i].dwWave > 0))
        {
          LPBYTE p;
          DWORD dwHead;         /* ja:wb^̃ACgꂽoCg */
          DWORD dwWrite;

          /* ja:t@Cւ݂̏ */
          /* ja:wb_̃TCYvZACfbNX␳ */
          dwHead = (dwHeader / lpFList[i].dwBase + 1) * lpFList[i].dwBase;
          for (j = 0; j < lpFList[i].dwIndex; j++)
            lpFList[i].lpAviIdx[j].dwChunkOffset -= dwHead - sizeof (FOURCC);
          /* ja:Kvȃobt@̃TCY */
          dwSize = ((lpFList[i].dwOffset
            + lpFList[i].dwIndex * sizeof (AVIINDEXENTRY)
            + sizeof (RIFFCHUNK)) / lpFList[i].dwBase + 1) * lpFList[i].dwBase;
          if (lpFList[i].dwData < dwSize && !AllocBuffer (lpFList + i, dwSize))
            {
              CloseHandle (lpFList[i].hFile);
              MemoryFree (lpFList[i].lpAviIdx);
              continue;
            }
          /* ja:CfbNX */
          ((RIFFCHUNK *)(lpFList[i].lpbData + lpFList[i].dwOffset))->fcc
                                = ckidAVINEWINDEX;
          ((RIFFCHUNK *)(lpFList[i].lpbData+lpFList[i].dwOffset))->cb
                                = lpFList[i].dwIndex * sizeof (AVIINDEXENTRY);
          lpFList[i].dwOffset += sizeof (RIFFCHUNK);
          MemoryCopy (lpFList[i].lpbData + lpFList[i].dwOffset,
                                lpFList[i].lpAviIdx,
                                lpFList[i].dwIndex * sizeof (AVIINDEXENTRY));
          lpFList[i].dwOffset += lpFList[i].dwIndex * sizeof (AVIINDEXENTRY);
          MemorySet (lpFList[i].lpbData + lpFList[i].dwOffset, 0,
                                                dwSize - lpFList[i].dwOffset);
          if (!WriteFile (lpFList[i].hFile, lpFList[i].lpbData,
                                dwSize, &dwWrite, NULL) || dwSize != dwWrite)
            AddWarning (LoadText (hInst, IDS_FILE_WRITE));
          MemoryFree (lpFList[i].lpAviIdx);

          if (!SetEndOfFile (lpFList[i].hFile))
            AddWarning (_T("SetEndOfFile"));
          if (SetFilePointer (lpFList[i].hFile, 0, NULL, FILE_BEGIN)
                                                                == 0xffffffff)
            AddWarning (_T("SetFilePointer"));

          /* ja:wb^ݒ肷 */
          p = lpFList[i].lpbData;
          MemorySet (p, 0, dwHead);

          *(FOURCC *)p = FOURCC_RIFF; ((FOURCC *)p)++;          /* 'RIFF' */
          *(LPDWORD)p = lpFList[i].uiOffset + lpFList[i].dwIndex
                                                    * sizeof (AVIINDEXENTRY);
          ((LPDWORD)p)++;                                       /* TCY */
          *(FOURCC *)p = formtypeAVI; ((FOURCC *)p)++;          /* 'AVI ' */

          *(FOURCC *)p = FOURCC_LIST; ((FOURCC *)p)++;          /* 'LIST' */
          *(LPDWORD)p = sizeof (FOURCC)                         /* 'hdrl' */
                          + sizeof (FOURCC)                     /* 'avih' */
                          + sizeof (DWORD)                      /* TCY */
                          + sizeof (MainAVIHeader)              /* \ */
                          + sizeof (FOURCC)                     /* 'LIST' */
                          + sizeof (DWORD)                      /* TCY */
                          + sizeof (FOURCC)                     /* 'strl' */
                            + sizeof (FOURCC)                   /* 'strh' */
                            + sizeof (DWORD)                    /* TCY */
                            + sizeof (AVIStreamHeader)          /* \ */
                            + sizeof (FOURCC)                   /* 'strf' */
                            + sizeof (DWORD)                    /* TCY */
                            + (dwVideo + 1 & ~1)                /* \ */
                            + sizeof (FOURCC)                   /* 'strn' */
                            + sizeof (DWORD)                    /* TCY */
                            + (uVideo + 1 & ~1)                 /*  */
                          + (dwWave>0?
                            sizeof (FOURCC)                     /* 'LIST' */
                          + sizeof (DWORD)                      /* TCY */
                          + sizeof (FOURCC)                     /* 'strl' */
                            + sizeof (FOURCC)                   /* 'strh' */
                            + sizeof (DWORD)                    /* TCY */
                            + sizeof (AVIStreamHeader)          /* \ */
                            + sizeof (FOURCC)                   /* 'strf' */
                            + sizeof (DWORD)                    /* TCY */
                            + (dwWave + 1 & ~1)                 /* \ */
                            + sizeof (FOURCC)                   /* 'strn' */
                            + sizeof (DWORD)                    /* TCY */
                            + (uWave + 1 & ~1)                  /*  */
                          : 0);
          ((LPDWORD)p)++;                                       /* TCY */
          *(FOURCC *)p = listtypeAVIHEADER; ((FOURCC *)p)++;    /* 'hdrl' */

          *(FOURCC *)p = ckidAVIMAINHDR; ((FOURCC *)p)++;       /* 'avih' */
          *(LPDWORD)p = sizeof (MainAVIHeader); ((LPDWORD)p)++; /* TCY */
          ((MainAVIHeader *)p)->dwMicroSecPerFrame = dwMicroSecPerFrame;
          ((MainAVIHeader *)p)->dwPaddingGranularity = lpFList[i].dwBase;
          ((MainAVIHeader *)p)->dwFlags = AVIF_HASINDEX | AVIF_MUSTUSEINDEX;
          ((MainAVIHeader *)p)->dwTotalFrames = lpFList[i].dwVideo;
          ((MainAVIHeader *)p)->dwStreams = dwWave > 0 ? 2 : 1;
          ((MainAVIHeader *)p)->dwWidth = stVsCap.lpBmiOut->bmiHeader.biWidth;
          ((MainAVIHeader *)p)->dwHeight
                                        = stVsCap.lpBmiOut->bmiHeader.biHeight;
          ((MainAVIHeader *)p)++;                               /* \ */

          *(FOURCC *)p = FOURCC_LIST; ((FOURCC *)p)++;          /* 'LIST' */
          *(LPDWORD)p =   sizeof (FOURCC)                       /* 'strl' */
                            +sizeof (FOURCC)                    /* 'strh' */
                            +sizeof (DWORD)                     /* TCY */
                            +sizeof (AVIStreamHeader)           /* \ */
                            +sizeof (FOURCC)                    /* 'strf' */
                            +sizeof (DWORD)                     /* TCY */
                            + (dwVideo + 1 &~1)                 /* \ */
                            +sizeof (FOURCC)                    /* 'strn' */
                            +sizeof (DWORD)                     /* TCY */
                            + (uVideo + 1 & ~1);                /*  */
          ((LPDWORD)p)++;
          *(FOURCC *)p = listtypeSTREAMHEADER; ((FOURCC *)p)++; /* 'strl' */

          *(FOURCC *)p = ckidSTREAMHEADER; ((FOURCC *)p)++;     /* 'strh' */
          *((LPDWORD)p)  =sizeof (AVIStreamHeader); ((LPDWORD)p)++;/* TCY */
          ((AVIStreamHeader *)p)->fccType = streamtypeVIDEO;
          ((AVIStreamHeader *)p)->fccHandler
                    = stVsCap.cv.cbSize > 0 ? lpProp->fccHandler
                        : (stVsCap.lpBmiOut->bmiHeader.biCompression == BI_RGB
                || stVsCap.lpBmiOut->bmiHeader.biCompression == BI_BITFIELDS)
                    ? comptypeDIB : stVsCap.lpBmiOut->bmiHeader.biCompression;
          ((AVIStreamHeader *)p)->dwScale = dwMicroSecPerFrame;
          ((AVIStreamHeader *)p)->dwRate = 1000000;
          ((AVIStreamHeader *)p)->dwLength = lpFList[i].dwVideo;
          ((AVIStreamHeader *)p)->dwQuality = -1;
          ((AVIStreamHeader *)p)->rcFrame.right
                                        = stVsCap.lpBmiOut->bmiHeader.biWidth;
          ((AVIStreamHeader *)p)->rcFrame.top
                                        = stVsCap.lpBmiOut->bmiHeader.biHeight;
          ((AVIStreamHeader *)p)++;                             /* \ */

          *(FOURCC *)p = ckidSTREAMFORMAT; ((FOURCC *)p)++;     /* 'strf' */
          *(LPDWORD)p = dwVideo; ((LPDWORD)p)++;                /* TCY */
          MemoryCopy (p, stVsCap.lpBmiOut, dwVideo); p += dwVideo;/* \ */

          *(FOURCC *)p = ckidSTREAMNAME; ((FOURCC *)p)++;       /* 'strn' */
          *(LPDWORD)p = uVideo + 1 & ~1; ((LPDWORD)p)++;        /* TCY */
          MemoryCopy (p, lpszVideo, uVideo); p += uVideo + 1 & ~1;/*  */

          if (dwWave > 0)
            {
              *(FOURCC *)p = FOURCC_LIST; ((FOURCC *)p)++;      /* 'LIST' */
              *(LPDWORD)p =   sizeof (FOURCC)                   /* 'strl' */
                                + sizeof (FOURCC)               /* 'strh' */
                                + sizeof (DWORD)                /* TCY */
                                + sizeof (AVIStreamHeader)      /* \ */
                                + sizeof (FOURCC)               /* 'strf' */
                                + sizeof (DWORD)                /* TCY */
                                + (dwWave + 1 & ~1)             /* \ */
                                + sizeof (FOURCC)               /* 'strn' */
                                + sizeof (DWORD)                /* TCY */
                                + (uWave + 1 & ~1);             /*  */
              ((LPDWORD)p)++;
              *(FOURCC *)p = listtypeSTREAMHEADER; ((FOURCC *)p)++;/* 'strl' */

              *(FOURCC *)p = ckidSTREAMHEADER; ((FOURCC *)p)++; /* 'strh' */
              *(LPDWORD)p = sizeof (AVIStreamHeader);
              ((LPDWORD)p)++;                                   /* TCY */
              ((AVIStreamHeader *)p)->fccType = streamtypeAUDIO;
              ((AVIStreamHeader *)p)->dwScale = lpProp->lpWfx->nBlockAlign;
              ((AVIStreamHeader *)p)->dwRate = lpProp->lpWfx->nAvgBytesPerSec;
              ((AVIStreamHeader *)p)->dwLength = lpFList[i].dwWave;
              ((AVIStreamHeader *)p)->dwSampleSize
                                                = lpProp->lpWfx->nBlockAlign;
              ((AVIStreamHeader *)p)++;                         /* \ */

              *(FOURCC *)p = ckidSTREAMFORMAT; ((FOURCC *)p)++; /* 'strf' */
              *(LPDWORD)p = dwWave; ((LPDWORD)p)++;             /* TCY */
              MemoryCopy (p, lpProp->lpWfx, dwWave); p += dwWave;/* \ */

              *(FOURCC *)p = ckidSTREAMNAME; ((FOURCC *)p)++;   /* 'strn' */
              *(LPDWORD)p = uWave + 1 & ~1; ((LPDWORD)p)++;     /* TCY */
              MemoryCopy (p, lpszWave, uWave); p += uWave + 1 &~1;/*  */
            }
          *(FOURCC *)p = ckidAVIPADDING; ((FOURCC *)p)++;       /* 'JUNK' */
          *((LPDWORD)p) = dwHead - dwHeader;                    /* TCY */

          p = lpFList[i].lpbData + dwHead - sizeof (FOURCC);
          *(FOURCC *)p = listtypeAVIMOVIE; ((FOURCC *)p)--;     /* 'movi' */
          *(LPDWORD)p = lpFList[i].uiOffset - dwHead + sizeof (FOURCC);
          ((LPDWORD)p)--;                                       /* TCY */
          *(FOURCC *)p = FOURCC_LIST;                           /* 'LIST' */

          if (!WriteFile (lpFList[i].hFile, lpFList[i].lpbData,
                                dwHead, &dwWrite, NULL) || dwHead != dwWrite)
            AddWarning (LoadText (hInst, IDS_FILE_WRITE));
          if (!CloseHandle (lpFList[i].hFile))
            AddWarning (_T("CloseHandle"));

          /* ja:t@CTCY */
          lpFList[i].uiOffset += lpFList[i].dwIndex * sizeof (AVIINDEXENTRY)
                                            + sizeof (FOURCC) + sizeof (DWORD);

          /* ja:TCY𒲐 */
          lpFList[i].hFile = CreateFile (lpFList[i].szFile, GENERIC_WRITE,
                                        FILE_SHARE_READ, NULL, OPEN_EXISTING,
                                        FILE_ATTRIBUTE_NORMAL, NULL);
          if (lpFList[i].hFile != INVALID_HANDLE_VALUE)
            {
              LONG lMoveH, lMoveL;  /* ja:t@C|C^̈ړ */

              lMoveH = lpFList[i].uiOffset >> 32;
              lMoveL = lpFList[i].uiOffset;
              if (SetFilePointer (lpFList[i].hFile, lMoveL, &lMoveH,
                            FILE_BEGIN) == 0xffffffff && lMoveH == 0xffffffff)
                AddWarning (_T("SetFilePointer"));
              if (!SetEndOfFile (lpFList[i].hFile))
                AddWarning (_T("SetEndOfFile"));
              if (!CloseHandle (lpFList[i].hFile))
                AddWarning (_T("CloseHandle"));
            }
        }
      else
        {
          /* ja:t@CgȂ */
          if (!CloseHandle (lpFList[i].hFile))
            AddWarning (_T("CloseHandle"));
          if (!DeleteFile (lpFList[i].szFile))
            AddWarning (_T("DeleteFile"));
        }
      MemoryFree (lpFList[i].lpbMemory);
    }

  MemoryFree (stVsCap.lpBmiOut);
  return TRUE;
}
