/*
    valstr
    copyright (c) 1998-2006 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#ifndef __VALSTR_H__
#define __VALSTR_H__


#include <windows.h>


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


/******************************************************************************
*                                                                             *
* ja:֐                                                               *
*                                                                             *
******************************************************************************/
/*  ja:ł邩ǂ𔻒f
     ch,
    RET,TRUE:,FALSE:̑                                              */
#define IsCharNumeric(ch) (IsCharAlphaNumeric(ch)&&!IsCharAlpha(ch))


/*  ja:Rg[R[hł邩ǂ𔻒f
     ch,
    RET,TRUE:Rg[R[h,FALSE:̑                                */
BOOL WINAPI
IsCharControl (TCHAR ch);


/*  ja:l
        nValue,l
    lpszString,
        nRadix,
         nWide,
       fSigned,TRUE:,FALSE:Ȃ                                 */
VOID WINAPI
ValStr (int    nValue,
        LPTSTR lpszString,
        int    nRadix,
        int    nWide,
        BOOL   fSigned);


/*  ja:񁨐l
        nValue,l
    lpszString,
        nRadix,
       fSigned,TRUE:,FALSE:Ȃ
           RET,TRUE:I,FALSE:G[                                   */
BOOL WINAPI
StrVal (int     *nValue,
        LPCTSTR  lpszString,
        int      nRadix,
        BOOL     fSigned);


/*  ja:l
        nValue,l
       nDivide,Zl
    lpszString,                                                       */
VOID WINAPI
FloatStr (int    nValue,
          int    nDivide,
          LPTSTR lpszString);


/*  ja:񁨐l
      lpnValue,l
     lpnDivide,Zl
    lpszString,
           RET,TRUE:I,FALSE:G[                                   */
BOOL WINAPI
StrFloat (int     *lpnValue,
          int     *lpnDivide,
          LPCTSTR  lpszString);



/*  ja:񁨕
      lpbArray,
    lpszString,
        nRadix,
         nWide,
       fSigned,TRUE:,FALSE:Ȃ                                 */
VOID WINAPI
ArrayStr (LPBYTE lpbArray,
          LPTSTR lpszString,
          int    nRadix,
          int    nWide,
          BOOL   fSigned);


/*  ja:񁨐
      lpbArray,
    lpszString,
        nRadix,
       fSigned,TRUE:,FALSE:Ȃ
           RET,TRUE:I,FALSE:G[                                   */
BOOL WINAPI
StrArray (LPBYTE  lpbArray,
          LPCTSTR lpszString,
          int     nRadix,
          BOOL    fSigned);


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __VALSTR_H__ */
