/*
    argument
    copyright (c) 1998-2006 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#include "argument.h"
#include "memapi.h"


/******************************************************************************
*                                                                             *
* ja:͊֐                                                             *
*                                                                             *
******************************************************************************/
/*  ja:R}hC̉
          nArgc,R}h̐
       lpszArgv,ւ̃|C^
    lpszCmdLine,R}hC
            RET,TRUE:I,FALSE:G[                                  */
BOOL WINAPI
MakeArgument (int      *lpnArgc,
              TCHAR  ***lpszArgv,
              LPCSTR    lpszCmdLine)
{
  int i, j, n;
  LPCTSTR lpszCommand;

#ifdef UNICODE
  n = MultiByteToWideChar (CP_ACP, 0, lpszCmdLine, -1 ,NULL, 0);
  if (n <= 0)
    return FALSE;
  lpszCommand = MemoryAlloc (n * sizeof (TCHAR));
  if (!lpszCommand)
    return FALSE;
  MultiByteToWideChar (CP_ACP, 0, lpszCmdLine, -1, lpszCommand, n);
#else /* not UNICODE */
  lpszCommand = lpszCmdLine;
#endif /* not UNICODE */
  *lpnArgc = 0;
  *lpszArgv = NULL;
  for (i = 0; lpszCommand[i] != '\0'; i++)
    {
      if (lpszCommand[i] != ' ')
        {
          TCHAR cEnd;

          (*lpnArgc)++;
          cEnd = (CHAR)(lpszCommand[i] == '\"' ? '\"' : ' ');
          do
            i++;
          while (lpszCommand[i] != '\0' && lpszCommand[i] != cEnd);
          if (lpszCommand[i] == '\0')
            i--;
        }
    }
  if (*lpnArgc == 0)
    {
#ifdef UNICODE
      MemoryFree (lpszCommand);
#endif /* UNICODE */
      return TRUE;
    }
  *lpszArgv = MemoryAlloc (*lpnArgc * sizeof (LPTSTR));
  if (!*lpszArgv)
    {
#ifdef UNICODE
      MemoryFree (lpszCommand);
#endif /* UNICODE */
      return FALSE;
    }
  *lpnArgc = i = 0;
  while (lpszCommand[i] != '\0')
    if (lpszCommand[i] == '\"')
      {
        for (n = i + 1; lpszCommand[n] != '\0' && lpszCommand[n] != '\"'; n++);
        if (n - i > 1 && lpszCommand[n] == '\"')
          i++;
        if (lpszCommand[i] != '\"' || lpszCommand[n] == '\0')
          n--;
        (*lpszArgv)[*lpnArgc] = MemoryAlloc ((n - i + 2) * sizeof (TCHAR));
        if (!(*lpszArgv)[*lpnArgc])
          {
#ifdef UNICODE
            MemoryFree (lpszCommand);
#endif /* UNICODE */
            return FALSE;
          }
        for (j = 0; j <= n - i; j++)
          *((*lpszArgv)[*lpnArgc] + j) = lpszCommand[i + j];
        *((*lpszArgv)[(*lpnArgc)++] + j) = '\0';
        i = n + 1;
        if (lpszCommand[i] == '\"')
          i++;
      }
    else if (lpszCommand[i] != ' ')
      {
        for (n = i + 1; lpszCommand[n] != '\0' && lpszCommand[n] != ' '; n++);
        (*lpszArgv)[*lpnArgc] = MemoryAlloc ((n - i + 1) * sizeof (TCHAR));
        if (!(*lpszArgv)[*lpnArgc])
          {
#ifdef UNICODE
            MomoryFree (lpszCommand);
#endif /* UNICODE */
            return FALSE;
          }
        for (j = 0; j < n - i; j++)
          *((*lpszArgv)[*lpnArgc] + j) = lpszCommand[i + j];
        *((*lpszArgv)[(*lpnArgc)++] + j) = '\0';
        i = n;
      }
    else
      {
        i++;
      }
#ifdef UNICODE
  MemoryFree (lpszCommand);
#endif /* UNICODE */
  return TRUE;
}


/*  ja:R}hC̊J
       nArgc,R}h̐
    lpszArgv,ւ̃|C^                                               */
VOID WINAPI
FreeArgument (int      nArgc,
              TCHAR ***lpszArgv)
{
  if (nArgc > 0)
    {
      int i;

      for (i = 0; i < nArgc; i++)
        MemoryFree ((*lpszArgv)[i]);
      MemoryFree (*lpszArgv);
    }
}
